/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import android.content.Context;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.IntervalLock;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.common.ValidBoolean;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.FrequencyUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.AdLoadManager;
import com.tradplus.ads.core.HbTokenManager;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.mobileads.util.TradPlusDataConstants;
import com.tradplus.ads.network.response.ConfigResponse;
import com.tradplus.ads.volley.VolleyError;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class AdMediationManager {
    private final long LOAD_FAIL_TIME_INTERVAL = 10000L;
    private final long LOAD_SUCCESS_BUT_NOT_SHOW_VALID = 240000L;
    private static ConcurrentHashMap<String, AdMediationManager> adMediationManagerMap = new ConcurrentHashMap();
    private String mAdUnitId;
    private boolean isLoading = false;
    private ValidBoolean loadSuccess;
    private IntervalLock intervalLock;

    private AdMediationManager(String string) {
        this.mAdUnitId = string;
        this.intervalLock = new IntervalLock(10000L);
        this.loadSuccess = new ValidBoolean(240000L);
    }

    public static synchronized AdMediationManager getInstance(String string) {
        AdMediationManager adMediationManager = adMediationManagerMap.get(string);
        if (adMediationManager == null) {
            adMediationManager = new AdMediationManager(string);
            adMediationManagerMap.put(string, adMediationManager);
        }
        return adMediationManager;
    }

    private void load(final LoadLifecycleCallback loadLifecycleCallback, final boolean bl) {
        TradPlus.invoker().checkSDKInit();
        ConfigLoadManager.getInstance().loadConfig(this.mAdUnitId, new ConfigLoadManager.ConfigLoadListener(){

            public final void onSuccess(ConfigResponse configResponse) {
                if (configResponse == null) {
                    loadLifecycleCallback.loadEndNoConfig();
                    return;
                }
                AdMediationManager.this.changeThreadAndLoadAd(configResponse, loadLifecycleCallback, bl);
            }

            public final void onFailed(VolleyError volleyError) {
                loadLifecycleCallback.loadEndNoConfig();
            }
        });
    }

    public void loadAd(LoadLifecycleCallback loadLifecycleCallback) {
        this.load(loadLifecycleCallback, false);
    }

    public void reloadAd(LoadLifecycleCallback loadLifecycleCallback) {
        this.load(loadLifecycleCallback, true);
    }

    private void changeThreadAndLoadAd(final ConfigResponse configResponse, final LoadLifecycleCallback loadLifecycleCallback, final boolean bl) {
        TPTaskManager.getInstance().runOnThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                AdMediationManager adMediationManager = AdMediationManager.this;
                synchronized (adMediationManager) {
                    loadLifecycleCallback.loadStart();
                    AdMediationManager.this.checkAndLoadAd(configResponse, loadLifecycleCallback, bl);
                    return;
                }
            }
        });
    }

    private void checkAndLoadAd(final ConfigResponse configResponse, final LoadLifecycleCallback loadLifecycleCallback, final boolean bl) {
        final int n = configResponse.getCacheNum();
        int n2 = 0;
        int n3 = 0;
        ArrayList arrayList = configResponse.getWaterfall();
        if (arrayList != null) {
            n2 = arrayList.size();
        }
        if ((arrayList = configResponse.getBiddingwaterfall()) != null) {
            n3 = arrayList.size();
        }
        if (n <= 0 || n2 <= 0 && n3 <= 0) {
            loadLifecycleCallback.loadEnd("9", bl);
            return;
        }
        if (this.checkFilter()) {
            loadLifecycleCallback.loadEnd("4", bl);
            return;
        }
        n = Math.min(n, n2 + n3);
        n2 = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId);
        LogUtil.ownShow((String)("AdMediationManager checkCacheFill hasCache:" + n2 + " needCache:" + n));
        if (n2 >= n && !bl) {
            loadLifecycleCallback.loadEnd("8", bl);
            return;
        }
        if (this.checkHadCache()) {
            loadLifecycleCallback.loadEnd("19", bl);
            return;
        }
        if (this.checkNetwork()) {
            loadLifecycleCallback.loadEnd("7", bl);
            return;
        }
        this.intervalLock.setExpireSecond(configResponse.getLoadFailedInterval());
        if (this.intervalLock.isLocked()) {
            loadLifecycleCallback.loadEnd("15", bl);
            return;
        }
        GlobalTradPlus.getInstance().setConfigParam(this.mAdUnitId, configResponse);
        HbTokenManager.getInstance(this.mAdUnitId).startBidding(configResponse, loadLifecycleCallback, new HbTokenManager.a(){

            @Override
            public final void a(ArrayList<ConfigResponse.WaterfallBean> arrayList) {
                if (arrayList == null || arrayList.size() <= 0) {
                    loadLifecycleCallback.loadEnd("103", bl);
                    return;
                }
                if ((arrayList = AdMediationManager.this.getLoadWaterfalls(configResponse, arrayList, bl)).size() == 0) {
                    loadLifecycleCallback.loadEnd("103", bl);
                    return;
                }
                int n2 = AdCacheManager.getInstance().getReadyAdNum(AdMediationManager.this.mAdUnitId);
                n2 = n - n2;
                if (arrayList.size() > 0 && bl) {
                    n2 = 1;
                }
                LogUtil.ownShow((String)("mediation reload = " + bl));
                new AdLoadManager(AdMediationManager.this.mAdUnitId, arrayList, n2, bl).loadWaterfall(loadLifecycleCallback);
            }
        });
    }

    private ArrayList<ConfigResponse.WaterfallBean> getLoadWaterfalls(ConfigResponse configResponse, ArrayList<ConfigResponse.WaterfallBean> arrayList, boolean n) {
        ArrayList<ConfigResponse.WaterfallBean> arrayList2 = new ArrayList<ConfigResponse.WaterfallBean>();
        configResponse = configResponse.getReload_config();
        if (n != 0 && configResponse != null) {
            int n2 = configResponse.getRequest_layer();
            if (n2 <= 0) {
                return arrayList2;
            }
            n2 = n2 > arrayList.size() ? arrayList.size() : n2;
            for (n = 0; n < n2; ++n) {
                arrayList2.add(arrayList.get(n));
            }
        } else {
            arrayList2.addAll(arrayList);
        }
        return arrayList2;
    }

    private boolean checkFilter() {
        Context context = GlobalTradPlus.getInstance().getContext();
        return !FrequencyUtils.getInstance().needFrequencyShow(context, this.mAdUnitId, TradPlusDataConstants.CACHETRADPLUSTYPE);
    }

    private boolean checkNetwork() {
        return !DeviceUtils.isNetworkAvailable((Context)GlobalTradPlus.getInstance().getContext());
    }

    private boolean checkHadCache() {
        int n = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId);
        LogUtil.ownShow((String)("AdMediationManager checkHadCache hasCache:" + n + " loadSuccessButNotShow:" + this.checkHasLoadSuccess()));
        return n > 0 && this.checkHasLoadSuccess();
    }

    public boolean checkIsLoading() {
        return this.isLoading;
    }

    public synchronized void setLoading(boolean bl) {
        this.isLoading = bl;
    }

    public boolean checkHasLoadSuccess() {
        return this.loadSuccess.checkResult();
    }

    public synchronized void setLoadSuccess(boolean bl) {
        this.loadSuccess.setResult(bl);
    }

    public synchronized void setAllLoadFail() {
        this.intervalLock.tryLock();
    }
}

