/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.common.Util;
import com.tradplus.ads.base.config.BiddingLoadManager;
import com.tradplus.ads.base.config.request.BiddingRequestInfo;
import com.tradplus.ads.base.config.response.BiddingResponse;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.NetWorkFrequencyUtils;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.HbLoadManager;
import com.tradplus.ads.core.factory.CustomEventFactory;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.mobileads.util.TradPlusInterstitialConstants;
import com.tradplus.ads.network.response.ConfigResponse;
import com.tradplus.ads.volley.NetworkError;
import com.tradplus.ads.volley.TimeoutError;
import com.tradplus.ads.volley.VolleyError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HbTokenManager {
    private static final int DEBUG_TIMEOUT_PAYLOAD = 300000;
    private static ConcurrentHashMap<String, HbTokenManager> hbTokenManagerMap = new ConcurrentHashMap();
    private String mAdUnitId;
    private ConfigResponse mResponse;
    private ConcurrentHashMap<String, BiddingResponse.PayLoadInfo> payLoadInfoHashMap = new ConcurrentHashMap();
    private a mListener;

    public static synchronized HbTokenManager getInstance(String string) {
        HbTokenManager hbTokenManager = hbTokenManagerMap.get(string);
        if (hbTokenManager == null) {
            hbTokenManager = new HbTokenManager(string);
            hbTokenManagerMap.put(string, hbTokenManager);
        }
        return hbTokenManager;
    }

    private HbTokenManager(String string) {
        this.mAdUnitId = string;
    }

    void startBidding(ConfigResponse object, LoadLifecycleCallback loadLifecycleCallback, a a2) {
        this.mResponse = object;
        this.mListener = a2;
        ArrayList arrayList = this.mResponse.getBiddingwaterfall();
        if (arrayList == null || arrayList.size() <= 0) {
            a2.a(object.getWaterfall());
            LogUtil.ownShow((String)"HbTokenManager startBidding hbBeans is null");
            return;
        }
        object = new ArrayList(arrayList);
        this.changeThreadAndRequest((ArrayList<ConfigResponse.WaterfallBean>)object, loadLifecycleCallback);
    }

    private void changeThreadAndRequest(final ArrayList<ConfigResponse.WaterfallBean> arrayList, final LoadLifecycleCallback loadLifecycleCallback) {
        TPTaskManager.getInstance().runOnThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                HbTokenManager hbTokenManager = HbTokenManager.this;
                synchronized (hbTokenManager) {
                    HbTokenManager.this.startRequestToken(arrayList, loadLifecycleCallback);
                    return;
                }
            }
        });
    }

    private void startRequestToken(ArrayList<ConfigResponse.WaterfallBean> arrayList, LoadLifecycleCallback loadLifecycleCallback) {
        Object object4;
        Object object2;
        Object object3;
        BiddingRequestInfo.BiddingWaterfall waterfallBean;
        BiddingRequestInfo biddingRequestInfo = BiddingRequestInfo.getBiddingInfo((String)this.mAdUnitId, (int)this.mResponse.getBiddingTimeout(), (String)loadLifecycleCallback.getRequestId());
        List list = biddingRequestInfo.getAdsourceplacements();
        HashMap<ConfigResponse.WaterfallBean, Long> hashMap = new HashMap<ConfigResponse.WaterfallBean, Long>();
        for (ConfigResponse.WaterfallBean object42 : arrayList) {
            if (!NetWorkFrequencyUtils.getInstance().checkNetworkFrequency(object42)) continue;
            if ("40".equals(object42.getId())) {
                this.prepareRequestInfo(biddingRequestInfo, object42);
            }
            LogUtil.ownShow((String)("requestInfo = " + JSON.toJSONString((Object)biddingRequestInfo)));
            waterfallBean = CustomEventFactory.create(object42.getCustomClassName());
            if (waterfallBean == null) continue;
            waterfallBean.initAdapter(this.mAdUnitId, object42, -1, null);
            object3 = waterfallBean.getBiddingToken();
            LogUtil.ownShow((String)"bidding token = ".concat(String.valueOf(object3)));
            object2 = waterfallBean.getNetworkVersion();
            object4 = new BiddingRequestInfo.AdSourcePlacements(object42, (String)object3, (String)object2);
            list.add(object4);
            loadLifecycleCallback.startBiddingEvent(object42);
            hashMap.put(object42, System.currentTimeMillis());
        }
        List list2 = biddingRequestInfo.getBiddingwaterfall();
        for (Object object4 : this.mResponse.getWaterfall()) {
            waterfallBean = new BiddingRequestInfo.BiddingWaterfall();
            waterfallBean.setId(Util.parseToInteger((String)object4.getAdsource_placement_id()));
            waterfallBean.setValue(String.valueOf(object4.getEcpm()));
            list2.add(waterfallBean);
        }
        Iterator<Map.Entry<String, BiddingResponse.PayLoadInfo>> iterator = this.payLoadInfoHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            boolean bl = false;
            object3 = arrayList.iterator();
            while (object3.hasNext()) {
                if (!object3.next().getAdsource_placement_id().equals(object4.getKey())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.sendLosNotification("102", (BiddingResponse.PayLoadInfo)object4.getValue(), loadLifecycleCallback);
            iterator.remove();
        }
        for (ConfigResponse.WaterfallBean waterfallBean2 : arrayList) {
            object3 = this.payLoadInfoHashMap.get(waterfallBean2.getAdsource_placement_id());
            if (this.checkPayLoadInfoValid((BiddingResponse.PayLoadInfo)object3)) {
                object2 = new BiddingRequestInfo.BiddingWaterfall();
                object2.setId(object3.getId());
                object2.setValue(object3.getExt().getValue());
                list2.add(object2);
                waterfallBean2.setPayLoadInfo(object3);
                continue;
            }
            if (object3 == null) continue;
            this.sendLosNotification("102", (BiddingResponse.PayLoadInfo)object3, loadLifecycleCallback);
        }
        if (list.size() <= 0) {
            this.mListener.a(this.mResponse.getWaterfall());
            LogUtil.ownShow((String)"HbTokenManager startRequestToken request list is null");
            return;
        }
        this.startBidding(biddingRequestInfo, loadLifecycleCallback, hashMap);
    }

    private void startBidding(BiddingRequestInfo biddingRequestInfo, final LoadLifecycleCallback loadLifecycleCallback, final HashMap<ConfigResponse.WaterfallBean, Long> hashMap) {
        BiddingLoadManager.getInstance().loadBiddingRequest(biddingRequestInfo, new BiddingLoadManager.BiddingLoadListener(){

            public final void onSuccess(BiddingResponse biddingResponse) {
                HbTokenManager.this.mergeHbWaterfall(biddingResponse, loadLifecycleCallback);
                HbTokenManager.this.trackBiddingEndEvent(biddingResponse, hashMap, loadLifecycleCallback);
            }

            public final void onFailed(VolleyError volleyError) {
                if (volleyError != null) {
                    LogUtil.ownShow((String)("HbTokenManager startBidding onFailed error:" + volleyError.getMessage()));
                }
                HbTokenManager.this.trackBiddingEndEvent(null, hashMap, loadLifecycleCallback);
                HbTokenManager.this.mListener.a(HbTokenManager.this.mResponse.getWaterfall());
            }
        });
    }

    private void mergeHbWaterfall(BiddingResponse biddingResponse, LoadLifecycleCallback object) {
        Object object22;
        Object object32;
        if (biddingResponse == null) {
            this.mListener.a(this.mResponse.getWaterfall());
            LogUtil.ownShow((String)"HbTokenManager mergeHbWaterfall response is null");
            return;
        }
        ArrayList arrayList = biddingResponse.getAdsourceplacements();
        if (arrayList == null || arrayList.size() <= 0) {
            this.mListener.a(this.mResponse.getWaterfall());
            LogUtil.ownShow((String)"HbTokenManager mergeHbWaterfall response Adsourceplacements is null");
            return;
        }
        for (Object object32 : this.mResponse.getBiddingwaterfall()) {
            for (Object object22 : arrayList) {
                if (!object32.getAdsource_placement_id().equals(String.valueOf(object22.getId()))) continue;
                this.checkAndStartCountdown((ConfigResponse.WaterfallBean)object32, (BiddingResponse.PayLoadInfo)object22, (LoadLifecycleCallback)object);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        object32 = new ArrayList();
        arrayList2.addAll(this.mResponse.getWaterfall());
        arrayList2.addAll(this.mResponse.getBiddingwaterfall());
        ArrayList arrayList3 = biddingResponse.getBiddingWaterfall();
        if (arrayList3 == null || arrayList3.size() <= 0) {
            this.mListener.a(this.mResponse.getWaterfall());
            LogUtil.ownShow((String)"HbTokenManager mergeHbWaterfall response biddingWaterfall is null");
            return;
        }
        object22 = arrayList3.iterator();
        block2: while (object22.hasNext()) {
            biddingResponse = (BiddingResponse.BiddingWaterfall)object22.next();
            object = arrayList2.iterator();
            while (object.hasNext()) {
                arrayList = (ConfigResponse.WaterfallBean)object.next();
                if (arrayList.getNew_sort_type() == 9 && !this.checkPayLoadInfoValid(arrayList.getPayLoadInfo())) {
                    LogUtil.ownShow((String)("HbTokenManager mergeHbWaterfall bidWaterfall payload is null break\uff1a" + arrayList.getAdsource_placement_id()));
                    continue;
                }
                if (!arrayList.getAdsource_placement_id().equals(String.valueOf(biddingResponse.getId()))) continue;
                ((ArrayList)object32).add(arrayList);
                continue block2;
            }
        }
        LogUtil.ownShow((String)"HbTokenManager mergeHbWaterfall result waterfall:");
        LogUtil.ownShow((String)JSON.toJSONString((Object)object32));
        this.mListener.a((ArrayList<ConfigResponse.WaterfallBean>)object32);
    }

    private void startLoadHbAd(ArrayList<ConfigResponse.WaterfallBean> arrayList, LoadLifecycleCallback loadLifecycleCallback) {
        new HbLoadManager(this.mAdUnitId, arrayList, this.mResponse.getCacheNum(), this.mResponse.getHbCacheNum()).loadHbAd(loadLifecycleCallback);
    }

    private boolean checkAndStartCountdown(ConfigResponse.WaterfallBean waterfallBean, final BiddingResponse.PayLoadInfo payLoadInfo, final LoadLifecycleCallback loadLifecycleCallback) {
        if (payLoadInfo != null && payLoadInfo.getIsbid() == 1 && payLoadInfo.getNbr() == 35) {
            loadLifecycleCallback.sendLossNotification(waterfallBean, "1", "102");
            return false;
        }
        if (payLoadInfo != null && payLoadInfo.getNbr() == 40) {
            BiddingResponse.PayLoadInfo payLoadInfo2 = this.payLoadInfoHashMap.get(waterfallBean.getAdsource_placement_id());
            if (payLoadInfo2 != null) {
                boolean bl = AdCacheManager.getInstance().removeHbCache(this.mAdUnitId, payLoadInfo2);
                this.sendLosNotification(bl ? "4902" : "102", payLoadInfo2, loadLifecycleCallback);
            } else {
                loadLifecycleCallback.sendLossNotification(waterfallBean, "1", "102");
            }
            return false;
        }
        if (!this.checkPayLoadInfoValid(payLoadInfo)) {
            return false;
        }
        long l = waterfallBean.getPayloadTimeout() * 1000L;
        if (TradPlus.getLocalDebugMode()) {
            l = 300000L;
        }
        payLoadInfo.setValidTime(l);
        payLoadInfo.setStartTime(System.currentTimeMillis());
        BiddingResponse.PayLoadInfo payLoadInfo3 = this.payLoadInfoHashMap.get(waterfallBean.getAdsource_placement_id());
        if (payLoadInfo3 != null) {
            payLoadInfo3.setHighPrice(payLoadInfo.getExt().getValue());
            boolean bl = AdCacheManager.getInstance().removeHbCache(this.mAdUnitId, payLoadInfo3);
            this.sendLosNotification(bl ? "4902" : "102", payLoadInfo3, loadLifecycleCallback);
        }
        this.payLoadInfoHashMap.put(waterfallBean.getAdsource_placement_id(), payLoadInfo);
        waterfallBean.setPayLoadInfo(payLoadInfo);
        Runnable runnable = new Runnable(){

            @Override
            public final void run() {
                LogUtil.ownShow((String)("HbTokenManager checkAndStartCountdown check timeout" + payLoadInfo.getId() + " is wined " + payLoadInfo.isWined()));
                if (HbTokenManager.this.payLoadInfoHashMap.containsValue(payLoadInfo) && !payLoadInfo.isWined()) {
                    HbTokenManager.this.sendLosNotification("102", payLoadInfo, loadLifecycleCallback);
                }
            }
        };
        TPTaskManager.getInstance().runOnThreadDelayed(runnable, l);
        return true;
    }

    public void sendLosNotification(final String string, final BiddingResponse.PayLoadInfo payLoadInfo, final LoadLifecycleCallback loadLifecycleCallback) {
        String string2 = payLoadInfo.getExt().getValue();
        if ("102".equals(string)) {
            string2 = payLoadInfo.getHighPrice();
        }
        this.payLoadInfoHashMap.remove(String.valueOf(payLoadInfo.getId()));
        BiddingLoadManager.getInstance().biddingNotification(string, string2, payLoadInfo.getLurl(), new BiddingLoadManager.BiddingNotificationListener(){

            public final void onSuccess(String string2) {
                loadLifecycleCallback.sendLossNotification(HbTokenManager.this.getWaterfallBeanByPayLoad(payLoadInfo), "1", string);
            }

            public final void onFailed(VolleyError volleyError) {
                String string2 = "2";
                if (volleyError instanceof TimeoutError) {
                    string2 = "3";
                } else if (volleyError instanceof NetworkError) {
                    string2 = "7";
                }
                loadLifecycleCallback.sendLossNotification(HbTokenManager.this.getWaterfallBeanByPayLoad(payLoadInfo), string2, string);
            }
        });
    }

    private ConfigResponse.WaterfallBean getWaterfallBeanByPayLoad(BiddingResponse.PayLoadInfo payLoadInfo) {
        if (this.mResponse != null && payLoadInfo != null) {
            for (ConfigResponse.WaterfallBean waterfallBean : this.mResponse.getBiddingwaterfall()) {
                if (!waterfallBean.getAdsource_placement_id().equals(String.valueOf(payLoadInfo.getId()))) continue;
                return waterfallBean;
            }
        }
        return null;
    }

    public void sendWinOrDisplayNotification(final boolean bl, final ConfigResponse.WaterfallBean waterfallBean, final LoadLifecycleCallback loadLifecycleCallback) {
        BiddingResponse.PayLoadInfo payLoadInfo = waterfallBean.getPayLoadInfo();
        String string = payLoadInfo.getExt().getValue();
        BiddingLoadManager biddingLoadManager = BiddingLoadManager.getInstance();
        if (!bl) {
            this.payLoadInfoHashMap.remove(String.valueOf(payLoadInfo.getId()));
        } else {
            payLoadInfo.setWined(true);
        }
        biddingLoadManager.biddingNotification("0", string, bl ? payLoadInfo.getNurl() : payLoadInfo.getImpurl(), new BiddingLoadManager.BiddingNotificationListener(){

            public final void onSuccess(String string) {
                if (bl) {
                    loadLifecycleCallback.sendWinNotification(waterfallBean, "1");
                    return;
                }
                loadLifecycleCallback.sendDisPlayNotification(waterfallBean, "1");
            }

            public final void onFailed(VolleyError volleyError) {
                String string = "2";
                if (volleyError instanceof TimeoutError) {
                    string = "3";
                } else if (volleyError instanceof NetworkError) {
                    string = "7";
                }
                if (bl) {
                    loadLifecycleCallback.sendWinNotification(waterfallBean, string);
                    return;
                }
                loadLifecycleCallback.sendDisPlayNotification(waterfallBean, string);
            }
        });
    }

    public boolean checkPayLoadInfoExist(ConfigResponse.WaterfallBean waterfallBean) {
        if (waterfallBean == null) {
            return false;
        }
        if (waterfallBean.getPayLoadInfo() != null) {
            if ((waterfallBean = this.payLoadInfoHashMap.get(waterfallBean.getAdsource_placement_id())) == null) {
                return false;
            }
            return waterfallBean.getAdm() != null || waterfallBean.getPayload() != null;
        }
        return true;
    }

    private boolean checkPayLoadInfoValid(BiddingResponse.PayLoadInfo payLoadInfo) {
        if (payLoadInfo == null) {
            return false;
        }
        if (payLoadInfo.getAdm() == null && payLoadInfo.getPayload() == null) {
            return false;
        }
        if (payLoadInfo.getIsbid() != 1) {
            return false;
        }
        if (AdCacheManager.getInstance().isExistHbCache(this.mAdUnitId, payLoadInfo) != null) {
            return true;
        }
        long l = payLoadInfo.getStartTime();
        long l2 = payLoadInfo.getValidTime();
        if (l == 0L) {
            return true;
        }
        LogUtil.ownShow((String)("HbTokenManager checkPayLoadInfoValid startTime:" + l + " validTime:" + l2));
        return l + l2 >= System.currentTimeMillis();
    }

    private void trackBiddingEndEvent(BiddingResponse biddingResponse, HashMap<ConfigResponse.WaterfallBean, Long> object, LoadLifecycleCallback loadLifecycleCallback) {
        for (Map.Entry entry : ((HashMap)((Object)object)).entrySet()) {
            if (biddingResponse == null) {
                loadLifecycleCallback.endBiddingEvent((ConfigResponse.WaterfallBean)entry.getKey(), null, (Long)entry.getValue());
                continue;
            }
            Object object2 = biddingResponse.getAdsourceplacements();
            if (object2 == null || ((ArrayList)object2).size() <= 0) continue;
            object2 = ((ArrayList)object2).iterator();
            while (object2.hasNext()) {
                BiddingResponse.PayLoadInfo payLoadInfo = (BiddingResponse.PayLoadInfo)object2.next();
                if (!((ConfigResponse.WaterfallBean)entry.getKey()).getAdsource_placement_id().equals(String.valueOf(payLoadInfo.getId()))) continue;
                loadLifecycleCallback.endBiddingEvent((ConfigResponse.WaterfallBean)entry.getKey(), payLoadInfo, (Long)entry.getValue());
            }
        }
    }

    private void prepareRequestInfo(BiddingRequestInfo biddingRequestInfo, ConfigResponse.WaterfallBean waterfallBean) {
        if (TradPlusInterstitialConstants.isBannerType((String)this.mResponse.getAdType())) {
            BiddingRequestInfo.Imp.Banner banner = new BiddingRequestInfo.Imp.Banner();
            banner.setW(waterfallBean.getAd_size_info().getX());
            banner.setH(waterfallBean.getAd_size_info().getY());
            ((BiddingRequestInfo.Imp)biddingRequestInfo.getImp().get(0)).setBanner(banner);
            return;
        }
        if (TradPlusInterstitialConstants.isRewardType((String)this.mResponse.getAdType()) || TradPlusInterstitialConstants.isInterstitialType((String)this.mResponse.getAdType())) {
            if (TradPlusInterstitialConstants.isInterstitialType((String)this.mResponse.getAdType())) {
                ((BiddingRequestInfo.Imp)biddingRequestInfo.getImp().get(0)).setInstl(1);
                BiddingRequestInfo.Imp.Banner banner = new BiddingRequestInfo.Imp.Banner();
                banner.setW(320);
                banner.setH(50);
                ((BiddingRequestInfo.Imp)biddingRequestInfo.getImp().get(0)).setBanner(banner);
                return;
            }
            BiddingRequestInfo.Imp.Video video = new BiddingRequestInfo.Imp.Video(TradPlusInterstitialConstants.isRewardType((String)this.mResponse.getAdType()) ? 1 : 0);
            ((BiddingRequestInfo.Imp)biddingRequestInfo.getImp().get(0)).setVideo(video);
            return;
        }
        if (TradPlusInterstitialConstants.isNativeType((String)this.mResponse.getAdType())) {
            BiddingRequestInfo.Imp.NativeAd nativeAd = new BiddingRequestInfo.Imp.NativeAd();
            ((BiddingRequestInfo.Imp)biddingRequestInfo.getImp().get(0)).setNativead(nativeAd);
        }
    }

    static interface a {
        public void a(ArrayList<ConfigResponse.WaterfallBean> var1);
    }
}

