/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import com.tradplus.ads.network.response.ConfigResponse;
import java.util.concurrent.ConcurrentHashMap;

public class AdIntervalManager {
    private int requestFailedNum;
    private long interval;
    private int maxFailedNum;
    private long failedTime;
    private static ConcurrentHashMap<String, AdIntervalManager> adIntervalManagerConcurrentHashMap = new ConcurrentHashMap();

    public static synchronized AdIntervalManager getInstance(ConfigResponse.WaterfallBean waterfallBean) {
        if (waterfallBean == null) {
            return null;
        }
        String string = waterfallBean.getAdsource_placement_id();
        AdIntervalManager adIntervalManager = adIntervalManagerConcurrentHashMap.get(string);
        if (adIntervalManager == null) {
            adIntervalManager = new AdIntervalManager(waterfallBean);
            adIntervalManagerConcurrentHashMap.put(string, adIntervalManager);
        }
        return adIntervalManager;
    }

    private AdIntervalManager(ConfigResponse.WaterfallBean waterfallBean) {
        waterfallBean = waterfallBean.getRequest_interval_config();
        if (waterfallBean == null) {
            return;
        }
        this.maxFailedNum = waterfallBean.getRequest_no_fill_num();
        this.interval = waterfallBean.getRequest_interval();
    }

    public boolean canLoadToWaterfall() {
        if (this.maxFailedNum == 0) {
            return true;
        }
        if (this.requestFailedNum >= this.maxFailedNum) {
            if (System.currentTimeMillis() - this.failedTime >= this.interval * 1000L) {
                this.requestFailedNum = 0;
                this.failedTime = 0L;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public void loadWaterfallFailed() {
        ++this.requestFailedNum;
        this.failedTime = System.currentTimeMillis();
    }

    public void loadWaterfallLoaded() {
        this.requestFailedNum = 0;
        this.failedTime = 0L;
    }

    public int getRequestFailedNum() {
        return this.requestFailedNum;
    }

    public void setRequestFailedNum(int n) {
        this.requestFailedNum = n;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long l) {
        this.interval = l;
    }

    public int getMaxFailedNum() {
        return this.maxFailedNum;
    }

    public void setMaxFailedNum(int n) {
        this.maxFailedNum = n;
    }

    public long getFailedTime() {
        return this.failedTime;
    }

    public void setFailedTime(long l) {
        this.failedTime = l;
    }
}

