/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core.track;

import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPShowAdapterListener;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import java.util.Map;

public class ShowAdListener
implements TPShowAdapterListener {
    private LoadLifecycleCallback mCallback;
    private String mAdSceneId;
    private TPBaseAdapter mAdapter;
    private boolean isCallbackShow;
    private boolean isCallbackAgainShow;

    public ShowAdListener(LoadLifecycleCallback loadLifecycleCallback, TPBaseAdapter tPBaseAdapter, String string) {
        this.mCallback = loadLifecycleCallback;
        this.mAdSceneId = string;
        this.mAdapter = tPBaseAdapter;
    }

    public void onAdShown() {
        if (this.isCallbackShow) {
            return;
        }
        this.isCallbackShow = true;
        if (this.mCallback != null) {
            this.mCallback.adImpression(this.mAdapter, this.mAdSceneId, false);
        }
    }

    public void onAdAgainShown() {
        if (this.isCallbackAgainShow) {
            return;
        }
        this.isCallbackAgainShow = true;
        if (this.mCallback != null) {
            this.mCallback.adImpression(this.mAdapter, this.mAdSceneId, true);
        }
    }

    public void onAdClicked() {
        if (this.mCallback != null) {
            this.mCallback.adClicked(this.mAdapter, this.mAdSceneId, false);
        }
    }

    public void onAdClosed() {
        if (this.mCallback != null) {
            this.mCallback.videoEnd(this.mAdapter, this.mAdSceneId);
        }
        try {
            this.mAdapter.clean();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void onAdVideoStart() {
        if (this.mCallback != null) {
            this.mCallback.onAdVideoStart(this.mAdapter, this.mAdSceneId, false);
        }
    }

    public void onAdAgainVideoStart() {
        if (this.mCallback != null) {
            this.mCallback.onAdVideoStart(this.mAdapter, this.mAdSceneId, true);
        }
    }

    public void onAdVideoEnd() {
        if (this.mCallback != null) {
            this.mCallback.onAdVideoEnd(this.mAdapter, this.mAdSceneId, false);
        }
    }

    public void onAdAgainVideoEnd() {
        if (this.mCallback != null) {
            this.mCallback.onAdVideoEnd(this.mAdapter, this.mAdSceneId, true);
        }
    }

    public void onAdVideoError(TPError tPError) {
        if (this.mCallback != null) {
            if (tPError == null) {
                tPError = new TPError("Unspecified error.");
            }
            this.mCallback.videoError(this.mAdapter, this.mAdSceneId, tPError.getTpErrorCode(), tPError.getErrorMessage());
        }
    }

    public void onAdVideoClicked() {
        if (this.mCallback != null) {
            this.mCallback.adClicked(this.mAdapter, this.mAdSceneId, false);
        }
    }

    public void onAdAgainVideoClicked() {
        if (this.mCallback != null) {
            this.mCallback.adClicked(this.mAdapter, this.mAdSceneId, true);
        }
    }

    public void onReward() {
        if (this.mCallback != null) {
            this.mCallback.reward(this.mAdapter, this.mAdSceneId);
        }
    }

    public void onPlayAgainReward() {
        if (this.mCallback != null) {
            this.mCallback.reward(this.mAdapter, this.mAdSceneId, true);
        }
    }

    public void onReward(Map<String, Object> map) {
        if (this.mCallback != null) {
            this.mCallback.reward(this.mAdapter, this.mAdSceneId, map);
        }
    }

    public void onReward(String string, int n) {
        if (this.mCallback != null) {
            this.mCallback.reward(this.mAdapter, this.mAdSceneId, string, n, null, false);
        }
    }

    public void onPlayAgainReward(Map<String, Object> map) {
        if (this.mCallback != null) {
            this.mCallback.reward(this.mAdapter, this.mAdSceneId, map, true);
        }
    }

    public void onPlayAgainReward(String string, int n) {
        if (this.mCallback != null) {
            this.mCallback.reward(this.mAdapter, this.mAdSceneId, string, n, null, true);
        }
    }

    public void onRewardSkip() {
        if (this.mCallback != null) {
            this.mCallback.rewardSkip(this.mAdapter);
        }
    }

    public void onZoomOutStart() {
        if (this.mCallback != null) {
            this.mCallback.zoomOutStart(this.mAdapter);
        }
    }

    public void onZoomOutEnd() {
        if (this.mCallback != null) {
            this.mCallback.zoomOutEnd(this.mAdapter);
        }
    }

    public void onAdVideoProgress(int n) {
        if (this.mCallback != null) {
            this.mCallback.videoProgress();
        }
    }

    public void onAdDislikeButtonClick() {
        if (this.mCallback != null) {
            this.mCallback.dislikeClicked();
        }
    }

    public void onTick(long l) {
        if (this.mCallback != null) {
            this.mCallback.splashAdTick(l);
        }
    }
}

