/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPLoadAdapterListener;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.LoadMode;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.config.response.BiddingResponse;
import com.tradplus.ads.base.filter.NetWorkFrequencyUtils;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.AdIntervalManager;
import com.tradplus.ads.core.AdMediationManager;
import com.tradplus.ads.core.HbTokenManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.factory.CustomEventFactory;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AdLoadManager {
    private static final int LOAD_STATUS_SUCCESS = 1;
    private static final int LOAD_STATUS_HAS_CACHE = 2;
    private static final int LOAD_STATUS_FAILED = 0;
    private static final int DEFAULT_INTERSTITIAL_TIMEOUT_DELAY = 60000;
    private ArrayList<ConfigResponse.WaterfallBean> mWaterfallBeans;
    private String mAdUnitId;
    private int mCacheNum;
    private volatile int currentIndex;
    private HashMap<ConfigResponse.WaterfallBean, Integer> mLoadFinishLayers;
    private ConcurrentHashMap<String, Runnable> mOverTimeMap;
    private Handler mThreadHandler;
    private int op;
    private LoadMode loadMode;
    private int[] cacheIndex;

    AdLoadManager(String string, ArrayList<ConfigResponse.WaterfallBean> arrayList, int n, int n2, LoadMode loadMode) {
        this.mWaterfallBeans = arrayList;
        this.mCacheNum = n;
        this.mAdUnitId = string;
        this.mThreadHandler = TPTaskManager.getInstance().getThresholdThreadHandler();
        this.mOverTimeMap = new ConcurrentHashMap();
        this.mLoadFinishLayers = new HashMap();
        this.op = n2;
        this.loadMode = loadMode;
    }

    void loadWaterfall(LoadLifecycleCallback loadLifecycleCallback) {
        this.currentIndex = 0;
        this.mLoadFinishLayers.clear();
        this.checkCacheIndex(loadLifecycleCallback);
        if (this.mCacheNum > this.mWaterfallBeans.size()) {
            this.mCacheNum = this.mWaterfallBeans.size();
        }
        for (int i = 0; i < this.mCacheNum; ++i) {
            AdLoadManager adLoadManager = this;
            adLoadManager.loadLayerAd(adLoadManager.currentIndex++, loadLifecycleCallback);
        }
    }

    public void checkCacheIndex(LoadLifecycleCallback loadLifecycleCallback) {
        if (this.loadMode != LoadMode.SPEED) {
            return;
        }
        for (int i = 0; i < this.mWaterfallBeans.size(); ++i) {
            ConfigResponse.WaterfallBean waterfallBean = this.mWaterfallBeans.get(i);
            AdCache adCache = AdCacheManager.getInstance().isExistCache(this.mAdUnitId, waterfallBean);
            if (adCache == null) continue;
            if (this.cacheIndex == null) {
                this.cacheIndex = new int[this.mWaterfallBeans.size()];
            }
            this.currentLayerHasCache(adCache, waterfallBean, loadLifecycleCallback);
            this.cacheIndex[i] = 1;
        }
    }

    private void loadLayerAd(int n, LoadLifecycleCallback loadLifecycleCallback) {
        if (n >= this.mWaterfallBeans.size()) {
            return;
        }
        ConfigResponse.WaterfallBean waterfallBean = this.mWaterfallBeans.get(n);
        if (this.cacheIndex != null && this.cacheIndex[n] == 1) {
            return;
        }
        if (waterfallBean == null) {
            this.loadAdLoadFailed(null, null, loadLifecycleCallback, "9", null);
            return;
        }
        if (!NetWorkFrequencyUtils.getInstance().checkNetworkFrequency(waterfallBean)) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "4", null);
            return;
        }
        Object object = AdCacheManager.getInstance().isExistCache(this.mAdUnitId, waterfallBean);
        if (object != null) {
            this.currentLayerHasCache((AdCache)object, waterfallBean, loadLifecycleCallback);
            return;
        }
        object = waterfallBean.getCustomClassName();
        object = waterfallBean.getC2sAdapter() != null ? waterfallBean.getC2sAdapter() : CustomEventFactory.create((String)object);
        if (object == null) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "13", null);
            return;
        }
        if (!HbTokenManager.checkPayLoadInfoExist(waterfallBean)) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "17", null);
            return;
        }
        Object object2 = AdIntervalManager.getInstance(waterfallBean);
        if (object2 != null && !((AdIntervalManager)object2).canLoadToWaterfall()) {
            this.loadAdLoadFailed(waterfallBean, null, loadLifecycleCallback, "1107", null);
            return;
        }
        object2 = new a((TPBaseAdapter)object, loadLifecycleCallback);
        int n2 = this.mWaterfallBeans.indexOf(waterfallBean);
        object.setRequestId(loadLifecycleCallback.getRequestId());
        object.initAdapter(this.mAdUnitId, waterfallBean, n2, (TPLoadAdapterListener)object2);
        if (waterfallBean.getIs_main_thread() == 0) {
            this.loadAdapterOnThread((TPBaseAdapter)object, loadLifecycleCallback, waterfallBean);
            return;
        }
        this.loadAdapterOnMainThread((TPBaseAdapter)object, loadLifecycleCallback, waterfallBean);
    }

    private void loadAdapterOnMainThread(final TPBaseAdapter tPBaseAdapter, final LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        TPTaskManager.getInstance().runOnMainThread(new Runnable(){

            @Override
            public final void run() {
                try {
                    AdLoadManager.this.startOverTimeRunnable(tPBaseAdapter, loadLifecycleCallback, waterfallBean);
                    loadLifecycleCallback.loadNetWorkStart(tPBaseAdapter);
                    tPBaseAdapter.loadAd();
                    return;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    AdLoadManager.this.loadAdLoadFailed(waterfallBean, tPBaseAdapter, loadLifecycleCallback, "18", null);
                    return;
                }
            }
        });
    }

    private void loadAdapterOnThread(final TPBaseAdapter tPBaseAdapter, final LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        TPTaskManager.getInstance().runDyCorePool(new Runnable(){

            @Override
            public final void run() {
                try {
                    AdLoadManager.this.startOverTimeRunnable(tPBaseAdapter, loadLifecycleCallback, waterfallBean);
                    loadLifecycleCallback.loadNetWorkStart(tPBaseAdapter);
                    tPBaseAdapter.loadAd();
                    return;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    AdLoadManager.this.loadAdLoadFailed(waterfallBean, tPBaseAdapter, loadLifecycleCallback, "18", null);
                    return;
                }
            }
        });
    }

    private void startOverTimeRunnable(TPBaseAdapter object, LoadLifecycleCallback loadLifecycleCallback, final ConfigResponse.WaterfallBean waterfallBean) {
        object = new Runnable((TPBaseAdapter)object, loadLifecycleCallback){
            final /* synthetic */ TPBaseAdapter b;
            final /* synthetic */ LoadLifecycleCallback c;
            {
                this.b = tPBaseAdapter;
                this.c = loadLifecycleCallback;
            }

            @Override
            public final void run() {
                AdIntervalManager adIntervalManager;
                AdLoadManager.this.endOverTimeRunnable(waterfallBean.getAdsource_placement_id());
                if (!AdLoadManager.this.mLoadFinishLayers.containsKey(this.b.getWaterfallBean()) && (adIntervalManager = AdIntervalManager.getInstance(this.b.getWaterfallBean())) != null) {
                    adIntervalManager.loadWaterfallFailed();
                }
                AdLoadManager.this.loadAdLoadFailed(waterfallBean, this.b, this.c, "3", AdLoadManager.this.getErrorMessage());
            }
        };
        long l = 60000L;
        if (waterfallBean.getLoadTimeout() > 0L && waterfallBean.getLoadTimeout() <= 300L) {
            l = waterfallBean.getLoadTimeout() * 1000L;
        }
        LogUtil.ownShow((String)"AdLoadManager startOverTimeRunnable timeout:".concat(String.valueOf(l)));
        this.mThreadHandler.postDelayed((Runnable)object, l);
        this.mOverTimeMap.put(waterfallBean.getAdsource_placement_id(), (Runnable)object);
    }

    private String getErrorMessage() {
        if (!DeviceUtils.isNetworkAvailable((Context)GlobalTradPlus.getInstance().getContext())) {
            TPError tPError = new TPError();
            tPError.setErrorMessage("Network is unavailable.");
            tPError.setErrorCode("7");
            return tPError.getEmsg();
        }
        return null;
    }

    private void endOverTimeRunnable(String string) {
        Runnable runnable = this.mOverTimeMap.get(string);
        if (runnable != null) {
            this.mThreadHandler.removeCallbacks(runnable);
        }
        this.mOverTimeMap.remove(string);
    }

    private synchronized void loadAdLoaded(TPBaseAd tPBaseAd, TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback) {
        int n;
        int n2;
        ConfigResponse.WaterfallBean waterfallBean = tPBaseAdapter.getWaterfallBean();
        if (this.mLoadFinishLayers.containsKey(waterfallBean)) {
            return;
        }
        this.mLoadFinishLayers.put(waterfallBean, 1);
        this.endOverTimeRunnable(tPBaseAdapter.getAdSourcePid());
        this.saveHighPrice(waterfallBean);
        AdIntervalManager adIntervalManager = AdIntervalManager.getInstance(waterfallBean);
        if (adIntervalManager != null) {
            adIntervalManager.loadWaterfallLoaded();
        }
        if (AdMediationManager.isReload(this.op) && (adIntervalManager = ConfigLoadManager.getInstance().getLocalConfigResponse(this.mAdUnitId)) != null && (n2 = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId)) >= (n = adIntervalManager.getCacheNum())) {
            AdCacheManager.getInstance().removeEndCache(this.mAdUnitId, n2 - n);
        }
        Object object = new AdCache();
        ((AdCache)object).setAdapter(tPBaseAdapter);
        ((AdCache)object).setAdObj(tPBaseAd);
        ((AdCache)object).setCallback(loadLifecycleCallback);
        ((AdCache)object).setConfigBean(waterfallBean);
        ((AdCache)object).setStatus(0);
        AdCacheManager.getInstance().saveWaterfallCache(this.mAdUnitId, (AdCache)object, this.mWaterfallBeans.indexOf(waterfallBean));
        loadLifecycleCallback.loadNetWorkEnd((AdCache)object, tPBaseAdapter.getWaterfallBean(), tPBaseAdapter, "1", null);
        if (!TextUtils.isEmpty((CharSequence)tPBaseAdapter.getPayLoadStr()) || waterfallBean.getC2sAdapter() != null) {
            HbTokenManager.sendWinOrDisplayNotification(true, tPBaseAdapter, loadLifecycleCallback);
        }
        n2 = 0;
        object = this.mLoadFinishLayers.entrySet().iterator();
        while (object.hasNext()) {
            if ((Integer)((Map.Entry)object.next()).getValue() != 1) continue;
            ++n2;
        }
        if (n2 == this.mCacheNum || this.mLoadFinishLayers.size() == this.mWaterfallBeans.size()) {
            loadLifecycleCallback.loadAllNetwork("1", AdMediationManager.isReload(this.op), this.op);
            HbTokenManager.removeUnLoadBiddingPayload(this.mAdUnitId, this.currentIndex, this.mWaterfallBeans, loadLifecycleCallback);
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void loadAdLoadFailed(ConfigResponse.WaterfallBean object, TPBaseAdapter object22, LoadLifecycleCallback loadLifecycleCallback, String string, String string2) {
        void var5_7;
        void var3_5;
        String string3;
        if (object == null) {
            this.mLoadFinishLayers.put(new ConfigResponse.WaterfallBean(), 0);
        } else {
            if (this.mLoadFinishLayers.containsKey(object)) {
                return;
            }
            this.mLoadFinishLayers.put((ConfigResponse.WaterfallBean)object, 0);
            this.endOverTimeRunnable(object.getAdsource_placement_id());
            if (object.getPayLoadInfo() != null && object.getC2sAdapter() == null && TextUtils.equals((CharSequence)"2", (CharSequence)string3)) {
                HbTokenManager.sendLosNotification("1", (ConfigResponse.WaterfallBean)object, (LoadLifecycleCallback)var3_5);
                object.setPayLoadInfo(null);
            }
        }
        var3_5.loadNetWorkEnd(null, (ConfigResponse.WaterfallBean)object, (TPBaseAdapter)object22, string3, (String)var5_7);
        if (this.mLoadFinishLayers.size() == this.mWaterfallBeans.size()) {
            for (Map.Entry entry : this.mLoadFinishLayers.entrySet()) {
                if ((Integer)entry.getValue() != 1 && (Integer)entry.getValue() != 2) continue;
                var3_5.loadAllNetwork("1", AdMediationManager.isReload(this.op), this.op);
                HbTokenManager.removeUnLoadBiddingPayload(this.mAdUnitId, this.currentIndex, this.mWaterfallBeans, (LoadLifecycleCallback)var3_5);
                return;
            }
            object = AdCacheManager.getInstance().getBottomCacheAd(this.mAdUnitId);
            string3 = "11";
            if (!"1".equals(string3) && object != null) {
                if (((AdCache)object).isBottomWaterfall()) {
                    ((AdCache)object).setEffectTime(0L);
                    var3_5.loadAdLoaded((AdCache)object);
                }
                string3 = "1";
            }
            var3_5.loadAllNetwork(string3, AdMediationManager.isReload(this.op), this.op);
            HbTokenManager.removeUnLoadBiddingPayload(this.mAdUnitId, 0, this.mWaterfallBeans, (LoadLifecycleCallback)var3_5);
            return;
        }
        if (this.currentIndex >= this.mWaterfallBeans.size()) {
            return;
        }
        AdLoadManager adLoadManager = this;
        adLoadManager.loadLayerAd(adLoadManager.currentIndex++, (LoadLifecycleCallback)var3_5);
    }

    private void currentLayerHasCache(AdCache adCache, ConfigResponse.WaterfallBean waterfallBean, LoadLifecycleCallback loadLifecycleCallback) {
        AdCacheManager.getInstance().removeCache(this.mAdUnitId, waterfallBean.getAdsource_placement_id());
        AdCacheManager.getInstance().saveWaterfallCache(this.mAdUnitId, adCache, this.mWaterfallBeans.indexOf(waterfallBean));
        loadLifecycleCallback.currentLayerHasCache(adCache);
        this.mLoadFinishLayers.put(waterfallBean, 2);
        int n = 0;
        Iterator<Map.Entry<ConfigResponse.WaterfallBean, Integer>> iterator = this.mLoadFinishLayers.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue() != 1) continue;
            ++n;
        }
        this.saveHighPrice(waterfallBean);
        if (n == this.mCacheNum || this.mLoadFinishLayers.size() == this.mWaterfallBeans.size() || AdMediationManager.isReload(this.op)) {
            loadLifecycleCallback.loadAllNetwork("1", AdMediationManager.isReload(this.op), this.op);
            HbTokenManager.removeUnLoadBiddingPayload(this.mAdUnitId, this.currentIndex, this.mWaterfallBeans, loadLifecycleCallback);
            return;
        }
        if (this.currentIndex >= this.mWaterfallBeans.size()) {
            return;
        }
        AdLoadManager adLoadManager = this;
        adLoadManager.loadLayerAd(adLoadManager.currentIndex++, loadLifecycleCallback);
    }

    private int isFindWaterfall(ArrayList<ConfigResponse.WaterfallBean> arrayList, ConfigResponse.WaterfallBean waterfallBean) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!TextUtils.equals((CharSequence)arrayList.get(i).getAdsource_placement_id(), (CharSequence)waterfallBean.getAdsource_placement_id())) continue;
            return i;
        }
        return -1;
    }

    private void saveHighPrice(ConfigResponse.WaterfallBean waterfallBean) {
        try {
            int n = this.mWaterfallBeans.indexOf(waterfallBean);
            BiddingResponse.PayLoadInfo payLoadInfo = waterfallBean.getPayLoadInfo();
            String string = null;
            if (payLoadInfo == null) {
                string = String.valueOf(waterfallBean.getEcpm());
            } else if (payLoadInfo.getExt() != null) {
                string = String.valueOf(payLoadInfo.getExt().getValue());
            }
            while (n < this.mWaterfallBeans.size() - 1) {
                String string2;
                if ((payLoadInfo = this.mWaterfallBeans.get(++n).getPayLoadInfo()) == null || (string2 = payLoadInfo.getHighPrice()) != null && string2.length() > 0 && !string2.equals("0")) continue;
                payLoadInfo.setHighPrice(string);
                payLoadInfo.setHighaspid(waterfallBean.getAdsource_placement_id());
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    final class a
    implements TPLoadAdapterListener {
        TPBaseAdapter a;
        LoadLifecycleCallback b;

        a(TPBaseAdapter tPBaseAdapter, LoadLifecycleCallback loadLifecycleCallback) {
            this.a = tPBaseAdapter;
            this.b = loadLifecycleCallback;
        }

        public final void loadAdapterLoaded(final TPBaseAd tPBaseAd) {
            TPTaskManager.getInstance().getLoadThreadHandler().post(new Runnable(){

                @Override
                public final void run() {
                    AdLoadManager.this.loadAdLoaded(tPBaseAd, a.this.a, a.this.b);
                }
            });
        }

        public final void loadAdapterLoadFailed(final TPError tPError) {
            TPTaskManager.getInstance().getLoadThreadHandler().post(new Runnable(){

                @Override
                public final void run() {
                    AdIntervalManager adIntervalManager;
                    if (!AdLoadManager.this.mLoadFinishLayers.containsKey(a.this.a.getWaterfallBean()) && (adIntervalManager = AdIntervalManager.getInstance(a.this.a.getWaterfallBean())) != null) {
                        adIntervalManager.loadWaterfallFailed();
                    }
                    AdLoadManager.this.loadAdLoadFailed(a.this.a.getWaterfallBean(), a.this.a, a.this.b, tPError.getTpErrorCode(), tPError.getEmsg());
                }
            });
        }
    }
}

