/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.core;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.common.IntervalLock;
import com.tradplus.ads.base.common.LoadMode;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.common.ValidBoolean;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.filter.FrequencyUtils;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.base.util.TradPlusDataConstants;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.core.AdCacheManager;
import com.tradplus.ads.core.AdLoadManager;
import com.tradplus.ads.core.BottomAdLoadManager;
import com.tradplus.ads.core.HbTokenManager;
import com.tradplus.ads.core.cache.AdCache;
import com.tradplus.ads.core.track.LoadLifecycleCallback;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class AdMediationManager {
    private final long LOAD_FAIL_TIME_INTERVAL = 10000L;
    private final long LOAD_SUCCESS_BUT_NOT_SHOW_VALID = 240000L;
    private static ConcurrentHashMap<String, AdMediationManager> adMediationManagerMap = new ConcurrentHashMap();
    public static final int LOAD_TRIGGER_INITUNIT = 1;
    public static final int LOAD_TRIGGER_ISREADY_FALSE = 2;
    public static final int LOAD_TRIGGER_SHOW_ISREADY_FALSE = 3;
    public static final int LOAD_TRIGGER_DISMISS = 4;
    public static final int LOAD_TRIGGER_LOAD_FAILED = 500;
    public static final int LOAD_TRIGGER_MANUAL_LOAD = 6;
    public static final int LOAD_TRIGGER_RELOAD_MANUAL = 7;
    public static final int LOAD_TRIGGER_RELOAD_AUTO = 8;
    public static final int LOAD_TRIGGER_RELOAD_SCENARIO = 9;
    public static final int LOAD_TRIGGER_UNKNOWN = 10;
    public static final int LOAD_TRIGGER_AUTO_REFRESH = 11;
    public static final int LOAD_TRIGGER_ADEXPIRED = 12;
    public static final int LOAD_TRIGGER_NETWORKCONNECT_RELOAD = 13;
    private String mAdUnitId;
    private boolean isLoading = false;
    private ValidBoolean loadSuccess;
    private IntervalLock intervalLock;
    private int cacheNumber;

    public static boolean isReload(int n) {
        return n == 9 || n == 7 || n == 8;
    }

    private AdMediationManager(String string) {
        this.mAdUnitId = string;
        this.intervalLock = new IntervalLock(10000L);
        this.loadSuccess = new ValidBoolean(240000L);
    }

    public static synchronized AdMediationManager getInstance(String string) {
        AdMediationManager adMediationManager = adMediationManagerMap.get(string);
        if (adMediationManager == null) {
            adMediationManager = new AdMediationManager(string);
            adMediationManagerMap.put(string, adMediationManager);
        }
        return adMediationManager;
    }

    private void load(final LoadLifecycleCallback loadLifecycleCallback, final int n) {
        TradPlus.invoker().checkSDKInit();
        ConfigLoadManager.getInstance().loadConfig(this.mAdUnitId, new ConfigLoadManager.ConfigLoadListener(){

            public final void onSuccess(ConfigResponse configResponse) {
                if (configResponse == null) {
                    loadLifecycleCallback.loadEndNoConfig();
                    return;
                }
                AdMediationManager.this.changeThreadAndLoadAd(configResponse, loadLifecycleCallback, n);
            }

            public final void onFailed(int n2, String string) {
                loadLifecycleCallback.loadEndNoConfig();
            }
        });
    }

    public void loadAd(LoadLifecycleCallback loadLifecycleCallback, int n) {
        this.load(loadLifecycleCallback, n);
    }

    private void changeThreadAndLoadAd(final ConfigResponse configResponse, final LoadLifecycleCallback loadLifecycleCallback, final int n) {
        TPTaskManager.getInstance().getLoadThreadHandler().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                AdMediationManager adMediationManager = AdMediationManager.this;
                synchronized (adMediationManager) {
                    loadLifecycleCallback.loadStart(n);
                    AdMediationManager.this.checkAndLoadAd(configResponse, loadLifecycleCallback, n);
                    return;
                }
            }
        });
    }

    private boolean hasBottomWaterfall(ConfigResponse configResponse) {
        return configResponse.getBottomwaterfall() != null && configResponse.getBottomwaterfall().size() > 0;
    }

    private void isTestMode(ConfigResponse.WaterfallBean object) {
        String string = "";
        if (object.getConfigBean() != null) {
            string = object.getConfigBean().getPlacementId();
        }
        object = object.getName();
        Log.i((String)"TradPlusLog", (String)"----- TradPlus TestMode Is On -----");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            Log.i((String)"TradPlusLog", (String)("----- Test Adsource PlacementId:" + string + " -----"));
        }
        if (!TextUtils.isEmpty((CharSequence)object)) {
            Log.i((String)"TradPlusLog", (String)("----- Test ChannlName:" + (String)object + " -----"));
        }
        TPTaskManager.getInstance().runOnMainThread(new Runnable(){

            @Override
            public final void run() {
                Activity activity = GlobalTradPlus.getInstance().getActivity();
                if (activity != null) {
                    Toast.makeText((Context)activity, (CharSequence)"TradPlus TestMode Is On", (int)1).show();
                }
            }
        });
    }

    private void checkAndLoadBottomWaterfall(ConfigResponse configResponse, LoadLifecycleCallback loadLifecycleCallback, int n) {
        LogUtil.ownShow((String)("TradPlusLog----- LoadMode -----" + this.getLoadedType(configResponse.getAd_fill_callback())));
        if (!this.hasBottomWaterfall(configResponse)) {
            return;
        }
        if (AdCacheManager.getInstance().getIncludeBottomReadyNum(this.mAdUnitId) > 0) {
            return;
        }
        new BottomAdLoadManager(this.mAdUnitId, configResponse.getBottomwaterfall(), n, this.getLoadedType(configResponse.getAd_fill_callback()), configResponse.getBottomWaitTime()).loadWaterfall(loadLifecycleCallback);
    }

    private void checkAndLoadAd(final ConfigResponse configResponse, final LoadLifecycleCallback loadLifecycleCallback, final int n) {
        ArrayList arrayList;
        ArrayList arrayList2;
        final int n2 = this.cacheNumber != 0 ? this.cacheNumber : configResponse.getCacheNum();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        ArrayList arrayList3 = configResponse.getWaterfall();
        if (arrayList3 != null) {
            n3 = arrayList3.size();
        }
        if ((arrayList2 = configResponse.getBiddingwaterfall()) != null) {
            n4 = arrayList2.size();
        }
        if ((arrayList = configResponse.getC2sbiddingwaterfall()) != null) {
            n5 = arrayList.size();
        }
        if (configResponse.getIs_test_mode() == 1) {
            if (n4 > 0) {
                this.isTestMode((ConfigResponse.WaterfallBean)arrayList2.get(0));
            } else if (n3 > 0) {
                this.isTestMode((ConfigResponse.WaterfallBean)arrayList3.get(0));
            }
        }
        if (n2 <= 0 || n3 <= 0 && n4 <= 0 && n5 <= 0) {
            if (!this.hasBottomWaterfall(configResponse)) {
                loadLifecycleCallback.loadEnd("9", n);
                return;
            }
            loadLifecycleCallback.loadEnd("1", n);
            return;
        }
        if (this.checkFilter()) {
            loadLifecycleCallback.loadEnd("4", n);
            return;
        }
        n2 = Math.min(n2, n3 + n4 + n5);
        n3 = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId);
        LogUtil.ownShow((String)("AdMediationManager checkCacheFill hasCache:" + n3 + " needCache:" + n2));
        if (n3 >= n2 && !AdMediationManager.isReload(n)) {
            loadLifecycleCallback.loadEnd("8", n);
            return;
        }
        if (this.checkHadCache()) {
            loadLifecycleCallback.loadEnd("19", n);
            return;
        }
        if (this.checkNetwork()) {
            loadLifecycleCallback.loadEnd("7", n);
            return;
        }
        this.intervalLock.setExpireSecond(configResponse.getLoadFailedInterval());
        if (this.intervalLock.isLocked()) {
            loadLifecycleCallback.loadEnd("15", n);
            return;
        }
        loadLifecycleCallback.loadEnd("1", n);
        this.checkAndLoadBottomWaterfall(configResponse, loadLifecycleCallback, n);
        GlobalTradPlus.getInstance().setConfigParam(this.mAdUnitId, configResponse);
        new HbTokenManager(this.mAdUnitId).startBidding(configResponse, loadLifecycleCallback, new HbTokenManager.a(){

            @Override
            public final void a(ArrayList<ConfigResponse.WaterfallBean> arrayList) {
                if (arrayList == null || arrayList.size() <= 0) {
                    loadLifecycleCallback.loadAllNetwork(AdMediationManager.this.getBiddingNoResultStatus(loadLifecycleCallback), AdMediationManager.isReload(n), n);
                    return;
                }
                if ((arrayList = AdMediationManager.this.getLoadWaterfalls(configResponse, arrayList, AdMediationManager.isReload(n))).size() == 0) {
                    loadLifecycleCallback.loadAllNetwork(AdMediationManager.this.getBiddingNoResultStatus(loadLifecycleCallback), AdMediationManager.isReload(n), n);
                    return;
                }
                int n3 = AdCacheManager.getInstance().getReadyAdNum(AdMediationManager.this.mAdUnitId);
                n3 = n2 - n3;
                if (arrayList.size() > 0 && AdMediationManager.isReload(n)) {
                    n3 = 1;
                }
                LogUtil.ownShow((String)("mediation reload = " + n));
                new AdLoadManager(AdMediationManager.this.mAdUnitId, arrayList, n3, n, AdMediationManager.this.getLoadedType(configResponse.getAd_fill_callback())).loadWaterfall(loadLifecycleCallback);
            }
        });
    }

    private String getBiddingNoResultStatus(LoadLifecycleCallback loadLifecycleCallback) {
        String string = "103";
        AdCache adCache = AdCacheManager.getInstance().getBottomCacheAd(this.mAdUnitId);
        if (adCache != null && adCache.isBottomWaterfall()) {
            adCache.setEffectTime(0L);
            loadLifecycleCallback.loadAdLoaded(adCache);
            string = "1";
        }
        return string;
    }

    private ArrayList<ConfigResponse.WaterfallBean> getLoadWaterfalls(ConfigResponse configResponse, ArrayList<ConfigResponse.WaterfallBean> arrayList, boolean n) {
        ArrayList<ConfigResponse.WaterfallBean> arrayList2 = new ArrayList<ConfigResponse.WaterfallBean>();
        configResponse = configResponse.getReload_config();
        if (n != 0 && configResponse != null) {
            int n2 = configResponse.getRequest_layer();
            if (n2 <= 0) {
                return arrayList2;
            }
            n2 = n2 > arrayList.size() ? arrayList.size() : n2;
            for (n = 0; n < n2; ++n) {
                arrayList2.add(arrayList.get(n));
            }
        } else {
            arrayList2.addAll(arrayList);
        }
        return arrayList2;
    }

    private boolean checkFilter() {
        Context context = GlobalTradPlus.getInstance().getContext();
        return !FrequencyUtils.getInstance().needFrequencyShow(context, this.mAdUnitId, TradPlusDataConstants.CACHETRADPLUSTYPE);
    }

    private boolean checkNetwork() {
        return !DeviceUtils.isNetworkAvailable((Context)GlobalTradPlus.getInstance().getContext());
    }

    private boolean checkHadCache() {
        int n = AdCacheManager.getInstance().getReadyAdNum(this.mAdUnitId);
        LogUtil.ownShow((String)("AdMediationManager checkHadCache hasCache:" + n + " loadSuccessButNotShow:" + this.checkHasLoadSuccess()));
        return n > 0 && this.checkHasLoadSuccess();
    }

    public boolean checkIsLoading() {
        return this.isLoading;
    }

    public synchronized void setLoading(boolean bl) {
        this.isLoading = bl;
    }

    public boolean checkHasLoadSuccess() {
        return this.loadSuccess.checkResult();
    }

    public synchronized void setLoadSuccess(boolean bl) {
        this.loadSuccess.setResult(bl);
    }

    public synchronized void setAllLoadFail() {
        this.intervalLock.tryLock();
    }

    public int getCacheNumber() {
        return this.cacheNumber;
    }

    public void setCacheNumber(int n) {
        this.cacheNumber = n;
    }

    public LoadMode getLoadedType(int n) {
        if (n == 1) {
            return LoadMode.ECPM;
        }
        return LoadMode.SPEED;
    }
}

