/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network;

import android.content.Context;
import android.util.Log;
import android.view.View;
import com.tradplus.ads.base.adapter.TPLoadAdapterListener;
import com.tradplus.ads.base.adapter.banner.TPBannerAdImpl;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.crosspro.network.banner.CPBannerAdListener;
import com.tradplus.crosspro.network.open.CPBannerAd;
import java.util.Map;

public class CPADBannerAdapter
extends TPBannerAdapter {
    private static final String TAG = "CPAdBannerAdapter";
    private TPBannerAdImpl mTpBannerAd;
    private String name;
    private CPBannerAd cpBannerAd;

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        String adSourceId = "";
        String campaignId = "";
        if (tpParams != null && tpParams.size() > 0) {
            campaignId = tpParams.get("placementId");
            this.name = tpParams.get("name");
            if (tpParams.containsKey("adsource_placement_id")) {
                adSourceId = tpParams.get("adsource_placement_id");
            }
        } else if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.cpBannerAd = new CPBannerAd(context, campaignId, this.getAdUnitId(), adSourceId);
        this.cpBannerAd.setAdListener(new CPBannerAdListener(){

            @Override
            public void onShowFailed(TPError error) {
                Log.i((String)CPADBannerAdapter.TAG, (String)"onShowFailed: ");
                TPError tpError = new TPError("Didn't find valid adv.Show Failed");
                if (error != null) {
                    String code = error.getErrorCode();
                    String message = error.getErrorMessage();
                    tpError.setErrorMessage(message);
                    tpError.setErrorCode(code);
                    Log.i((String)CPADBannerAdapter.TAG, (String)("code :" + code + ", message :" + message));
                }
                if (CPADBannerAdapter.this.mTpBannerAd != null) {
                    CPADBannerAdapter.this.mTpBannerAd.onAdShowFailed(error);
                }
            }

            @Override
            public void onAdLoaded() {
                Log.i((String)CPADBannerAdapter.TAG, (String)"onAdLoaded: ");
                if (CPADBannerAdapter.this.cpBannerAd == null) {
                    CPADBannerAdapter.this.loadFailed(CPADBannerAdapter.this.mLoadAdapterListener, new TPError("Third-party network failed to provide an ad."));
                    return;
                }
                CPADBannerAdapter.this.mTpBannerAd = new TPBannerAdImpl(null, (View)CPADBannerAdapter.this.cpBannerAd);
                CPADBannerAdapter.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)CPADBannerAdapter.this.mTpBannerAd);
            }

            @Override
            public void onAdClicked() {
                Log.i((String)CPADBannerAdapter.TAG, (String)"onAdClicked: ");
                if (CPADBannerAdapter.this.mTpBannerAd != null) {
                    CPADBannerAdapter.this.mTpBannerAd.adClicked();
                }
            }

            @Override
            public void onAdClosed() {
                Log.i((String)CPADBannerAdapter.TAG, (String)"onAdClosed: ");
                if (CPADBannerAdapter.this.mTpBannerAd != null) {
                    CPADBannerAdapter.this.mTpBannerAd.adClosed();
                }
            }

            @Override
            public void onAdImpression() {
                Log.i((String)CPADBannerAdapter.TAG, (String)"onAdImpression: ");
                if (CPADBannerAdapter.this.mTpBannerAd != null) {
                    CPADBannerAdapter.this.mTpBannerAd.adShown();
                }
            }

            @Override
            public void onAdLoadFailed(TPError error) {
                Log.i((String)CPADBannerAdapter.TAG, (String)"onAdLoadFailed: ");
                TPError tpError = new TPError("Third-party network failed to provide an ad.");
                if (error != null) {
                    String code = error.getErrorCode();
                    String message = error.getErrorMessage();
                    tpError.setErrorMessage(message);
                    tpError.setErrorCode(code);
                    Log.i((String)CPADBannerAdapter.TAG, (String)("code :" + code + ", message :" + message));
                }
                CPADBannerAdapter.this.loadFailed(CPADBannerAdapter.this.mLoadAdapterListener, tpError);
            }
        });
        this.cpBannerAd.loadAd();
    }

    private void loadFailed(TPLoadAdapterListener loadAdapterListener, TPError tpError) {
        if (loadAdapterListener != null) {
            loadAdapterListener.loadAdapterLoadFailed(tpError);
        }
    }

    public void clean() {
        if (this.cpBannerAd != null) {
            this.cpBannerAd.onDestroy();
            this.cpBannerAd = null;
        }
    }

    public boolean isReady() {
        return !this.isAdsTimeOut();
    }

    public String getNetworkName() {
        return this.name;
    }

    public String getNetworkVersion() {
        return "27.11.8.0.1";
    }
}

