/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network;

import android.content.Context;
import android.util.Log;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.network.CPADNativeAd;
import com.tradplus.crosspro.network.nativead.CPNativeAd;
import com.tradplus.crosspro.network.nativead.CPNativeAdListener;
import com.tradplus.crosspro.network.nativead.NativeAd;
import java.util.Map;

public class CPADNativeAdapter
extends TPNativeAdapter {
    private String campaignId;
    private String adSourceId;
    private String name;
    private CPNativeAd cpNativeAd;
    private CPADNativeAd cpadNativeAd;
    private long timeoutValue = 10800000L;
    private int mVideoMute = 1;
    private boolean mNeedDownloadImg = false;
    public static final long TIME_DELTA = 10000L;
    private static final String TAG = "CrossProNative";

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (tpParams != null && tpParams.size() > 0) {
            this.campaignId = tpParams.get("placementId");
            this.name = tpParams.get("name");
            if (tpParams.containsKey("adsource_placement_id")) {
                this.adSourceId = tpParams.get("adsource_placement_id");
            }
        } else if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        if (userParams != null && userParams.size() > 0) {
            if (userParams.containsKey("need_down_load_img")) {
                String downLoadImg = (String)userParams.get("need_down_load_img");
                this.mNeedDownloadImg = "true".equals(downLoadImg);
            }
            if (userParams.containsKey("video_mute")) {
                this.mVideoMute = (Integer)userParams.get("video_mute");
                Log.i((String)TAG, (String)("VideoMute: " + this.mVideoMute));
            }
        }
        this.cpNativeAd = new CPNativeAd(context, this.campaignId, this.getAdUnitId(), this.adSourceId);
        this.cpNativeAd.setCpNativeAdListener(new CPNativeAdListener(){

            @Override
            public void onAdClicked() {
                Log.i((String)CPADNativeAdapter.TAG, (String)"onAdClicked: ");
                if (CPADNativeAdapter.this.cpadNativeAd != null) {
                    CPADNativeAdapter.this.cpadNativeAd.onAdClicked();
                }
            }

            @Override
            public void onShowFailed(TPError error) {
                Log.i((String)CPADNativeAdapter.TAG, (String)"onShowFailed: ");
                if (CPADNativeAdapter.this.cpadNativeAd != null) {
                    TPError tpError = new TPError("Didn't find valid adv.Show Failed");
                    if (error != null) {
                        String code = error.getErrorCode();
                        String desc = error.getErrorMessage();
                        Log.i((String)CPADNativeAdapter.TAG, (String)("onShowFailed code : " + code + "\uff0cdesc : " + desc));
                    }
                    CPADNativeAdapter.this.cpadNativeAd.onAdVideoError(tpError);
                }
            }

            @Override
            public void onAdLoaded(NativeAd nativeAd) {
                Log.i((String)CPADNativeAdapter.TAG, (String)"onAdLoaded: ");
                if (nativeAd == null) {
                    if (CPADNativeAdapter.this.mLoadAdapterListener != null) {
                        CPADNativeAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Didn't find valid adv.Show Failed"));
                    }
                    return;
                }
                CPADNativeAdapter.this.cpadNativeAd = new CPADNativeAd(context, nativeAd, CPADNativeAdapter.this.cpNativeAd);
                CPADNativeAdapter.this.downloadAndCallback(CPADNativeAdapter.this.cpadNativeAd, CPADNativeAdapter.this.mNeedDownloadImg);
            }

            @Override
            public void onAdLoadFailed(TPError error) {
                Log.i((String)CPADNativeAdapter.TAG, (String)"onAdLoadFailed: ");
                if (CPADNativeAdapter.this.mLoadAdapterListener != null) {
                    if (error != null) {
                        String errorCode = error.getErrorCode();
                        String errorMessage = error.getErrorMessage();
                        Log.i((String)CPADNativeAdapter.TAG, (String)("onAdLoadFailed errorCode : " + errorCode + ", errorMessage : " + errorMessage));
                    }
                    CPADNativeAdapter.this.mLoadAdapterListener.loadAdapterLoadFailed(error);
                }
            }

            @Override
            public void onAdImpression() {
                Log.i((String)CPADNativeAdapter.TAG, (String)"onAdImpression: ");
                if (CPADNativeAdapter.this.cpadNativeAd != null) {
                    CPADNativeAdapter.this.cpadNativeAd.onAdShown();
                }
            }
        });
        this.cpNativeAd.setVideoMute(this.mVideoMute == 1);
        this.cpNativeAd.load();
    }

    public void clean() {
        if (this.cpNativeAd != null) {
            this.cpNativeAd.setCpNativeAdListener(null);
            this.cpNativeAd = null;
        }
    }

    public String getNetworkName() {
        return this.name;
    }

    public String getNetworkVersion() {
        return null;
    }
}

