/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.manager;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.network.response.CPAdResponse;
import com.tradplus.ads.common.task.TPTaskManager;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.pushcenter.event.EventSendMessageUtil;
import java.net.HttpURLConnection;
import java.net.URL;

public class CPClickController {
    private final String TAG = this.getClass().getSimpleName();
    public static final String HOST_GOOGLE_PLAY = "play.google.com";
    public static final String HOST_ANDROID_MARKET = "market.android.com";
    public static final String PATH_DETAILS = "details?";
    public static final String SCHEME_MARKET = "market";
    public static final String PROTOCOL_MARKET = "market://";
    private final int MAX_JUMP_COUNT = 10;
    private final int MARKET_TYPE = 1;
    private final int BROWSER_TYPE = 2;
    private final int APK_TYPE = 3;
    private final int SYNC_MODE = 0;
    private final int ASYNC_MODE = 1;
    CPAdResponse cpAdResponse;
    private String mCampaignId;
    boolean mIsClicking;
    boolean mIsCancel;
    private String adSourceId;
    Context mContext;

    public CPClickController(Context context, CPAdResponse cpAdResponse, String adSourceId) {
        this.cpAdResponse = cpAdResponse;
        this.mCampaignId = cpAdResponse.getCampaign_id();
        this.mContext = context.getApplicationContext();
        this.adSourceId = adSourceId;
    }

    public void startClick(final String requestId, final ClickStatusCallback clickStatusCallback) {
        if (this.mIsClicking) {
            return;
        }
        if (clickStatusCallback != null) {
            clickStatusCallback.clickStart();
        }
        this.mIsClicking = true;
        this.mIsCancel = false;
        TPTaskManager.getInstance().run_proxy(new Runnable(){

            @Override
            public void run() {
                Log.i((String)"CPClick", (String)("run: deepLinkUrl \uff1a " + CPClickController.this.cpAdResponse.getDeeplink_url()));
                Log.i((String)"CPClick", (String)("run: deepLinkUrl \uff1a " + CPClickController.this.isApkInstalled(CPClickController.this.mContext, CPClickController.this.cpAdResponse.getAd_pkg_name())));
                Log.i((String)"CPClick", (String)("run: deepLinkUrl \uff1a " + CPClickController.this.cpAdResponse.getAd_pkg_name()));
                if (!TextUtils.isEmpty((CharSequence)CPClickController.this.cpAdResponse.getDeeplink_url()) && CPClickController.this.isApkInstalled(CPClickController.this.mContext, CPClickController.this.cpAdResponse.getAd_pkg_name())) {
                    String deepLinkUrl = CPClickController.this.cpAdResponse.getDeeplink_url().replaceAll("\\{req_id\\}", requestId == null ? "" : requestId);
                    Log.i((String)"CPClick", (String)("run: deepLinkUrl \uff1a " + deepLinkUrl));
                    if (CPClickController.this.openDeepLink(CPClickController.this.mContext, deepLinkUrl)) {
                        Log.i((String)"CPClick", (String)"run: openDeepLink \uff1a");
                        CPClickController.this.mIsClicking = false;
                        EventSendMessageUtil.getInstance().sendDeepLinkAd(CPClickController.this.mContext, CPClickController.this.mCampaignId, CPClickController.this.cpAdResponse.getAd_id(), "1", CPClickController.this.adSourceId);
                        EventSendMessageUtil.getInstance().sendClickAdEnd(CPClickController.this.mContext, CPClickController.this.mCampaignId, CPClickController.this.cpAdResponse.getAd_id(), "1", CPClickController.this.adSourceId);
                        if (clickStatusCallback != null) {
                            clickStatusCallback.clickEnd();
                        }
                        return;
                    }
                    EventSendMessageUtil.getInstance().sendDeepLinkAd(CPClickController.this.mContext, CPClickController.this.mCampaignId, CPClickController.this.cpAdResponse.getAd_id(), "2", CPClickController.this.adSourceId);
                    Log.i((String)"CPClick", (String)"run: openDeepLink else \uff1a");
                }
                CPClickController.this.openClickUrl(requestId, clickStatusCallback);
            }
        });
    }

    private void openClickUrl(String requestId, ClickStatusCallback clickStatusCallback) {
        String clickUrl = (this.cpAdResponse.getClick_url() != null ? this.cpAdResponse.getClick_url() : "").replaceAll("\\{req_id\\}", requestId == null ? "" : requestId);
        Log.i((String)this.TAG, (String)("openClickUrl: " + this.cpAdResponse.getClick_type()));
        Log.i((String)this.TAG, (String)("openClickUrl: " + this.cpAdResponse.getClick_url()));
        boolean isNeedJump = true;
        if (this.cpAdResponse.getClick_type() != 1 && this.cpAdResponse.getClick_type() != 3) {
            this.handleClickResult(clickUrl, clickStatusCallback);
            return;
        }
        if (clickUrl.endsWith(".apk")) {
            this.handleClickResult(clickUrl, clickStatusCallback);
            return;
        }
        if (!clickUrl.startsWith("http")) {
            this.handleClickResult(this.cpAdResponse.getClick_url(), clickStatusCallback);
            return;
        }
        if (this.cpAdResponse.getClick_mode() == 1) {
            this.handleClickResult(this.cpAdResponse.getPreview_url(), clickStatusCallback);
            isNeedJump = false;
        }
        String resultUrl = this.handleUrl302Result(clickUrl);
        if (isNeedJump && !TextUtils.isEmpty((CharSequence)resultUrl)) {
            this.handleClickResult(resultUrl, clickStatusCallback);
        }
    }

    private boolean openDeepLink(Context context, String deepLinkUrl) {
        boolean openSuccessed = false;
        try {
            if (!TextUtils.isEmpty((CharSequence)deepLinkUrl)) {
                Uri uri = Uri.parse((String)deepLinkUrl);
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                intent.setData(uri);
                intent.setFlags(0x10000000);
                context.startActivity(intent);
                openSuccessed = true;
            }
        }
        catch (Throwable t) {
            LogUtil.ownShow((String)t.getMessage());
        }
        return openSuccessed;
    }

    private String handleUrl302Result(String clickUrl) {
        String startUrl = clickUrl;
        boolean success = false;
        for (int i = 0; i < 10; ++i) {
            try {
                URL serverUrl = new URL(startUrl);
                HttpURLConnection conn = (HttpURLConnection)serverUrl.openConnection();
                conn.setRequestMethod("GET");
                conn.setInstanceFollowRedirects(false);
                conn.setConnectTimeout(30000);
                conn.connect();
                int responseCode = conn.getResponseCode();
                if (responseCode == 302) {
                    startUrl = conn.getHeaderField("Location");
                    if (this.isGooglePlayUrl(startUrl) || startUrl.endsWith(".apk") || !startUrl.startsWith("http")) {
                        success = true;
                    }
                } else {
                    conn.disconnect();
                    if (success || responseCode == 200) {
                        return startUrl;
                    }
                    return "";
                }
                conn.disconnect();
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return "";
    }

    private void handleClickResult(String finalUrl, ClickStatusCallback clickStatusCallback) {
        if (this.mIsCancel) {
            return;
        }
        finalUrl = TextUtils.isEmpty((CharSequence)finalUrl) ? this.cpAdResponse.getPreview_url() : finalUrl;
        switch (this.cpAdResponse.getClick_type()) {
            case 1: {
                if (!finalUrl.startsWith("http")) {
                    if (this.openMarketApp(finalUrl)) break;
                    this.openBrowserUrl(finalUrl);
                    break;
                }
                String googleMarketUrl = this.convertToMarketUrl(finalUrl);
                if (!TextUtils.isEmpty((CharSequence)googleMarketUrl)) {
                    if (this.openMarketApp(googleMarketUrl)) break;
                    this.openBrowserUrl(finalUrl);
                    break;
                }
                this.openBrowserUrl(finalUrl);
                break;
            }
            case 2: {
                this.openBrowserUrl(finalUrl);
                break;
            }
            case 3: {
                this.downloadApkOrOpenBrowser(finalUrl, clickStatusCallback);
                break;
            }
            default: {
                this.openBrowserUrl(finalUrl);
            }
        }
        this.mIsClicking = false;
        if (clickStatusCallback != null) {
            clickStatusCallback.clickEnd();
        }
    }

    private void downloadApkOrOpenBrowser(String finalUrl, ClickStatusCallback clickStatusCallback) {
        Log.i((String)this.TAG, (String)("downloadApkOrOpenBrowser: " + TradPlus.invoker().getChinaHandler()));
        if (TradPlus.invoker().getChinaHandler() != null && !TextUtils.isEmpty((CharSequence)finalUrl) && finalUrl.endsWith(".apk")) {
            if (clickStatusCallback != null) {
                EventSendMessageUtil.getInstance().sendClickAdEnd(this.mContext, this.mCampaignId, this.cpAdResponse.getAd_id(), "1", this.adSourceId);
                clickStatusCallback.downloadApp(finalUrl);
            }
            return;
        }
        this.openBrowserUrl(finalUrl);
    }

    private boolean openMarketApp(String googleMarketUrl) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)googleMarketUrl));
            intent.setData(Uri.parse((String)googleMarketUrl));
            intent.addFlags(0x10000000);
            this.mContext.startActivity(intent);
            EventSendMessageUtil.getInstance().sendClickAdEnd(this.mContext, this.mCampaignId, this.cpAdResponse.getAd_id(), "1", this.adSourceId);
        }
        catch (Throwable e) {
            TradPlus.invoker().runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)CPClickController.this.mContext, (CharSequence)"Detect that the App Market is not installed and cannot be opened through the App Market.", (int)1).show();
                }
            });
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openBrowserUrl(String finalUrl) {
        boolean isOpen = false;
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)finalUrl));
            intent.addFlags(0x10008000);
            this.mContext.startActivity(intent);
            isOpen = true;
        }
        catch (Exception e2) {
            isOpen = false;
            EventSendMessageUtil.getInstance().sendClickAdEnd(this.mContext, this.mCampaignId, this.cpAdResponse.getAd_id(), "32", this.adSourceId);
            e2.printStackTrace();
        }
        finally {
            if (isOpen) {
                EventSendMessageUtil.getInstance().sendClickAdEnd(this.mContext, this.mCampaignId, this.cpAdResponse.getAd_id(), "1", this.adSourceId);
            }
        }
    }

    private boolean isGooglePlayUrl(String url) {
        try {
            if (TextUtils.isEmpty((CharSequence)url)) {
                return false;
            }
            Uri uri = Uri.parse((String)url);
            if (uri == null || uri.getHost() == null) {
                return false;
            }
            return uri.getHost().equals(HOST_GOOGLE_PLAY) || uri.getHost().equals(HOST_ANDROID_MARKET);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private String convertToMarketUrl(String url) {
        block3: {
            try {
                if (this.isGooglePlayUrl(url)) {
                    String detailsUrl = url.substring(url.indexOf(PATH_DETAILS));
                    return PROTOCOL_MARKET + detailsUrl;
                }
            }
            catch (Throwable e) {
                if (!TPDataManager.getInstance().isDebugMode()) break block3;
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean isApkInstalled(Context context, String pkgName) {
        if (context == null || TextUtils.isEmpty((CharSequence)pkgName)) {
            return false;
        }
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(pkgName, 8192);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public void cancelClick() {
        this.mIsCancel = true;
    }

    public static interface ClickStatusCallback {
        public void clickStart();

        public void clickEnd();

        public void downloadApp(String var1);
    }
}

