/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.manager;

import android.content.Context;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.network.response.CPAdResponse;
import com.tradplus.ads.base.network.util.ResourceDiskCacheManager;
import com.tradplus.ads.common.util.FileUtil;
import com.tradplus.crosspro.manager.resource.CPLoader;
import com.tradplus.crosspro.manager.resource.CPResourceStatus;
import java.io.FileInputStream;
import java.io.InputStream;

public class CPResourceManager {
    private static CPResourceManager sInstance;

    private CPResourceManager() {
    }

    public static synchronized CPResourceManager getInstance() {
        if (sInstance == null) {
            sInstance = new CPResourceManager();
        }
        return sInstance;
    }

    public FileInputStream getInputStream(String url) {
        String resFileName = FileUtil.hashKeyForDisk((String)url);
        if (GlobalTradPlus.getInstance().getContext() == null) {
            return null;
        }
        return ResourceDiskCacheManager.getInstance((Context)GlobalTradPlus.getInstance().getContext()).getFileInputStream(1, resFileName);
    }

    public boolean writeToDiskLruCache(String url, InputStream inputStream) {
        if (url == null || inputStream == null) {
            return false;
        }
        String resFileName = FileUtil.hashKeyForDisk((String)url);
        return ResourceDiskCacheManager.getInstance((Context)GlobalTradPlus.getInstance().getContext()).saveNetworkInputStreamToFile(1, resFileName, inputStream);
    }

    public void load(Context context, String placementId, CPAdResponse cpAdResponse, CPLoader.CPLoaderListener listener, String adSourceId) {
        CPLoader cpLoader = new CPLoader(placementId, 90000, adSourceId);
        cpLoader.load(context, cpAdResponse, listener);
    }

    public boolean isExist(CPAdResponse cpAdResponse) {
        return CPResourceStatus.isExist(cpAdResponse);
    }
}

