/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.manager.resource;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.tradplus.ads.base.event.TPPushCenter;
import com.tradplus.ads.base.network.response.CPAdResponse;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.pushcenter.event.EventBaseRequest;
import com.tradplus.ads.pushcenter.event.EventSendMessageUtil;
import com.tradplus.ads.pushcenter.event.request.EventLoadEndRequest;
import com.tradplus.ads.pushcenter.event.utils.EventPushMessageUtils;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.crosspro.manager.resource.CPResourceStatus;
import com.tradplus.crosspro.manager.resource.CPUrlLoadManager;
import com.tradplus.crosspro.manager.resource.CPUrlLoader;
import com.tradplus.crosspro.network.base.CPError;
import com.tradplus.crosspro.network.base.CPErrorCode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class CPLoader
implements CPUrlLoadManager.CPResourceLoadResult {
    private String mPlacementId;
    private int mCPTimeout;
    private String adid;
    private List<String> mUrlList;
    private CPLoaderListener mListener;
    private EventLoadEndRequest eventLoadEndRequest;
    private Context mContext;
    private String adSourceId;
    private List<EventLoadEndRequest> loadEndRequestList;
    private Handler mMainHandler;
    private AtomicBoolean mHasCallback = new AtomicBoolean(false);

    public CPLoader(String placementId, int cpTimeout, String adSourceId) {
        this.mPlacementId = placementId;
        this.mCPTimeout = cpTimeout;
        this.adSourceId = adSourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Context context, CPAdResponse cpAdResponse, CPLoaderListener listener) {
        String url;
        this.adid = cpAdResponse.getAd_id();
        this.mListener = listener;
        this.mContext = context;
        this.loadEndRequestList = new ArrayList<EventLoadEndRequest>();
        this.loadEndRequestList.clear();
        this.eventLoadEndRequest = new EventLoadEndRequest(context, EventPushMessageUtils.EventPushStats.EV_LOAD_AD_END.getValue());
        List urlList = cpAdResponse.getUrlList();
        int size = 0;
        size = urlList.size();
        if (size == 0) {
            this.notifySuccess();
            return;
        }
        this.mUrlList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            url = (String)urlList.get(i);
            if (!CPResourceStatus.isExist(url)) {
                this.mUrlList.add(url);
                continue;
            }
            String _url = url;
            EventSendMessageUtil.getInstance().sendDownloadAdStart(this.mContext, this.mPlacementId, this.adid, this.adSourceId, _url, !cpAdResponse.isEndCardUrl(_url) && !cpAdResponse.isIconUrl(_url));
            EventLoadEndRequest _eventLoadEndRequest = null;
            if (cpAdResponse.isEndCardUrl(_url)) {
                _eventLoadEndRequest = new EventLoadEndRequest(context, EventPushMessageUtils.EventPushStats.EV_DOWNLOAD_ENDCARD_END.getValue());
            } else if (cpAdResponse.isVideoUrl(_url)) {
                _eventLoadEndRequest = new EventLoadEndRequest(context, EventPushMessageUtils.EventPushStats.EV_DOWNLOAD_VIDEO_END.getValue());
            } else if (cpAdResponse.isIconUrl(url)) {
                _eventLoadEndRequest = new EventLoadEndRequest(context, EventPushMessageUtils.EventPushStats.EV_DOWNLOAD_ENDCARD_END.getValue());
            }
            _eventLoadEndRequest.setCampaign_id(this.mPlacementId);
            _eventLoadEndRequest.setAd_id(this.adid);
            _eventLoadEndRequest.setAsu_id(this.adSourceId);
            _eventLoadEndRequest.setUrl(_url);
            _eventLoadEndRequest.setError_code("2001");
            long loadTime = RequestUtils.getInstance().countRuntime(_eventLoadEndRequest.getCreateTime());
            _eventLoadEndRequest.setLoad_time(loadTime + "");
            TPPushCenter.getInstance().saveCrossEvent((EventBaseRequest)_eventLoadEndRequest);
        }
        int url_size = this.mUrlList.size();
        if (url_size == 0) {
            LogUtil.ownShow((String)("cp(" + this.adid + "), all files have already exist"));
            this.notifySuccess();
            return;
        }
        CPUrlLoadManager.getInstance().register(this);
        this.startLoadTimer();
        CPLoader cPLoader = this;
        synchronized (cPLoader) {
            for (int i = 0; i < url_size; ++i) {
                url = this.mUrlList.get(i);
                EventSendMessageUtil.getInstance().sendDownloadAdStart(this.mContext, this.mPlacementId, this.adid, this.adSourceId, url, !cpAdResponse.isEndCardUrl(url) && !cpAdResponse.isIconUrl(url));
                EventLoadEndRequest _eventLoadEndRequest = null;
                if (cpAdResponse.isEndCardUrl(url)) {
                    _eventLoadEndRequest = new EventLoadEndRequest(context, EventPushMessageUtils.EventPushStats.EV_DOWNLOAD_ENDCARD_END.getValue());
                } else if (cpAdResponse.isVideoUrl(url)) {
                    _eventLoadEndRequest = new EventLoadEndRequest(context, EventPushMessageUtils.EventPushStats.EV_DOWNLOAD_VIDEO_END.getValue());
                } else if (cpAdResponse.isIconUrl(url)) {
                    _eventLoadEndRequest = new EventLoadEndRequest(context, EventPushMessageUtils.EventPushStats.EV_DOWNLOAD_ENDCARD_END.getValue());
                }
                _eventLoadEndRequest.setCampaign_id(this.mPlacementId);
                _eventLoadEndRequest.setAd_id(this.adid);
                _eventLoadEndRequest.setAsu_id(this.adSourceId);
                _eventLoadEndRequest.setUrl(url);
                if (!DeviceUtils.isNetworkAvailable((Context)context)) {
                    this.processLoadStartUrlStatus(_eventLoadEndRequest, "7");
                    continue;
                }
                if (TextUtils.isEmpty((CharSequence)url)) {
                    this.processLoadStartUrlStatus(_eventLoadEndRequest, "2");
                    continue;
                }
                if (CPResourceStatus.isLoading(url)) {
                    LogUtil.ownShow((String)("file is loading -> " + url));
                    this.processLoadStartUrlStatus(_eventLoadEndRequest, "2101");
                    continue;
                }
                if (CPResourceStatus.isExist(url)) {
                    LogUtil.ownShow((String)("file exist -> " + url));
                    CPResourceStatus.setState(url, 0);
                    CPUrlLoadManager.getInstance().notifyDownloadSuccess(url);
                    this.processLoadStartUrlStatus(_eventLoadEndRequest, "2002");
                    continue;
                }
                CPResourceStatus.setState(url, 1);
                LogUtil.ownShow((String)("file not exist -> " + url));
                CPUrlLoader CPUrlLoader2 = new CPUrlLoader(this.mPlacementId, url);
                if (_eventLoadEndRequest != null) {
                    this.loadEndRequestList.add(_eventLoadEndRequest);
                }
                CPUrlLoader2.start();
            }
        }
    }

    private void processLoadStartUrlStatus(EventLoadEndRequest _eventLoadEndRequest, String errorCode) {
        _eventLoadEndRequest.setError_code(errorCode);
        long loadTime = RequestUtils.getInstance().countRuntime(_eventLoadEndRequest.getCreateTime());
        _eventLoadEndRequest.setLoad_time(loadTime + "");
        TPPushCenter.getInstance().saveCrossEvent((EventBaseRequest)_eventLoadEndRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResourceLoadSuccess(String url) {
        CPLoader cPLoader = this;
        synchronized (cPLoader) {
            CPResourceStatus.setState(url, 0);
            this.processEndEvent(url, "1");
            if (this.mUrlList != null) {
                this.mUrlList.remove(url);
                LogUtil.ownShow((String)("mUrlList.size() = " + this.mUrlList.size()));
                if (this.mUrlList.size() == 0 && !this.mHasCallback.get()) {
                    this.notifySuccess();
                }
            }
        }
    }

    @Override
    public void onResourceLoadFailed(String url, CPError error) {
        CPResourceStatus.setState(url, 0);
        this.processEndEvent(url, "2");
        this.notifyFailed(error);
    }

    private void processEndEvent(String url, String errorCode) {
        int index = -1;
        for (int i = 0; i < this.loadEndRequestList.size(); ++i) {
            if (!TextUtils.equals((CharSequence)url, (CharSequence)this.loadEndRequestList.get(i).getUrl())) continue;
            this.loadEndRequestList.get(i).setError_code(errorCode);
            long loadTime = RequestUtils.getInstance().countRuntime(this.loadEndRequestList.get(i).getCreateTime());
            this.loadEndRequestList.get(i).setLoad_time(loadTime + "");
            TPPushCenter.getInstance().saveCrossEvent((EventBaseRequest)this.loadEndRequestList.get(i));
            index = i;
            break;
        }
        if (index != -1) {
            this.loadEndRequestList.remove(index);
        }
    }

    private void notifySuccess() {
        this.mHasCallback.set(true);
        if (this.mListener != null) {
            LogUtil.ownShow((String)("cp load success, adid -> " + this.adid));
            this.eventLoadEndRequest.setCampaign_id(this.mPlacementId);
            this.eventLoadEndRequest.setAd_id(this.adid);
            this.eventLoadEndRequest.setError_code("1");
            this.eventLoadEndRequest.setAsu_id(this.adSourceId);
            long loadTime = RequestUtils.getInstance().countRuntime(this.eventLoadEndRequest.getCreateTime());
            this.eventLoadEndRequest.setLoad_time(loadTime + "");
            TPPushCenter.getInstance().saveCrossEvent((EventBaseRequest)this.eventLoadEndRequest);
            this.mListener.onSuccess();
        }
        this.release();
    }

    private void notifyFailed(CPError error) {
        this.mHasCallback.set(true);
        if (this.mListener != null) {
            LogUtil.ownShow((String)("cp load failed, adid -> " + this.adid));
            this.eventLoadEndRequest.setCampaign_id(this.mPlacementId);
            this.eventLoadEndRequest.setAd_id(this.adid);
            this.eventLoadEndRequest.setAsu_id(this.adSourceId);
            if (error.getCode().equals("201")) {
                this.eventLoadEndRequest.setError_code("3");
            } else {
                this.eventLoadEndRequest.setError_code("2");
            }
            long loadTime = RequestUtils.getInstance().countRuntime(this.eventLoadEndRequest.getCreateTime());
            this.eventLoadEndRequest.setLoad_time(loadTime + "");
            TPPushCenter.getInstance().saveCrossEvent((EventBaseRequest)this.eventLoadEndRequest);
            this.mListener.onFailed(error);
        }
        this.release();
    }

    private void release() {
        CPUrlLoadManager.getInstance().unRegister(this);
        if (this.mMainHandler != null) {
            this.mMainHandler.removeCallbacksAndMessages(null);
            this.mMainHandler = null;
        }
    }

    private void startLoadTimer() {
        if (this.mMainHandler == null) {
            this.mMainHandler = new Handler(Looper.getMainLooper());
            this.mMainHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!CPLoader.this.mHasCallback.get()) {
                        for (int i = 0; i < CPLoader.this.loadEndRequestList.size(); ++i) {
                            ((EventLoadEndRequest)CPLoader.this.loadEndRequestList.get(i)).setError_code("3");
                            long loadTime = RequestUtils.getInstance().countRuntime(((EventLoadEndRequest)CPLoader.this.loadEndRequestList.get(i)).getCreateTime());
                            ((EventLoadEndRequest)CPLoader.this.loadEndRequestList.get(i)).setLoad_time(loadTime + "");
                            TPPushCenter.getInstance().saveCrossEvent((EventBaseRequest)CPLoader.this.loadEndRequestList.get(i));
                        }
                        CPLoader.this.notifyFailed(CPErrorCode.get("201", "Load timeout!"));
                    }
                }
            }, (long)this.mCPTimeout);
        }
    }

    public static interface CPLoaderListener {
        public void onSuccess();

        public void onFailed(CPError var1);
    }
}

