/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.network.banner;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.base.common.TPImageLoader;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.event.TPPushCenter;
import com.tradplus.ads.base.network.response.CPAdResponse;
import com.tradplus.ads.common.TaskUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.network.CPErrorUtil;
import com.tradplus.ads.pushcenter.event.EventBaseRequest;
import com.tradplus.ads.pushcenter.event.EventSendMessageUtil;
import com.tradplus.ads.pushcenter.event.request.EventLoadEndRequest;
import com.tradplus.ads.pushcenter.event.request.EventShowEndRequest;
import com.tradplus.ads.pushcenter.event.utils.EventPushMessageUtils;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.crosspro.R;
import com.tradplus.crosspro.manager.CPAdConfigController;
import com.tradplus.crosspro.manager.CPAdManager;
import com.tradplus.crosspro.manager.CPClickController;
import com.tradplus.crosspro.manager.resource.CPLoader;
import com.tradplus.crosspro.network.banner.CPBannerAdListener;
import com.tradplus.crosspro.network.banner.views.BannerHtmlWebView;
import com.tradplus.crosspro.network.banner.views.BaseWebView;
import com.tradplus.crosspro.network.banner.views.NativeBannerFactory;
import com.tradplus.crosspro.network.base.CPBaseAd;
import com.tradplus.crosspro.network.base.CPError;
import com.tradplus.crosspro.ui.util.ViewUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class CPBannerMgr
extends CPBaseAd {
    private FrameLayout bannerView;
    private int isShowClose = 1;
    private String mAdId;
    private CPBannerAdListener mCPBannerAdListener;
    private CPAdResponse cpAdResponse;
    private boolean mIsShowing = false;
    private int width;
    private int height;
    private static final String TAG = "CrossProBanner";
    View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            try {
                CPBannerMgr.this.adClicked();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    };

    public CPBannerMgr(Context context, FrameLayout bannerView, String campaignId, String adUnitId, String adSourceId) {
        super(context, campaignId, adUnitId, adSourceId);
        this.bannerView = bannerView;
    }

    @Override
    public void load() {
        LogUtil.ownShow((String)"OpenAPIStart...");
        CPAdConfigController cpAdConfigController = new CPAdConfigController();
        cpAdConfigController.setOnConfigListener(new CPAdConfigController.OnConfigListener(){

            @Override
            public void onSuccess(String pid) {
                CPBannerMgr.this.cpAdResponse = CPAdManager.getInstance(CPBannerMgr.this.getContext()).getCpAdConfig(CPBannerMgr.this.campaignId);
                TPDataManager.getInstance().putIds(CPBannerMgr.this.adSourceId);
                EventSendMessageUtil.getInstance().sendLoadAdNetworkStart(CPBannerMgr.this.getContext(), CPBannerMgr.this.campaignId, CPBannerMgr.this.adSourceId);
                if (CPBannerMgr.this.cpAdResponse == null) {
                    EventLoadEndRequest eventLoadEndRequest = new EventLoadEndRequest(CPBannerMgr.this.getContext(), EventPushMessageUtils.EventPushStats.EV_LOAD_AD_END.getValue());
                    eventLoadEndRequest.setCampaign_id(CPBannerMgr.this.campaignId);
                    eventLoadEndRequest.setAsu_id(CPBannerMgr.this.adSourceId);
                    eventLoadEndRequest.setError_code("\u5fc5\u4f20\u7d20\u6750\u4e3a\u7a7a");
                    long loadTime = RequestUtils.getInstance().countRuntime(eventLoadEndRequest.getCreateTime());
                    eventLoadEndRequest.setLoad_time(loadTime + "");
                    TPPushCenter.getInstance().saveCrossEvent((EventBaseRequest)eventLoadEndRequest);
                    if (CPBannerMgr.this.mCPBannerAdListener != null) {
                        CPBannerMgr.this.mCPBannerAdListener.onAdLoadFailed(new TPError("\u5fc5\u4f20\u7d20\u6750\u4e3a\u7a7a"));
                    }
                    return;
                }
                CPBannerMgr.this.mAdId = CPBannerMgr.this.cpAdResponse.getAd_id();
                final boolean isHtmlBanner = CPBannerMgr.this.parseAssets(CPBannerMgr.this.cpAdResponse);
                CPAdManager.getInstance(CPBannerMgr.this.getContext()).load(CPBannerMgr.this.campaignId, new CPLoader.CPLoaderListener(){

                    @Override
                    public void onSuccess() {
                        if (CPBannerMgr.this.mCPBannerAdListener != null && !isHtmlBanner) {
                            Log.i((String)CPBannerMgr.TAG, (String)"CPAdManager load onAdLoaded: ");
                            CPBannerMgr.this.mCPBannerAdListener.onAdLoaded();
                        }
                    }

                    @Override
                    public void onFailed(CPError msg) {
                        if (CPBannerMgr.this.mCPBannerAdListener != null) {
                            CPBannerMgr.this.mCPBannerAdListener.onAdLoadFailed(CPErrorUtil.getTradPlusErrorCode(msg));
                        }
                    }
                }, CPBannerMgr.this.adSourceId);
            }

            @Override
            public void onError(int code, String msg) {
                if (CPBannerMgr.this.mCPBannerAdListener != null) {
                    EventSendMessageUtil.getInstance().sendOpenAPIStart(CPBannerMgr.this.getContext(), "", CPBannerMgr.this.adSourceId, "");
                    EventSendMessageUtil.getInstance().sendLoadAdNetworkStart(CPBannerMgr.this.getContext(), CPBannerMgr.this.campaignId, CPBannerMgr.this.adSourceId);
                    EventLoadEndRequest eventLoadEndRequest = new EventLoadEndRequest(CPBannerMgr.this.getContext(), EventPushMessageUtils.EventPushStats.EV_LOAD_AD_END.getValue());
                    eventLoadEndRequest.setCampaign_id(CPBannerMgr.this.campaignId);
                    eventLoadEndRequest.setAsu_id(CPBannerMgr.this.adSourceId);
                    eventLoadEndRequest.setError_code(TPError.parseErrorCode((int)code));
                    long loadTime = RequestUtils.getInstance().countRuntime(eventLoadEndRequest.getCreateTime());
                    eventLoadEndRequest.setLoad_time(loadTime + "");
                    TPPushCenter.getInstance().saveCrossEvent((EventBaseRequest)eventLoadEndRequest);
                    CPBannerMgr.this.mCPBannerAdListener.onAdLoadFailed(CPErrorUtil.getErrorCode(code, msg));
                }
            }
        });
        cpAdConfigController.loadConfig(this.getContext(), this.campaignId, this.adUnitId, this.adSourceId, "4", 0);
    }

    private boolean parseAssets(CPAdResponse cpAdResponse) {
        int close_button = cpAdResponse.getClose_button();
        if (2 == close_button) {
            LogUtil.ownShow((String)"close button is hide", (String)TAG);
            this.isShowClose = 2;
        }
        int ad_size = cpAdResponse.getAd_size();
        this.setBannerWidthAndHeight(ad_size);
        int material_type = cpAdResponse.getMaterial_type();
        if (1 == material_type) {
            String materialSize = this.calculateAdSize(String.valueOf(ad_size));
            String endCardUrl = "";
            String endCardBigPicUrl = "";
            List end_card = cpAdResponse.getEnd_card();
            for (CPAdResponse.EndCardBean endCardBean : end_card) {
                String type;
                if (endCardBean == null || TextUtils.isEmpty((CharSequence)(type = endCardBean.getType()))) continue;
                if (materialSize.equals(type)) {
                    endCardUrl = endCardBean.getUrl();
                }
                if (!"11".equals(type)) continue;
                endCardBigPicUrl = endCardBean.getUrl();
            }
            LogUtil.ownShow((String)("materialType:" + material_type + ", materialSize :" + materialSize), (String)TAG);
            if (TextUtils.isEmpty((CharSequence)endCardUrl)) {
                LogUtil.ownShow((String)("use endCardBigPic to nativebanner:" + endCardBigPicUrl), (String)TAG);
                this.showNativeBanner(materialSize, endCardBigPicUrl, cpAdResponse);
                return false;
            }
            LogUtil.ownShow((String)("use endCardUrl to Media banner:" + endCardUrl), (String)TAG);
            this.showImageBanner(endCardUrl);
            return false;
        }
        String html_content = cpAdResponse.getHtml_content();
        this.decodeHtmlBanner(html_content);
        return true;
    }

    private void showImageBanner(String endCardUrl) {
        ImageView imageView = new ImageView(this.getContext());
        TPImageLoader.getInstance().loadImage(imageView, endCardUrl);
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        frameLayout.addView((View)imageView);
        ArrayList<View> clickViews = new ArrayList<View>();
        clickViews.add((View)imageView);
        this.addViewToBanner((ViewGroup)frameLayout, null, clickViews);
    }

    private void decodeHtmlBanner(String htmlContent) {
        String htmlurl = "";
        if (!TextUtils.isEmpty((CharSequence)htmlContent)) {
            byte[] bytes = new byte[]{};
            if (Build.VERSION.SDK_INT >= 19) {
                bytes = htmlContent.getBytes(StandardCharsets.UTF_8);
            }
            byte[] decode = Base64.decode((byte[])bytes, (int)0);
            if (Build.VERSION.SDK_INT >= 19) {
                htmlurl = new String(decode, StandardCharsets.UTF_8);
            }
        }
        LogUtil.ownShow((String)("use htmlurl to show banner:" + htmlurl), (String)TAG);
        if (!TextUtils.isEmpty((CharSequence)htmlurl)) {
            this.showHtmlBanner(htmlurl);
        }
    }

    private void showHtmlBanner(final String endCardUrl) {
        TPTaskManager.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                BannerHtmlWebView webView = new BannerHtmlWebView(CPBannerMgr.this.getContext());
                webView.setLoadListener(new BaseWebView.InnerHtmlLoadListener(){

                    @Override
                    public void onLoaded() {
                        if (CPBannerMgr.this.mCPBannerAdListener != null) {
                            CPBannerMgr.this.mCPBannerAdListener.onAdLoaded();
                        }
                    }

                    @Override
                    public void onClicked() {
                        CPBannerMgr.this.adClicked();
                    }

                    @Override
                    public void onJump(String url) {
                    }

                    @Override
                    public void onDestory() {
                    }
                });
                ((BaseWebView)webView).loadHtmlResponse(endCardUrl);
                CPBannerMgr.this.addViewToBanner((ViewGroup)webView, null, null);
            }
        });
        this.visibilityTracker((ViewGroup)this.bannerView);
    }

    private void showNativeBanner(String materialSize, String cardBigPicUrl, CPAdResponse cpAdResponse) {
        NativeBannerFactory nativeBannerFactory = new NativeBannerFactory();
        nativeBannerFactory.setShowClose(this.isShowClose == 1);
        ViewGroup view = nativeBannerFactory.createNativeBanner(this.getContext(), cpAdResponse, cardBigPicUrl, materialSize);
        if (view == null) {
            if (this.mCPBannerAdListener != null) {
                TPError tpError = new TPError("Third-party network failed to provide an ad.");
                tpError.setErrorMessage("nativeBannerFactory adLayout == null or context == null");
                this.mCPBannerAdListener.onAdLoadFailed(tpError);
            }
            return;
        }
        ImageView closeImageView = nativeBannerFactory.getCloseImageView();
        this.addViewToBanner(view, closeImageView, nativeBannerFactory.getClickViews());
    }

    private void addViewToBanner(final ViewGroup viewGroup, ImageView closeImageView, ArrayList<View> clickViews) {
        RelativeLayout.LayoutParams lp;
        RelativeLayout relativeLayout;
        FrameLayout.LayoutParams layoutParams = this.width > 0 && this.height > 0 ? new FrameLayout.LayoutParams(ViewUtil.dp2px(this.getContext(), this.width), ViewUtil.dp2px(this.getContext(), this.height)) : new FrameLayout.LayoutParams(-1, -2);
        layoutParams.gravity = 17;
        LogUtil.ownShow((String)("addViewToBanner width:" + this.width + ", height :" + this.height), (String)TAG);
        if (this.bannerView != null) {
            this.bannerView.addView((View)viewGroup, (ViewGroup.LayoutParams)layoutParams);
        }
        if (this.isShowClose == 1) {
            if (closeImageView != null) {
                closeImageView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        EventSendMessageUtil.getInstance().sendAdVideoClose(CPBannerMgr.this.getContext(), CPBannerMgr.this.campaignId, CPBannerMgr.this.mAdId, "1", CPBannerMgr.this.adSourceId);
                        if (CPBannerMgr.this.mCPBannerAdListener != null) {
                            CPBannerMgr.this.mCPBannerAdListener.onAdClosed();
                        }
                        if (viewGroup != null) {
                            viewGroup.removeAllViews();
                        }
                    }
                });
            } else {
                ImageView closeBtn = new ImageView(this.getContext());
                closeBtn.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        EventSendMessageUtil.getInstance().sendAdVideoClose(CPBannerMgr.this.getContext(), CPBannerMgr.this.campaignId, CPBannerMgr.this.mAdId, "1", CPBannerMgr.this.adSourceId);
                        if (CPBannerMgr.this.mCPBannerAdListener != null) {
                            CPBannerMgr.this.mCPBannerAdListener.onAdClosed();
                        }
                        if (viewGroup != null) {
                            viewGroup.removeAllViews();
                        }
                    }
                });
                closeBtn.setBackgroundResource(R.drawable.cp_bg_banner_close);
                relativeLayout = new RelativeLayout(this.getContext());
                lp = new RelativeLayout.LayoutParams(ViewUtil.dp2px(this.getContext(), 15.0f), ViewUtil.dp2px(this.getContext(), 15.0f));
                lp.addRule(10);
                lp.addRule(11);
                relativeLayout.addView((View)closeBtn, (ViewGroup.LayoutParams)lp);
                if (viewGroup != null) {
                    viewGroup.addView((View)relativeLayout);
                }
            }
        }
        if (closeImageView == null) {
            ImageView adImageView = new ImageView(this.getContext());
            adImageView.setBackgroundResource(R.drawable.cp_bg_banner_ad);
            relativeLayout = new RelativeLayout(this.getContext());
            lp = new RelativeLayout.LayoutParams(ViewUtil.dp2px(this.getContext(), 16.0f), ViewUtil.dp2px(this.getContext(), 10.0f));
            lp.addRule(12);
            lp.addRule(11);
            relativeLayout.addView((View)adImageView, (ViewGroup.LayoutParams)lp);
            if (viewGroup != null) {
                viewGroup.addView((View)relativeLayout);
            }
            if (clickViews != null) {
                clickViews.add((View)adImageView);
            }
        }
        if (clickViews != null) {
            this.registerView(viewGroup, clickViews);
        }
    }

    private void registerView(ViewGroup viewGroup, ArrayList<View> clickableViews) {
        if (viewGroup == null) {
            if (this.mCPBannerAdListener != null) {
                this.mCPBannerAdListener.onShowFailed(new TPError("registerView viewGroup is null"));
            }
            EventSendMessageUtil.getInstance().sendShowEndAd(this.getContext(), this.campaignId, this.mAdId, "14", this.adSourceId);
            return;
        }
        try {
            ArrayList<View> tempAllChild = new ArrayList<View>();
            this.getAllChildByViewGroup(viewGroup, tempAllChild);
            this.registerViewClick(tempAllChild, clickableViews, this.onClickListener);
        }
        catch (Exception e) {
            Log.v((String)TAG, (String)("register view click exception:" + e));
        }
        this.visibilityTracker(viewGroup);
    }

    private void visibilityTracker(ViewGroup viewGroup) {
        if (viewGroup == null) {
            Log.v((String)TAG, (String)"visibilityTracker bannerView == null, \u65e0\u6cd5\u76d1\u6d4b\u5c55\u793a\u72b6\u6001:");
            return;
        }
        final ViewTreeObserver viewTreeObserver = viewGroup.getViewTreeObserver();
        if (!viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                CPBannerMgr.this.notifyShow();
            }
        });
    }

    private void notifyShow() {
        if (this.mIsShowing) {
            return;
        }
        EventSendMessageUtil.getInstance().sendShowAdStart(this.getContext(), this.campaignId, this.mAdId, this.adSourceId);
        this.mIsShowing = true;
        if (this.cpAdResponse != null && this.getContext() != null) {
            this.sendTrackStart(this.getContext(), false);
            EventShowEndRequest _eventShowEndRequest = new EventShowEndRequest(this.getContext(), EventPushMessageUtils.EventPushStats.EV_SHOW_PUSH_FAILED.getValue());
            _eventShowEndRequest.setCampaign_id(this.campaignId);
            _eventShowEndRequest.setAd_id(this.mAdId);
            _eventShowEndRequest.setAsu_id(this.adSourceId);
            EventSendMessageUtil.getInstance().pushTrackToServer(this.getContext(), this.replanceTrackIds(this.cpAdResponse.getImp_track_url_list()), _eventShowEndRequest);
        }
        EventSendMessageUtil.getInstance().sendShowEndAd(this.getContext(), this.campaignId, this.mAdId, "1", this.adSourceId);
        if (this.mCPBannerAdListener != null) {
            this.mCPBannerAdListener.onAdImpression();
        }
    }

    protected void registerViewClick(ArrayList<View> tempAllChild, List<View> clickableViews, View.OnClickListener onClickListener) {
        if (clickableViews != null) {
            for (View view : clickableViews) {
                if (!tempAllChild.contains(view)) continue;
                view.setOnClickListener(onClickListener);
            }
            return;
        }
        for (View view : tempAllChild) {
            view.setOnClickListener(onClickListener);
        }
    }

    protected void getAllChildByViewGroup(ViewGroup viewGroup, ArrayList<View> allChild) {
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View view = viewGroup.getChildAt(i);
            if (view instanceof ViewGroup) {
                this.getAllChildByViewGroup((ViewGroup)view, allChild);
            }
            allChild.add(view);
        }
    }

    public void adClicked() {
        final boolean[] isClicked = new boolean[]{true};
        CPClickController cpClickController = new CPClickController(this.getContext(), this.cpAdResponse, this.adSourceId);
        cpClickController.startClick("", new CPClickController.ClickStatusCallback(){

            @Override
            public void clickStart() {
                EventSendMessageUtil.getInstance().sendClickAd(CPBannerMgr.this.getContext(), CPBannerMgr.this.campaignId, CPBannerMgr.this.cpAdResponse.getAd_id(), CPBannerMgr.this.adSourceId);
                isClicked[0] = true;
            }

            @Override
            public void clickEnd() {
                isClicked[0] = false;
            }

            @Override
            public void downloadApp(final String url) {
                TaskUtils.runOnUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CPAdManager.getInstance(CPBannerMgr.this.getContext()).startDownloadApp(CPBannerMgr.this.campaignId, CPBannerMgr.this.cpAdResponse, url, CPBannerMgr.this.adSourceId);
                    }
                });
            }
        });
        if (this.cpAdResponse != null && this.getContext() != null) {
            this.sendTrackStart(this.getContext(), true);
            EventShowEndRequest _eventShowEndRequest = new EventShowEndRequest(this.getContext(), EventPushMessageUtils.EventPushStats.EV_CLICK_PUSH_FAILED.getValue());
            _eventShowEndRequest.setCampaign_id(this.cpAdResponse.getCampaign_id());
            _eventShowEndRequest.setAd_id(this.cpAdResponse.getAd_id());
            _eventShowEndRequest.setAsu_id(this.adSourceId);
            EventSendMessageUtil.getInstance().pushTrackToServer(this.getContext(), this.replanceTrackIds(this.cpAdResponse.getClick_track_url_list()), _eventShowEndRequest);
        }
        if (this.mCPBannerAdListener != null) {
            this.mCPBannerAdListener.onAdClicked();
        }
    }

    private void sendTrackStart(Context context, boolean isClick) {
        List<String> _list = this.replanceTrackIds(isClick ? this.cpAdResponse.getClick_track_url_list() : this.cpAdResponse.getImp_track_url_list());
        if (_list != null) {
            for (int i = 0; i < _list.size(); ++i) {
                EventSendMessageUtil.getInstance().sendThirdCheckStart(context, this.cpAdResponse.getCampaign_id(), this.cpAdResponse.getAd_id(), this.adSourceId, isClick, _list.get(i));
            }
        }
    }

    private List<String> replanceTrackIds(List<String> list) {
        ArrayList<String> _list = new ArrayList<String>();
        TPDataManager tpDataManager = TPDataManager.getInstance();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String url = list.get(i).replace("__TP_REQ_ID__", tpDataManager.getIds(this.adSourceId).getRequest_id()).replace("__TP_IMP_ID__", tpDataManager.getIds(this.adSourceId).getImpression_id()).replace("__TP_CLK_ID__", tpDataManager.getIds(this.adSourceId).getClick_id());
                LogUtil.ownShow((String)("cross pro url = " + url));
                _list.add(url);
            }
        }
        return _list;
    }

    @Override
    public void show() {
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public CPBannerAdListener getCPBannerAdListener() {
        return this.mCPBannerAdListener;
    }

    public void setCPBannerAdListener(CPBannerAdListener cpBannerAdListener) {
        this.mCPBannerAdListener = cpBannerAdListener;
    }

    public String calculateAdSize(String adSize) {
        if ("2".equals(adSize)) {
            return "8";
        }
        if ("3".equals(adSize)) {
            return "9";
        }
        if ("4".equals(adSize)) {
            return "10";
        }
        return "7";
    }

    private void setBannerWidthAndHeight(int ad_size) {
        switch (ad_size) {
            case 1: {
                this.width = 320;
                this.height = 50;
                break;
            }
            case 2: {
                this.width = 320;
                this.height = 90;
                break;
            }
            case 3: {
                this.width = 300;
                this.height = 250;
                break;
            }
            case 4: {
                this.width = 728;
                this.height = 90;
            }
        }
    }

    public void onDestroy() {
        if (this.bannerView != null) {
            this.bannerView.removeAllViews();
            this.bannerView = null;
        }
    }
}

