/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.network.banner.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.tradplus.crosspro.network.banner.views.BaseWebView;
import java.lang.reflect.Method;

public class BannerHtmlWebView
extends BaseWebView {
    private static final int MAX_DISTANCE_FOR_CLICK = 100;
    private int mDownX = 0;
    private int mDownY = 0;
    private boolean mIsWaitUpEvent = false;
    private boolean mIsLoaded = false;
    private Context context;

    public BannerHtmlWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BannerHtmlWebView(Context context) {
        super(context);
        this.context = context;
        this.disableScrollingAndZoom();
        this.initializeWebView();
        this.setBackgroundColor(0);
        this.setWebViewClient();
    }

    public void loadUrl(String url) {
        if (url == null) {
            return;
        }
        super.loadUrl(url);
    }

    public void stopLoading() {
        if (this.mIsDestroyed) {
            return;
        }
        WebSettings webSettings = this.getSettings();
        if (webSettings == null) {
            return;
        }
        webSettings.setJavaScriptEnabled(false);
        super.stopLoading();
        webSettings.setJavaScriptEnabled(true);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.mDownX = (int)event.getX();
            this.mDownY = (int)event.getY();
            this.mIsWaitUpEvent = true;
        }
        if (event.getAction() == 2) {
            int mTempX = (int)event.getX();
            int mTempY = (int)event.getY();
            if (Math.abs(mTempX - this.mDownX) > 100 || Math.abs(mTempY - this.mDownY) > 100) {
                this.mIsWaitUpEvent = false;
            }
        }
        if (event.getAction() == 1 && this.mIsWaitUpEvent) {
            this.mIsWaitUpEvent = false;
            if (this.loadListener != null) {
                this.loadListener.onClicked();
            }
        }
        if (event.getAction() == 3) {
            this.mIsWaitUpEvent = false;
        }
        return super.onTouchEvent(event);
    }

    private void setWebViewClient() {
        this.setWebViewClient(new WebViewClient(){
            private int running = 0;

            public boolean shouldOverrideUrlLoading(WebView view, String urlNewString) {
                ++this.running;
                if (BannerHtmlWebView.this.loadListener != null) {
                    BannerHtmlWebView.this.loadListener.onJump(urlNewString);
                }
                return true;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                this.running = Math.max(this.running, 1);
            }

            public void onPageFinished(WebView view, String url) {
                if (--this.running == 0) {
                    if (BannerHtmlWebView.this.mIsLoaded) {
                        return;
                    }
                    BannerHtmlWebView.this.mIsLoaded = true;
                    if (BannerHtmlWebView.this.loadListener != null) {
                        BannerHtmlWebView.this.loadListener.onLoaded();
                    }
                }
                BannerHtmlWebView.this.setWebViewScaleJS();
            }
        });
    }

    @Override
    public void destroy() {
        super.destroy();
        this.loadListener = null;
    }

    protected void onDetachedFromWindow() {
        if (this.loadListener != null) {
            this.loadListener.onDestory();
        }
        super.onDetachedFromWindow();
    }

    private void disableScrollingAndZoom() {
        this.setHorizontalScrollBarEnabled(false);
        this.setHorizontalScrollbarOverlay(false);
        this.setVerticalScrollBarEnabled(false);
        this.setVerticalScrollbarOverlay(false);
        this.requestFocus();
    }

    private void initializeWebView() {
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        if (Build.VERSION.SDK_INT < 33) {
            webSettings.setAppCacheEnabled(true);
            webSettings.setAppCacheMaxSize(0x100000L);
            webSettings.setAppCachePath(this.getContext().getCacheDir().getAbsolutePath());
        }
        webSettings.setDatabasePath(this.getContext().getCacheDir().getAbsolutePath());
        webSettings.setAllowFileAccess(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        webSettings.setDomStorageEnabled(true);
        webSettings.setSupportZoom(false);
        webSettings.setSavePassword(false);
        webSettings.setDatabaseEnabled(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        if (Build.VERSION.SDK_INT >= 17) {
            webSettings.setMediaPlaybackRequiresUserGesture(false);
        }
        try {
            if (Build.VERSION.SDK_INT >= 16) {
                webSettings.setAllowUniversalAccessFromFileURLs(true);
            }
        }
        catch (Throwable var6) {
            var6.printStackTrace();
        }
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                webSettings.setMixedContentMode(0);
            }
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
        if (Build.VERSION.SDK_INT >= 11) {
            try {
                Method var7 = WebSettings.class.getDeclaredMethod("setDisplayZoomControls", Boolean.TYPE);
                var7.setAccessible(true);
                var7.invoke((Object)webSettings, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void loadHtmlResponse(String htmlResponse) {
        this.mIsLoaded = false;
        this.loadDataWithBaseURL(null, htmlResponse, "text/html", "utf-8", null);
    }
}

