/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.network.banner.views;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.tradplus.ads.base.common.TPImageLoader;
import com.tradplus.ads.base.network.response.CPAdResponse;
import com.tradplus.ads.common.util.ResourceUtils;
import java.util.ArrayList;

public class NativeBannerFactory {
    private ImageView bannerCloseImageView;
    private boolean bannerSize_300_250 = false;
    private boolean isShowClose = true;
    private ArrayList<View> clickViews = new ArrayList();

    public ViewGroup createNativeBanner(Context context, CPAdResponse cpAdResponse, String cardBigPicUrl, String adSize) {
        int bannerIconClose;
        int bannerIconImageId;
        int bannerCTAId;
        int bannerSubTitleId;
        String packageName;
        Resources resources;
        int bannerTitleId;
        if (context == null) {
            return null;
        }
        String layoutName = this.calculateAdLayout(adSize);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        ViewGroup adLayout = (ViewGroup)inflater.inflate(ResourceUtils.getLayoutIdByName((Context)context, (String)layoutName), null);
        if (adLayout == null) {
            return null;
        }
        if (adLayout.getParent() != null) {
            ((ViewGroup)adLayout.getParent()).removeView((View)adLayout);
        }
        if ((bannerTitleId = (resources = context.getResources()).getIdentifier("cp_banner_title", "id", packageName = context.getPackageName())) > 0) {
            TextView bannerTitleView = (TextView)adLayout.findViewById(bannerTitleId);
            String title = cpAdResponse.getTitle();
            if (!TextUtils.isEmpty((CharSequence)title)) {
                bannerTitleView.setText((CharSequence)title);
            }
            this.clickViews.add((View)bannerTitleView);
        }
        if ((bannerSubTitleId = resources.getIdentifier("cp_banner_text", "id", packageName)) > 0) {
            TextView bannerSubTitleView = (TextView)adLayout.findViewById(bannerSubTitleId);
            String description = cpAdResponse.getDescription();
            if (!TextUtils.isEmpty((CharSequence)description)) {
                bannerSubTitleView.setText((CharSequence)description);
            }
            this.clickViews.add((View)bannerSubTitleView);
        }
        if ((bannerCTAId = resources.getIdentifier("cp_banner_cta_btn", "id", packageName)) > 0) {
            TextView bannerCTAView = (TextView)adLayout.findViewById(bannerCTAId);
            String button = cpAdResponse.getButton();
            if (!TextUtils.isEmpty((CharSequence)button)) {
                bannerCTAView.setText((CharSequence)button);
            }
            this.clickViews.add((View)bannerCTAView);
        }
        if ((bannerIconImageId = resources.getIdentifier("cp_banner_icon_image", "id", packageName)) > 0) {
            ImageView bannerIconImageView = (ImageView)adLayout.findViewById(bannerIconImageId);
            String icon = cpAdResponse.getIcon();
            if (!TextUtils.isEmpty((CharSequence)icon)) {
                TPImageLoader.getInstance().loadImage(bannerIconImageView, icon);
            }
            this.clickViews.add((View)bannerIconImageView);
        }
        if (this.bannerSize_300_250) {
            int bannerMainImageId = resources.getIdentifier("cp_banner_main_image", "id", packageName);
            ImageView bannerMainImageView = null;
            if (bannerMainImageId > 0) {
                bannerMainImageView = (ImageView)adLayout.findViewById(bannerMainImageId);
                if (!TextUtils.isEmpty((CharSequence)cardBigPicUrl)) {
                    TPImageLoader.getInstance().loadImage(bannerMainImageView, cardBigPicUrl);
                }
                this.clickViews.add((View)bannerMainImageView);
            }
        }
        int bannerIconAd = resources.getIdentifier("cp_banner_ad", "id", packageName);
        ImageView bannerIconAdImageView = null;
        if (bannerIconAd > 0) {
            bannerIconAdImageView = (ImageView)adLayout.findViewById(bannerIconAd);
            this.clickViews.add((View)bannerIconAdImageView);
        }
        if (this.isShowClose && (bannerIconClose = resources.getIdentifier("cp_banner_close", "id", packageName)) > 0) {
            this.bannerCloseImageView = (ImageView)adLayout.findViewById(bannerIconClose);
            this.bannerCloseImageView.setVisibility(0);
        }
        return adLayout;
    }

    public String calculateAdLayout(String adSize) {
        if ("8".equals(adSize)) {
            return "cp_layout_banner_320_90";
        }
        if ("9".equals(adSize)) {
            this.bannerSize_300_250 = true;
            return "cp_layout_banner_300_250";
        }
        if ("10".equals(adSize)) {
            return "cp_layout_banner_728_90";
        }
        return "cp_layout_banner_320_50";
    }

    public void setShowClose(boolean isShowClose) {
        this.isShowClose = isShowClose;
    }

    public ImageView getCloseImageView() {
        return this.bannerCloseImageView;
    }

    public ArrayList<View> getClickViews() {
        return this.clickViews;
    }
}

