/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.network.nativead;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.RelativeLayout;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.base.event.TPPushCenter;
import com.tradplus.ads.base.network.response.CPAdResponse;
import com.tradplus.ads.common.TaskUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.network.CPErrorUtil;
import com.tradplus.ads.pushcenter.event.EventBaseRequest;
import com.tradplus.ads.pushcenter.event.EventSendMessageUtil;
import com.tradplus.ads.pushcenter.event.request.EventLoadEndRequest;
import com.tradplus.ads.pushcenter.event.request.EventShowEndRequest;
import com.tradplus.ads.pushcenter.event.utils.EventPushMessageUtils;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.crosspro.manager.CPAdConfigController;
import com.tradplus.crosspro.manager.CPAdManager;
import com.tradplus.crosspro.manager.CPClickController;
import com.tradplus.crosspro.manager.resource.CPLoader;
import com.tradplus.crosspro.network.base.CPBaseAd;
import com.tradplus.crosspro.network.base.CPError;
import com.tradplus.crosspro.network.nativead.CPNativeAdListener;
import com.tradplus.crosspro.network.nativead.NativeAd;
import com.tradplus.crosspro.ui.PlayerView;
import java.util.ArrayList;
import java.util.List;

public class CPNativeAd
extends CPBaseAd {
    private String mAdId;
    protected NativeAd mNativeAd;
    private CPAdResponse cpAdResponse;
    private CPNativeAdListener cpNativeAdListener;
    private boolean isNative = true;
    private boolean videoMute = true;
    private static final String TAG = "CrossPro";
    private boolean mIsShowing = false;
    View.OnClickListener onClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            try {
                CPNativeAd.this.adClicked();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };

    public CPNativeAd(Context context, String campaignId, String adUnitId, String adSourceId) {
        super(context, campaignId, adUnitId, adSourceId);
    }

    @Override
    public void load() {
        LogUtil.ownShow((String)"OpenAPIStart...");
        CPAdConfigController cpAdConfigController = new CPAdConfigController();
        cpAdConfigController.setOnConfigListener(new CPAdConfigController.OnConfigListener(){

            @Override
            public void onSuccess(String pid) {
                CPNativeAd.this.cpAdResponse = CPAdManager.getInstance(CPNativeAd.this.getContext()).getCpAdConfig(CPNativeAd.this.campaignId);
                CPNativeAd.this.mAdId = CPNativeAd.this.cpAdResponse.getAd_id();
                TPDataManager.getInstance().putIds(CPNativeAd.this.adSourceId);
                EventSendMessageUtil.getInstance().sendLoadAdNetworkStart(CPNativeAd.this.getContext(), CPNativeAd.this.campaignId, CPNativeAd.this.adSourceId);
                final NativeAd cpAdNative = CPNativeAd.this.checkCPAdNativeAd(CPNativeAd.this.cpAdResponse);
                if (cpAdNative == null) {
                    EventLoadEndRequest eventLoadEndRequest = new EventLoadEndRequest(CPNativeAd.this.getContext(), EventPushMessageUtils.EventPushStats.EV_LOAD_AD_END.getValue());
                    eventLoadEndRequest.setCampaign_id(CPNativeAd.this.campaignId);
                    eventLoadEndRequest.setAsu_id(CPNativeAd.this.adSourceId);
                    eventLoadEndRequest.setError_code("\u5fc5\u4f20\u7d20\u6750\u4e3a\u7a7a");
                    long loadTime = RequestUtils.getInstance().countRuntime(eventLoadEndRequest.getCreateTime());
                    eventLoadEndRequest.setLoad_time(loadTime + "");
                    TPPushCenter.getInstance().saveCrossEvent((EventBaseRequest)eventLoadEndRequest);
                    if (CPNativeAd.this.cpNativeAdListener != null) {
                        CPNativeAd.this.cpNativeAdListener.onAdLoadFailed(new TPError("\u5fc5\u4f20\u7d20\u6750\u4e3a\u7a7a"));
                    }
                    return;
                }
                CPAdManager.getInstance(CPNativeAd.this.getContext()).load(CPNativeAd.this.campaignId, new CPLoader.CPLoaderListener(){

                    @Override
                    public void onSuccess() {
                        if (CPNativeAd.this.cpNativeAdListener != null) {
                            CPNativeAd.this.cpNativeAdListener.onAdLoaded(cpAdNative);
                        }
                    }

                    @Override
                    public void onFailed(CPError msg) {
                        if (CPNativeAd.this.cpNativeAdListener != null) {
                            CPNativeAd.this.cpNativeAdListener.onAdLoadFailed(CPErrorUtil.getTradPlusErrorCode(msg));
                        }
                    }
                }, CPNativeAd.this.adSourceId);
            }

            @Override
            public void onError(int code, String msg) {
                if (CPNativeAd.this.cpNativeAdListener != null) {
                    EventSendMessageUtil.getInstance().sendOpenAPIStart(CPNativeAd.this.getContext(), "", CPNativeAd.this.adSourceId, "");
                    EventSendMessageUtil.getInstance().sendLoadAdNetworkStart(CPNativeAd.this.getContext(), CPNativeAd.this.campaignId, CPNativeAd.this.adSourceId);
                    EventLoadEndRequest eventLoadEndRequest = new EventLoadEndRequest(CPNativeAd.this.getContext(), EventPushMessageUtils.EventPushStats.EV_LOAD_AD_END.getValue());
                    eventLoadEndRequest.setCampaign_id(CPNativeAd.this.campaignId);
                    eventLoadEndRequest.setAsu_id(CPNativeAd.this.adSourceId);
                    eventLoadEndRequest.setError_code(TPError.parseErrorCode((int)code));
                    long loadTime = RequestUtils.getInstance().countRuntime(eventLoadEndRequest.getCreateTime());
                    eventLoadEndRequest.setLoad_time(loadTime + "");
                    TPPushCenter.getInstance().saveCrossEvent((EventBaseRequest)eventLoadEndRequest);
                    CPNativeAd.this.cpNativeAdListener.onAdLoadFailed(CPErrorUtil.getErrorCode(code, msg));
                }
            }
        });
        cpAdConfigController.loadConfig(this.getContext(), this.campaignId, this.adUnitId, this.adSourceId, "1", 0);
    }

    private NativeAd checkCPAdNativeAd(CPAdResponse cpAdResponse) {
        String endCard;
        List end_card;
        String video_url;
        String description;
        String title;
        String icon;
        this.mNativeAd = new NativeAd();
        String button = cpAdResponse.getButton();
        if (!TextUtils.isEmpty((CharSequence)button)) {
            this.mNativeAd.setButton(button);
        }
        if (!TextUtils.isEmpty((CharSequence)(icon = cpAdResponse.getIcon()))) {
            this.mNativeAd.setIcon(icon);
        }
        if (!TextUtils.isEmpty((CharSequence)(title = cpAdResponse.getTitle()))) {
            this.mNativeAd.setTitle(title);
        }
        if (!TextUtils.isEmpty((CharSequence)(description = cpAdResponse.getDescription()))) {
            this.mNativeAd.setDescription(description);
        }
        if (!TextUtils.isEmpty((CharSequence)(video_url = cpAdResponse.getVideo_url()))) {
            this.mNativeAd.setVideo_url(video_url);
            this.setPlayerVideo(cpAdResponse, this.mNativeAd);
        }
        if ((end_card = cpAdResponse.getEnd_card()) != null && !TextUtils.isEmpty((CharSequence)(endCard = ((CPAdResponse.EndCardBean)end_card.get(0)).getUrl()))) {
            this.mNativeAd.setEndCard(endCard);
        }
        if (TextUtils.isEmpty((CharSequence)button) && TextUtils.isEmpty((CharSequence)icon) && TextUtils.isEmpty((CharSequence)title) && TextUtils.isEmpty((CharSequence)description)) {
            return null;
        }
        return this.mNativeAd;
    }

    private void setPlayerVideo(final CPAdResponse cpAdResponse, NativeAd nativeAd) {
        RelativeLayout relativeLayout = new RelativeLayout(this.getContext());
        PlayerView mPlayerView = new PlayerView((ViewGroup)relativeLayout, new PlayerView.OnPlayerListener(){

            @Override
            public void onVideoPlayStart() {
                LogUtil.ownShow((String)"onVideoPlayStart...");
                EventSendMessageUtil.getInstance().sendAdVideoStart(CPNativeAd.this.getContext(), CPNativeAd.this.campaignId, CPNativeAd.this.mAdId, CPNativeAd.this.adSourceId);
                CPNativeAd.this.notifyShow();
            }

            @Override
            public void onVideoUpdateProgress(int progress) {
            }

            @Override
            public void onVideoPlayEnd() {
            }

            @Override
            public void onVideoPlayCompletion() {
            }

            @Override
            public void onVideoShowFailed(CPError error) {
                if (CPNativeAd.this.cpNativeAdListener != null) {
                    CPNativeAd.this.cpNativeAdListener.onShowFailed(new TPError(error.getDesc()));
                }
                Log.i((String)CPNativeAd.TAG, (String)("onVideoShowFailed: errorCode :" + error.getCode() + ", errorMsg :" + error.getDesc()));
                CPNativeAd.this.showFailed(error);
            }

            @Override
            public void onVideoPlayProgress(int progressArea) {
                switch (progressArea) {
                    case 25: {
                        LogUtil.ownShow((String)"onVideoProgress25.......");
                        EventSendMessageUtil.getInstance().sendAdVideoProgress25(CPNativeAd.this.getContext(), CPNativeAd.this.campaignId, CPNativeAd.this.mAdId, CPNativeAd.this.adSourceId);
                        break;
                    }
                    case 50: {
                        LogUtil.ownShow((String)"onVideoProgress50.......");
                        EventSendMessageUtil.getInstance().sendAdVideoProgress50(CPNativeAd.this.getContext(), CPNativeAd.this.campaignId, CPNativeAd.this.mAdId, CPNativeAd.this.adSourceId);
                        break;
                    }
                    case 75: {
                        LogUtil.ownShow((String)"onVideoProgress75.......");
                        EventSendMessageUtil.getInstance().sendAdVideoProgress75(CPNativeAd.this.getContext(), CPNativeAd.this.campaignId, CPNativeAd.this.mAdId, CPNativeAd.this.adSourceId);
                    }
                }
            }

            @Override
            public void onVideoCloseClick() {
            }

            @Override
            public void onVideoClick() {
                if (cpAdResponse != null) {
                    CPNativeAd.this.adClicked();
                }
            }

            @Override
            public void onVideoSkip() {
            }
        }, TradPlus.invoker().getChinaHandler() != null, false, this.isNative);
        nativeAd.setPlayerView(mPlayerView);
    }

    private void showFailed(CPError error) {
        if (error.getCode().equals("401")) {
            EventSendMessageUtil.getInstance().sendShowEndAd(this.getContext(), this.campaignId, this.mAdId, "20", this.adSourceId);
        } else if (error.getCode().equals("402")) {
            EventSendMessageUtil.getInstance().sendShowEndAd(this.getContext(), this.campaignId, this.mAdId, "24", this.adSourceId);
        } else if (error.getCode().equals("201")) {
            EventSendMessageUtil.getInstance().sendShowEndAd(this.getContext(), this.campaignId, this.mAdId, "3", this.adSourceId);
        } else if (error.getCode().equals("301")) {
            EventSendMessageUtil.getInstance().sendShowEndAd(this.getContext(), this.campaignId, this.mAdId, "5", this.adSourceId);
        }
    }

    private void notifyShow() {
        if (this.mIsShowing) {
            return;
        }
        this.mIsShowing = true;
        if (this.cpAdResponse != null && this.getContext() != null) {
            this.sendTrackStart(this.getContext(), false);
            EventShowEndRequest _eventShowEndRequest = new EventShowEndRequest(this.getContext(), EventPushMessageUtils.EventPushStats.EV_SHOW_PUSH_FAILED.getValue());
            _eventShowEndRequest.setCampaign_id(this.campaignId);
            _eventShowEndRequest.setAd_id(this.mAdId);
            _eventShowEndRequest.setAsu_id(this.adSourceId);
            EventSendMessageUtil.getInstance().pushTrackToServer(this.getContext(), this.replanceTrackIds(this.cpAdResponse.getImp_track_url_list()), _eventShowEndRequest);
        }
        if (this.cpNativeAdListener != null) {
            this.cpNativeAdListener.onAdImpression();
        }
    }

    private void sendTrackStart(Context context, boolean isClick) {
        List<String> _list = this.replanceTrackIds(isClick ? this.cpAdResponse.getClick_track_url_list() : this.cpAdResponse.getImp_track_url_list());
        if (_list != null) {
            for (int i = 0; i < _list.size(); ++i) {
                EventSendMessageUtil.getInstance().sendThirdCheckStart(context, this.cpAdResponse.getCampaign_id(), this.cpAdResponse.getAd_id(), this.adSourceId, isClick, _list.get(i));
            }
        }
    }

    private List<String> replanceTrackIds(List<String> list) {
        ArrayList<String> _list = new ArrayList<String>();
        TPDataManager tpDataManager = TPDataManager.getInstance();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String url = list.get(i).replace("__TP_REQ_ID__", tpDataManager.getIds(this.adSourceId).getRequest_id()).replace("__TP_IMP_ID__", tpDataManager.getIds(this.adSourceId).getImpression_id()).replace("__TP_CLK_ID__", tpDataManager.getIds(this.adSourceId).getClick_id());
                LogUtil.ownShow((String)("cross pro url = " + url));
                _list.add(url);
            }
        }
        return _list;
    }

    public void registerView(ViewGroup viewGroup, List<View> clickableViews) {
        EventSendMessageUtil.getInstance().sendShowAdStart(this.getContext(), this.campaignId, this.mAdId, this.adSourceId);
        if (viewGroup == null) {
            if (this.cpNativeAdListener != null) {
                this.cpNativeAdListener.onShowFailed(new TPError("registerView adLayout is null"));
            }
            EventSendMessageUtil.getInstance().sendShowEndAd(this.getContext(), this.campaignId, this.mAdId, "14", this.adSourceId);
            return;
        }
        try {
            ArrayList<View> tempAllChild = new ArrayList<View>();
            this.getAllChildByViewGroup(viewGroup, tempAllChild);
            for (View view : tempAllChild) {
                if (!(view instanceof PlayerView)) continue;
                ((PlayerView)view).setSetting(this.cpAdResponse);
                ((PlayerView)view).load(this.cpAdResponse.getVideo_url());
                ((PlayerView)view).setVideoMute(this.videoMute);
                break;
            }
            this.registerViewClick(tempAllChild, clickableViews, this.onClickListener);
        }
        catch (Exception e) {
            Log.v((String)TAG, (String)("register view click exception:" + e));
        }
        this.visibilityTracker(viewGroup);
        EventSendMessageUtil.getInstance().sendShowEndAd(this.getContext(), this.campaignId, this.mAdId, "1", this.adSourceId);
    }

    private void visibilityTracker(ViewGroup viewGroup) {
        final ViewTreeObserver viewTreeObserver = viewGroup.getViewTreeObserver();
        if (!viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                Log.i((String)CPNativeAd.TAG, (String)("mIsShowing = " + CPNativeAd.this.mIsShowing));
                CPNativeAd.this.notifyShow();
            }
        });
    }

    public void adClicked() {
        final boolean[] isClicked = new boolean[]{true};
        CPClickController cpClickController = new CPClickController(this.getContext(), this.cpAdResponse, this.adSourceId);
        cpClickController.startClick("", new CPClickController.ClickStatusCallback(){

            @Override
            public void clickStart() {
                EventSendMessageUtil.getInstance().sendClickAd(CPNativeAd.this.getContext(), CPNativeAd.this.campaignId, CPNativeAd.this.cpAdResponse.getAd_id(), CPNativeAd.this.adSourceId);
                isClicked[0] = true;
            }

            @Override
            public void clickEnd() {
                isClicked[0] = false;
            }

            @Override
            public void downloadApp(final String url) {
                TaskUtils.runOnUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CPAdManager.getInstance(CPNativeAd.this.getContext()).startDownloadApp(CPNativeAd.this.campaignId, CPNativeAd.this.cpAdResponse, url, CPNativeAd.this.adSourceId);
                    }
                });
            }
        });
        if (this.cpAdResponse != null && this.getContext() != null) {
            this.sendTrackStart(this.getContext(), true);
            EventShowEndRequest _eventShowEndRequest = new EventShowEndRequest(this.getContext(), EventPushMessageUtils.EventPushStats.EV_CLICK_PUSH_FAILED.getValue());
            _eventShowEndRequest.setCampaign_id(this.cpAdResponse.getCampaign_id());
            _eventShowEndRequest.setAd_id(this.cpAdResponse.getAd_id());
            _eventShowEndRequest.setAsu_id(this.adSourceId);
            EventSendMessageUtil.getInstance().pushTrackToServer(this.getContext(), this.replanceTrackIds(this.cpAdResponse.getClick_track_url_list()), _eventShowEndRequest);
        }
        if (this.cpNativeAdListener != null) {
            this.cpNativeAdListener.onAdClicked();
        }
    }

    protected void registerViewClick(ArrayList<View> tempAllChild, List<View> clickableViews, View.OnClickListener onClickListener) {
        if (clickableViews != null) {
            for (View view : clickableViews) {
                if (!tempAllChild.contains(view)) continue;
                view.setOnClickListener(onClickListener);
            }
            return;
        }
        for (View view : tempAllChild) {
            view.setOnClickListener(onClickListener);
        }
    }

    protected void getAllChildByViewGroup(ViewGroup viewGroup, ArrayList<View> allChild) {
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View view = viewGroup.getChildAt(i);
            if (view instanceof ViewGroup) {
                this.getAllChildByViewGroup((ViewGroup)view, allChild);
            }
            allChild.add(view);
        }
    }

    public long getExpreTime() {
        CPAdResponse _cpAdResponse = CPAdManager.getInstance(this.getContext()).getCpAdConfig(this.campaignId);
        if (_cpAdResponse != null && _cpAdResponse.getAd_expire_time() > 0) {
            return _cpAdResponse.getAd_expire_time() * 1000;
        }
        return 10800000L;
    }

    @Override
    public void show() {
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public CPNativeAdListener getCpNativeAdListener() {
        return this.cpNativeAdListener;
    }

    public void setCpNativeAdListener(CPNativeAdListener cpNativeAdListener) {
        this.cpNativeAdListener = cpNativeAdListener;
    }

    public void setVideoMute(boolean videoMute) {
        this.videoMute = videoMute;
    }
}

