/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.network.splash;

import android.content.Context;
import android.view.View;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.base.event.TPPushCenter;
import com.tradplus.ads.base.network.response.CPAdResponse;
import com.tradplus.ads.network.CPErrorUtil;
import com.tradplus.ads.pushcenter.event.EventBaseRequest;
import com.tradplus.ads.pushcenter.event.EventSendMessageUtil;
import com.tradplus.ads.pushcenter.event.request.EventLoadEndRequest;
import com.tradplus.ads.pushcenter.event.utils.EventPushMessageUtils;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.crosspro.manager.CPAdConfigController;
import com.tradplus.crosspro.manager.CPAdManager;
import com.tradplus.crosspro.manager.resource.CPLoader;
import com.tradplus.crosspro.network.base.CPBaseAd;
import com.tradplus.crosspro.network.base.CPError;
import com.tradplus.crosspro.network.splash.CPSplashAdListener;
import com.tradplus.crosspro.ui.EndCardView;
import com.tradplus.crosspro.ui.SplashView;

public class CPSplashAd
extends CPBaseAd {
    private CPSplashAdListener cpSplashAdListener;
    private String mAdId;
    private int countdown_time;
    private int is_skipable;
    private int direction;

    public CPSplashAd(Context context, String campaignId, String adUnitId, String adSourceId, int countdown_time, int is_skipable, int direction) {
        super(context, campaignId, adUnitId, adSourceId);
        this.countdown_time = countdown_time;
        this.is_skipable = is_skipable;
        this.direction = direction;
    }

    @Override
    public void load() {
        CPAdConfigController cpAdConfigController = new CPAdConfigController();
        cpAdConfigController.setOnConfigListener(new CPAdConfigController.OnConfigListener(){

            @Override
            public void onSuccess(String pid) {
                CPSplashAd.this.mAdId = CPAdManager.getInstance(CPSplashAd.this.getContext()).getCpAdConfig(CPSplashAd.this.campaignId).getAd_id();
                TPDataManager.getInstance().putIds(CPSplashAd.this.adSourceId);
                EventSendMessageUtil.getInstance().sendLoadAdNetworkStart(CPSplashAd.this.getContext(), CPSplashAd.this.campaignId, CPSplashAd.this.adSourceId);
                CPAdManager.getInstance(CPSplashAd.this.getContext()).load(CPSplashAd.this.campaignId, new CPLoader.CPLoaderListener(){

                    @Override
                    public void onSuccess() {
                        if (CPSplashAd.this.cpSplashAdListener != null) {
                            CPSplashAd.this.cpSplashAdListener.onInterstitialLoaded();
                        }
                    }

                    @Override
                    public void onFailed(CPError msg) {
                        if (CPSplashAd.this.cpSplashAdListener != null) {
                            CPSplashAd.this.cpSplashAdListener.onInterstitialFailed(CPErrorUtil.getTradPlusErrorCode(msg));
                        }
                    }
                }, CPSplashAd.this.adSourceId);
            }

            @Override
            public void onError(int code, String msg) {
                if (CPSplashAd.this.cpSplashAdListener != null) {
                    EventSendMessageUtil.getInstance().sendOpenAPIStart(CPSplashAd.this.getContext(), "", CPSplashAd.this.adSourceId, "");
                    EventSendMessageUtil.getInstance().sendLoadAdNetworkStart(CPSplashAd.this.getContext(), CPSplashAd.this.campaignId, CPSplashAd.this.adSourceId);
                    EventLoadEndRequest eventLoadEndRequest = new EventLoadEndRequest(CPSplashAd.this.getContext(), EventPushMessageUtils.EventPushStats.EV_LOAD_AD_END.getValue());
                    eventLoadEndRequest.setCampaign_id(CPSplashAd.this.campaignId);
                    eventLoadEndRequest.setAsu_id(CPSplashAd.this.adSourceId);
                    eventLoadEndRequest.setError_code(TPError.parseErrorCode((int)code));
                    eventLoadEndRequest.setError_message(msg);
                    long loadTime = RequestUtils.getInstance().countRuntime(eventLoadEndRequest.getCreateTime());
                    eventLoadEndRequest.setLoad_time(loadTime + "");
                    TPPushCenter.getInstance().saveCrossEvent((EventBaseRequest)eventLoadEndRequest);
                    CPSplashAd.this.cpSplashAdListener.onInterstitialFailed(CPErrorUtil.getErrorCode(code, msg));
                }
            }
        });
        cpAdConfigController.loadConfig(this.getContext(), this.campaignId, this.adUnitId, this.adSourceId, "3", this.direction, -1);
    }

    @Override
    public void show() {
    }

    public View getSplashView(OnSplashShownListener onSplashShownListener) {
        SplashView splashView = new SplashView(this.mContext);
        splashView.initView(this.mContext, this.campaignId, this.countdown_time, this.is_skipable, this.direction, this.adSourceId, new EndCardView.OnEndCardListener(){

            @Override
            public void onClickEndCard() {
                if (CPSplashAd.this.cpSplashAdListener != null) {
                    CPSplashAd.this.cpSplashAdListener.onInterstitialClicked();
                }
            }

            @Override
            public void onCloseEndCard() {
                if (CPSplashAd.this.cpSplashAdListener != null) {
                    CPSplashAd.this.cpSplashAdListener.onInterstitialDismissed();
                }
            }
        }, onSplashShownListener);
        return splashView;
    }

    public long getExpreTime() {
        CPAdResponse _cpAdResponse = CPAdManager.getInstance(this.getContext()).getCpAdConfig(this.campaignId);
        if (_cpAdResponse != null && _cpAdResponse.getAd_expire_time() > 0) {
            return _cpAdResponse.getAd_expire_time() * 1000;
        }
        return 10800000L;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public void setCpSplashAdListener(CPSplashAdListener cpSplashAdListener) {
        this.cpSplashAdListener = cpSplashAdListener;
    }

    public static interface OnSplashShownListener {
        public void onShown();
    }
}

