/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;

public class CountDownView
extends View {
    private Paint mPaint;
    private Paint mPaintBg;
    private Paint mPaintText;
    private float mThick;
    private float mTextSize;
    private int mBgColor;
    private int mUnderRingColor;
    private int mUpProgressColor;
    private int mWidth;
    private int mHeight;
    private int mRadis;
    private RectF mRectF;
    private float mSweepAngle;
    private String mCountDownTimeText;
    private Rect mCountDownTimeTextBounds;
    private int mDuration;
    private float mTextWidth;
    private Paint.FontMetrics mFontMetrics;

    public CountDownView(Context context) {
        this(context, null);
    }

    public CountDownView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mThick = TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.mTextSize = TypedValue.applyDimension((int)2, (float)13.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.mBgColor = Color.parseColor((String)"#cc505050");
        this.mUnderRingColor = Color.parseColor((String)"#505050");
        this.mUpProgressColor = -1;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mThick);
        this.mPaintBg = new Paint(this.mPaint);
        this.mPaintBg.setColor(this.mBgColor);
        this.mPaintBg.setStyle(Paint.Style.FILL);
        this.mPaintText = new Paint();
        this.mPaintText.setAntiAlias(true);
        this.mPaintText.setTextSize(this.mTextSize);
        this.mPaintText.setColor(this.mUpProgressColor);
        this.mRectF = new RectF();
        this.mCountDownTimeTextBounds = new Rect();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        float offset = this.mThick * 0.5f;
        this.mRectF.set(0.0f + offset, 0.0f + offset, (float)this.mWidth - offset, (float)this.mHeight - offset);
        this.mRadis = (int)this.mRectF.width() >> 1;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
        this.mCountDownTimeText = duration / 1000 + "";
    }

    public void setDuration(String duration) {
        this.mCountDownTimeText = duration;
    }

    public void refresh(int currentPosition) {
        this.mSweepAngle = 360.0f * ((float)currentPosition * 1.0f / (float)this.mDuration);
        this.mCountDownTimeText = (int)Math.ceil((double)(this.mDuration - currentPosition) / 1000.0) + "";
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawCircle(this.mRectF.centerX(), this.mRectF.centerY(), (float)this.mRadis, this.mPaintBg);
        this.mPaint.setColor(this.mUnderRingColor);
        canvas.drawArc(this.mRectF, 0.0f, 360.0f, false, this.mPaint);
        this.mPaint.setColor(this.mUpProgressColor);
        canvas.drawArc(this.mRectF, -90.0f, this.mSweepAngle, false, this.mPaint);
        if (!TextUtils.isEmpty((CharSequence)this.mCountDownTimeText)) {
            this.mPaintText.getTextBounds(this.mCountDownTimeText, 0, this.mCountDownTimeText.length(), this.mCountDownTimeTextBounds);
            this.mTextWidth = this.mPaintText.measureText(this.mCountDownTimeText);
            this.mFontMetrics = this.mPaintText.getFontMetrics();
            canvas.drawText(this.mCountDownTimeText, this.mRectF.centerX() - this.mTextWidth / 2.0f, this.mRectF.centerY() + ((this.mFontMetrics.bottom - this.mFontMetrics.top) / 2.0f - this.mFontMetrics.bottom), this.mPaintText);
        }
    }
}

