/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.tradplus.ads.common.util.ResourceUtils;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.mobileads.gdpr.CommonUtil;
import com.tradplus.ads.network.response.CPAdResponse;
import com.tradplus.ads.network.util.ImageLoader;
import com.tradplus.ads.network.util.ResourceEntry;

public class BannerView
extends LinearLayout {
    private Context context;
    private ImageView img_icon;
    private TextView tv_title;
    private TextView tv_desc;
    private TextView tv_choice;
    private Button btn_click;
    private OnBannerClickListener onBannerClickListener;

    public BannerView(Context context, OnBannerClickListener onBannerClickListener) {
        super(context);
        this.onBannerClickListener = onBannerClickListener;
        this.init(context);
    }

    public BannerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public void init(Context context) {
        this.context = context;
        BannerView.inflate((Context)context, (int)ResourceUtils.getLayoutIdByName((Context)context, (String)"cp_layout_banner"), (ViewGroup)this);
        this.img_icon = (ImageView)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"cp_img_icon"));
        this.tv_title = (TextView)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"cp_tv_title"));
        this.tv_desc = (TextView)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"cp_tv_desc"));
        this.btn_click = (Button)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"cp_btn_click"));
        this.tv_choice = (TextView)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"cp_tv_choice"));
    }

    public void initView(ViewGroup container, CPAdResponse cpAdResponse) {
        this.tv_title.setText((CharSequence)cpAdResponse.getTitle());
        this.tv_desc.setText((CharSequence)cpAdResponse.getDescription());
        this.btn_click.setText((CharSequence)cpAdResponse.getButton());
        this.btn_click.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BannerView.this.onBannerClickListener != null) {
                    BannerView.this.onBannerClickListener.onClick();
                }
            }
        });
        if (TradPlus.invoker().getChinaHandler() != null) {
            this.tv_choice.setText((CharSequence)"\u5e7f\u544a");
        } else {
            this.tv_choice.setText((CharSequence)"AD");
        }
        this.loadBitmap(cpAdResponse);
        this.attachTo(container);
    }

    private void attachTo(ViewGroup container) {
        int margin = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        int width = -1;
        int height = CommonUtil.dip2px((Context)this.getContext(), (float)80.0f);
        if (this.img_icon.getVisibility() != 0) {
            height = CommonUtil.dip2px((Context)this.getContext(), (float)85.0f);
        }
        RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(width, -2);
        rl.addRule(12);
        rl.addRule(11);
        rl.leftMargin = margin;
        rl.rightMargin = margin;
        rl.bottomMargin = margin;
        container.addView((View)this, (ViewGroup.LayoutParams)rl);
    }

    private void loadBitmap(CPAdResponse cpAdResponse) {
        try {
            ViewGroup.LayoutParams lp = this.img_icon.getLayoutParams();
            ImageLoader.getInstance((Context)this.getContext()).load(new ResourceEntry(1, cpAdResponse.getIcon()), lp.width, lp.height, new ImageLoader.ImageLoaderListener(){

                public void onSuccess(String url, Bitmap bitmap) {
                    BannerView.this.img_icon.setImageBitmap(bitmap);
                }

                public void onFail(String url, String errorMsg) {
                }
            });
        }
        catch (OutOfMemoryError oom) {
            oom.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface OnBannerClickListener {
        public void onClick();
    }
}

