/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.ResourceUtils;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.network.response.CPAdResponse;
import com.tradplus.ads.network.util.ImageLoader;
import com.tradplus.ads.network.util.ResourceEntry;
import com.tradplus.crosspro.ui.BannerView;

public class EndCardBannerView
extends LinearLayout {
    private Context context;
    private ImageView img_icon;
    private TextView tv_title;
    private TextView tv_desc;
    private TextView tv_choice;
    private Button btn_click;
    private BannerView.OnBannerClickListener onBannerClickListener;

    public EndCardBannerView(Context context, BannerView.OnBannerClickListener onBannerClickListener) {
        super(context);
        this.onBannerClickListener = onBannerClickListener;
        this.init(context);
    }

    public EndCardBannerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public void init(Context context) {
        this.context = context;
        boolean isScreenLandscape = DeviceUtils.isScreenLandscapeOrientation((Context)context);
        EndCardBannerView.inflate((Context)context, (int)ResourceUtils.getLayoutIdByName((Context)context, (String)(isScreenLandscape ? "cp_layout_endcard_banner_land" : "cp_layout_endcard_banner")), (ViewGroup)this);
        this.img_icon = (ImageView)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"cp_img_icon"));
        this.tv_title = (TextView)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"cp_tv_title"));
        this.tv_desc = (TextView)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"cp_tv_desc"));
        this.btn_click = (Button)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"cp_btn_click"));
        this.tv_choice = (TextView)this.findViewById(ResourceUtils.getViewIdByName((Context)context, (String)"cp_tv_choice"));
    }

    public boolean canShow() {
        return !TextUtils.isEmpty((CharSequence)this.tv_title.getText().toString());
    }

    public void initView(ViewGroup container, CPAdResponse cpAdResponse) {
        this.tv_title.setText((CharSequence)cpAdResponse.getTitle());
        this.tv_desc.setText((CharSequence)cpAdResponse.getDescription());
        this.btn_click.setText((CharSequence)cpAdResponse.getButton());
        this.btn_click.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EndCardBannerView.this.onBannerClickListener != null) {
                    EndCardBannerView.this.onBannerClickListener.onClick();
                }
            }
        });
        if (TradPlus.invoker().getChinaHandler() != null) {
            this.tv_choice.setText((CharSequence)"\u5e7f\u544a");
        } else {
            this.tv_choice.setText((CharSequence)"AD");
        }
        this.loadBitmap(cpAdResponse);
        this.attachTo(container);
    }

    private void attachTo(ViewGroup container) {
        int width = -1;
        RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(width, -2);
        rl.addRule(12);
        rl.addRule(11);
        container.addView((View)this, (ViewGroup.LayoutParams)rl);
        this.setVisibility(8);
    }

    private void loadBitmap(CPAdResponse cpAdResponse) {
        try {
            ViewGroup.LayoutParams lp = this.img_icon.getLayoutParams();
            ImageLoader.getInstance((Context)this.getContext()).load(new ResourceEntry(1, cpAdResponse.getIcon()), lp.width, lp.height, new ImageLoader.ImageLoaderListener(){

                public void onSuccess(String url, Bitmap bitmap) {
                    EndCardBannerView.this.img_icon.setImageBitmap(bitmap);
                }

                public void onFail(String url, String errorMsg) {
                }
            });
        }
        catch (OutOfMemoryError oom) {
            oom.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface OnBannerClickListener {
        public void onClick();
    }
}

