/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.manager;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.network.BaseHttpRequest;
import com.tradplus.ads.base.network.TPRequestManager;
import com.tradplus.ads.base.network.response.CPAdResponse;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.pushcenter.event.EventSendMessageUtil;
import java.util.HashMap;
import java.util.Map;

public class CPAdConfigController {
    private CPAdResponse cpAdResponse;
    private static Map<String, CPAdResponse> cpAdResponseMap = new HashMap<String, CPAdResponse>();
    private OnConfigListener onConfigListener;

    public void loadConfig(Context context, String pid, String adSourceId, String type, int orientation) {
        this.loadConfig(context, pid, adSourceId, type, orientation, 0);
    }

    public void loadConfig(final Context context, final String pid, final String adSourceId, final String type, final int orientation, final int direction) {
        TPTaskManager.getInstance().runNormalTask(new Runnable(){

            @Override
            public void run() {
                CPAdConfigController.this.loadCPAdConfig(context, pid, adSourceId, type, orientation, direction);
            }
        });
    }

    private void loadCPAdConfig(final Context context, final String pid, final String adSourceId, String type, int orientation, final int direction) {
        TPRequestManager.getInstance().requestCrossConfig(context, pid, type, orientation, (BaseHttpRequest.OnHttpLoaderListener)new BaseHttpRequest.OnHttpLoaderListener<CPAdResponse>(){

            public void loadSuccess(CPAdResponse response) {
                if (response != null) {
                    cpAdResponseMap.put(pid, response);
                    if (response.getError_code() == 0) {
                        if (CPAdConfigController.this.onConfigListener != null) {
                            String endcardUrl = CPAdConfigController.this.getEndCardWithDeviceType(response, direction);
                            if (!TextUtils.isEmpty((CharSequence)endcardUrl) || direction == -1) {
                                String ip = response.getIp();
                                String iso = response.getIso();
                                EventSendMessageUtil.getInstance().sendOpenAPIStart(context, ip, adSourceId, iso);
                                Log.i((String)"CrossPro", (String)("onSuccess: adSourceId :" + adSourceId));
                                CPAdConfigController.this.onConfigListener.onSuccess(pid);
                            } else if (CPAdConfigController.this.onConfigListener != null) {
                                CPAdConfigController.this.onConfigListener.onError(10, "data is null");
                            }
                        }
                    } else if (CPAdConfigController.this.onConfigListener != null) {
                        CPAdConfigController.this.onConfigListener.onError(10, "error code is not 0");
                    }
                } else if (CPAdConfigController.this.onConfigListener != null) {
                    CPAdConfigController.this.onConfigListener.onError(10, "response is null");
                }
            }

            public void loadError(int code, String msg) {
                if (CPAdConfigController.this.onConfigListener != null) {
                    CPAdConfigController.this.onConfigListener.onError(code, msg);
                }
            }

            public void loadCanceled() {
            }
        });
    }

    private String getEndCardWithDeviceType(CPAdResponse cpAdResponse, int direction) {
        LogUtil.ownShow((String)("getEnd_cardcpAdResponse = " + JSON.toJSONString((Object)cpAdResponse)));
        TPDataManager tpDataManager = TPDataManager.getInstance();
        String device_type = tpDataManager.getDeviceType();
        if (direction == 0) {
            String landUrl;
            if (TextUtils.equals((CharSequence)device_type, (CharSequence)"1")) {
                String landUrl2;
                if (direction == 2) {
                    landUrl2 = this.getEndCardByIndex(cpAdResponse, 1);
                    if (TextUtils.isEmpty((CharSequence)landUrl2)) {
                        landUrl2 = this.getEndCardByIndex(cpAdResponse, 0);
                    }
                } else {
                    landUrl2 = this.getEndCardByIndex(cpAdResponse, 0);
                    if (TextUtils.isEmpty((CharSequence)landUrl2)) {
                        landUrl2 = this.getEndCardByIndex(cpAdResponse, 1);
                    }
                }
                return landUrl2;
            }
            if (direction == 2) {
                landUrl = this.getEndCardByIndex(cpAdResponse, 3);
                if (TextUtils.isEmpty((CharSequence)landUrl)) {
                    landUrl = this.getEndCardByIndex(cpAdResponse, 2);
                }
            } else {
                landUrl = this.getEndCardByIndex(cpAdResponse, 2);
                if (TextUtils.isEmpty((CharSequence)landUrl)) {
                    landUrl = this.getEndCardByIndex(cpAdResponse, 3);
                }
            }
            return landUrl;
        }
        if (TextUtils.equals((CharSequence)device_type, (CharSequence)"1")) {
            if (direction == 2) {
                return this.getEndCardByIndex(cpAdResponse, 1);
            }
            return this.getEndCardByIndex(cpAdResponse, 0);
        }
        if (direction == 2) {
            return this.getEndCardByIndex(cpAdResponse, 3);
        }
        return this.getEndCardByIndex(cpAdResponse, 2);
    }

    private String getEndCardByIndex(CPAdResponse cpAdResponse, int index) {
        for (int i = 0; i < cpAdResponse.getEnd_card().size(); ++i) {
            if (!((CPAdResponse.EndCardBean)cpAdResponse.getEnd_card().get(i)).getType().equals(index + 1 + "")) continue;
            return ((CPAdResponse.EndCardBean)cpAdResponse.getEnd_card().get(i)).getUrl();
        }
        return "";
    }

    public void setOnConfigListener(OnConfigListener onConfigListener) {
        this.onConfigListener = onConfigListener;
    }

    public static CPAdResponse getCpAdResponse(String pid) {
        return cpAdResponseMap.get(pid);
    }

    public static interface OnConfigListener {
        public void onSuccess(String var1);

        public void onError(int var1, String var2);
    }
}

