/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.ui;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.tradplus.ads.base.CommonUtil;
import com.tradplus.ads.base.network.response.CPAdResponse;
import com.tradplus.ads.common.util.Audio;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.crosspro.manager.CPResourceManager;
import com.tradplus.crosspro.manager.resource.CPVideoUtil;
import com.tradplus.crosspro.network.base.CPError;
import com.tradplus.crosspro.network.base.CPErrorCode;
import com.tradplus.crosspro.ui.CountDownView;
import com.tradplus.crosspro.ui.SkipView;
import com.tradplus.crosspro.ui.util.ViewUtil;
import java.io.FileDescriptor;
import java.io.FileInputStream;

public class PlayerView
extends RelativeLayout
implements TextureView.SurfaceTextureListener {
    public static final String TAG = PlayerView.class.getSimpleName();
    private MediaPlayer mMediaPlayer;
    private SurfaceTexture mSurfaceTexture;
    private TextureView mTextureView;
    private Surface mSurface;
    private FileInputStream mFileInputStream;
    private FileDescriptor mSourceFD;
    private String mSourcePath;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mCurrentPosition = -1;
    private int mDuration;
    private int mVideoProgress25;
    private int mVideoProgress50;
    private int mVideoProgress75;
    private boolean mVideoPlay25;
    private boolean mVideoPlay50;
    private boolean mVideoPlay75;
    private boolean mFlag = false;
    private boolean mIsVideoStart = false;
    private boolean mIsVideoPlayCompletion = false;
    private boolean mIsMediaPlayerPrepared = false;
    private OnPlayerListener mListener;
    private Handler mMainHandler;
    private int mViewSizeDp = 29;
    private int mViewMarginDp = 60;
    private int mLeftMarginDp = 19;
    private int mTopMarginDp = 30;
    private int mViewSize;
    private int mViewMargin;
    private int mLeftMargin;
    private int mTopMargin;
    private int mMuteResId;
    private int mNoMuteResId;
    private int mCloseResId;
    private CountDownView mCountDownView;
    private ImageView mMuteBtn;
    private ImageView mCloseBtn;
    private final int mCountDownViewIndex = 1;
    private final int mMuteButtonIndex = 2;
    private final int mCloseButtonIndex = 3;
    private final int mAdChoiceIconIndex = 4;
    private final int mSkipIndex = 5;
    private CPAdResponse cpAdResponse;
    private boolean mIsMute;
    private long mShowCloseTime;
    private Thread mProgressThread;
    private ImageView mAdChoiceIcon;
    private int mAdChoiceResId;
    private boolean mIsCN;
    private int mAdChoiceCNResId;
    private SkipView skipView;
    private int skipMaxTime;
    private boolean canSkip;

    public PlayerView(ViewGroup container, OnPlayerListener listener, boolean isCN, boolean isInterstitial) {
        super(container.getContext());
        this.mListener = listener;
        this.skipMaxTime = isInterstitial ? 5 : 30;
        this.mIsCN = isCN;
        this.setId(CommonUtil.getResId((Context)this.getContext(), (String)"cp_player_view_id", (String)"id"));
        this.setSaveEnabled(true);
        this.attachTo(container);
        this.mMainHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                int time;
                PlayerView.this.mCurrentPosition = msg.what;
                LogUtil.ownShow((String)("MediaPlayer mCurrentPosition()..." + PlayerView.this.mCurrentPosition));
                if (PlayerView.this.mCurrentPosition <= 0) {
                    return;
                }
                if (PlayerView.this.mCloseBtn == null && PlayerView.this.mShowCloseTime >= 0L && (long)PlayerView.this.mCurrentPosition >= PlayerView.this.mShowCloseTime) {
                    PlayerView.this.showCloseButton();
                }
                if (!PlayerView.this.mIsVideoStart && !PlayerView.this.mIsVideoPlayCompletion) {
                    PlayerView.this.mIsVideoStart = true;
                    if (PlayerView.this.mListener != null) {
                        PlayerView.this.mListener.onVideoPlayStart();
                    }
                }
                if (PlayerView.this.canSkip && (time = PlayerView.this.mCurrentPosition / 1000) > PlayerView.this.skipMaxTime) {
                    PlayerView.this.skipView.showView();
                }
                if (PlayerView.this.mListener != null) {
                    PlayerView.this.mListener.onVideoUpdateProgress(PlayerView.this.mCurrentPosition);
                }
                if (!PlayerView.this.mVideoPlay25 && PlayerView.this.mCurrentPosition >= PlayerView.this.mVideoProgress25) {
                    PlayerView.this.mVideoPlay25 = true;
                    if (PlayerView.this.mListener != null) {
                        PlayerView.this.mListener.onVideoPlayProgress(25);
                    }
                } else if (!PlayerView.this.mVideoPlay50 && PlayerView.this.mCurrentPosition >= PlayerView.this.mVideoProgress50) {
                    PlayerView.this.mVideoPlay50 = true;
                    if (PlayerView.this.mListener != null) {
                        PlayerView.this.mListener.onVideoPlayProgress(50);
                    }
                } else if (!PlayerView.this.mVideoPlay75 && PlayerView.this.mCurrentPosition >= PlayerView.this.mVideoProgress75) {
                    PlayerView.this.mVideoPlay75 = true;
                    if (PlayerView.this.mListener != null) {
                        PlayerView.this.mListener.onVideoPlayProgress(75);
                    }
                }
                PlayerView.this.showView();
                if (PlayerView.this.mCountDownView != null && PlayerView.this.mCountDownView.isShown()) {
                    PlayerView.this.mCountDownView.refresh(PlayerView.this.mCurrentPosition);
                }
            }
        };
    }

    private void attachTo(ViewGroup container) {
        RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(-1, -1);
        container.addView((View)this, 0, (ViewGroup.LayoutParams)rl);
    }

    protected Parcelable onSaveInstanceState() {
        LogUtil.ownShow((String)"onSaveInstanceState...");
        Parcelable parcelable = super.onSaveInstanceState();
        SavedState ss = new SavedState(parcelable);
        ss.savePosition = this.mCurrentPosition;
        ss.saveVideoPlay25 = this.mVideoPlay25;
        ss.saveVideoPlay50 = this.mVideoPlay50;
        ss.saveVideoPlay75 = this.mVideoPlay75;
        ss.saveIsVideoStart = this.mIsVideoStart;
        ss.saveIsVideoPlayCompletion = this.mIsVideoPlayCompletion;
        ss.saveIsMute = this.mIsMute;
        LogUtil.ownShow((String)("onSaveInstanceState..." + ss.print()));
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        LogUtil.ownShow((String)"onRestoreInstanceState...");
        if (state instanceof SavedState) {
            SavedState ss = (SavedState)state;
            LogUtil.ownShow((String)("onRestoreInstanceState..." + ss.print()));
            super.onRestoreInstanceState(ss.getSuperState());
            this.mCurrentPosition = ss.savePosition;
            this.mVideoPlay25 = ss.saveVideoPlay25;
            this.mVideoPlay50 = ss.saveVideoPlay50;
            this.mVideoPlay75 = ss.saveVideoPlay75;
            this.mIsVideoStart = ss.saveIsVideoStart;
            this.mIsVideoPlayCompletion = ss.saveIsVideoPlayCompletion;
            this.mIsMute = ss.saveIsMute;
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setVolume(this.mIsMute ? 0.0f : 1.0f, this.mIsMute ? 0.0f : 1.0f);
            }
        }
    }

    public void setSetting(CPAdResponse cpAdResponse) {
        if (cpAdResponse == null) {
            return;
        }
        boolean bl = this.mIsMute = cpAdResponse.getVideo_mute() == 0;
        if (!this.mIsMute) {
            this.mIsMute = Audio.isAudioSilent((Context)this.getContext());
        }
        this.mShowCloseTime = cpAdResponse.getShow_close_time() * 1000;
        LogUtil.ownShow((String)("isMute - " + this.mIsMute));
        LogUtil.ownShow((String)("showCloseTime - " + this.mShowCloseTime));
    }

    private void init() {
        LogUtil.ownShow((String)"init...");
        boolean error = this.checkValid();
        if (error) {
            if (this.mListener != null) {
                this.mListener.onVideoShowFailed(CPErrorCode.get("401", "Video file error!"));
            }
            return;
        }
        this.initParams();
        this.computeVideoSize();
        this.initTextureView();
        this.initMediaPlayer();
        this.initCountDownView();
        this.initMutebutton();
        this.initAdChoiceIcon();
        this.initSkipView();
    }

    private void initParams() {
        this.mViewSize = (int)TypedValue.applyDimension((int)1, (float)this.mViewSizeDp, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        this.mViewMargin = (int)TypedValue.applyDimension((int)1, (float)this.mViewMarginDp, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        this.mLeftMargin = (int)TypedValue.applyDimension((int)1, (float)this.mLeftMarginDp, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        this.mTopMargin = (int)TypedValue.applyDimension((int)1, (float)this.mTopMarginDp, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        this.mMuteResId = CommonUtil.getResId((Context)this.getContext(), (String)"cp_video_mute", (String)"drawable");
        this.mAdChoiceResId = CommonUtil.getResId((Context)this.getContext(), (String)"cp_ad", (String)"drawable");
        this.mAdChoiceCNResId = CommonUtil.getResId((Context)this.getContext(), (String)"cp_ad_cn", (String)"drawable");
        this.mNoMuteResId = CommonUtil.getResId((Context)this.getContext(), (String)"cp_video_no_mute", (String)"drawable");
        this.mCloseResId = CommonUtil.getResId((Context)this.getContext(), (String)"cp_video_close", (String)"drawable");
    }

    private void computeVideoSize() {
        if (this.mVideoWidth != 0 && this.mVideoHeight != 0) {
            return;
        }
        try {
            DisplayMetrics dm = this.getResources().getDisplayMetrics();
            CPVideoUtil.Size videoSize = CPVideoUtil.getAdaptiveVideoSize(this.mSourceFD, dm.widthPixels, dm.heightPixels);
            if (videoSize != null) {
                this.mVideoWidth = videoSize.width;
                this.mVideoHeight = videoSize.height;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initCountDownView() {
        if (this.getChildAt(1) != null) {
            this.removeViewAt(1);
        }
        this.mCountDownView = new CountDownView(this.getContext());
        this.mCountDownView.setId(CommonUtil.getResId((Context)this.getContext(), (String)"cp_count_down_view_id", (String)"id"));
        RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(this.mViewSize, this.mViewSize);
        rl.leftMargin = this.mLeftMargin;
        rl.topMargin = this.mTopMargin;
        this.mCountDownView.setVisibility(4);
        this.addView(this.mCountDownView, 1, (ViewGroup.LayoutParams)rl);
    }

    private void initSkipView() {
        if (this.getChildAt(5) != null) {
            this.removeViewAt(5);
        }
        this.skipView = new SkipView(this.getContext());
        this.skipView.setId(CommonUtil.getResId((Context)this.getContext(), (String)"cp_skip_view_id", (String)"id"));
        RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(-2, -2);
        rl.addRule(11);
        rl.rightMargin = this.mLeftMargin;
        rl.topMargin = this.mTopMargin;
        this.skipView.init(this.getContext(), this.mListener);
        this.addView((View)this.skipView, (ViewGroup.LayoutParams)rl);
    }

    private void initAdChoiceIcon() {
        if (this.getChildAt(4) != null) {
            this.removeViewAt(4);
        }
        this.mAdChoiceIcon = new ImageView(this.getContext());
        this.mAdChoiceIcon.setId(CommonUtil.getResId((Context)this.getContext(), (String)"cp_ad_choice_id", (String)"id"));
        RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(30, 30);
        rl.addRule(12);
        this.mAdChoiceIcon.setVisibility(0);
        this.addView((View)this.mAdChoiceIcon, (ViewGroup.LayoutParams)rl);
        if (this.mIsCN) {
            this.mAdChoiceIcon.setBackgroundResource(this.mAdChoiceCNResId);
        } else {
            this.mAdChoiceIcon.setBackgroundResource(this.mAdChoiceResId);
        }
    }

    private void initMutebutton() {
        if (this.getChildAt(2) != null) {
            this.removeViewAt(2);
        }
        this.mMuteBtn = new ImageView(this.getContext());
        this.mMuteBtn.setId(CommonUtil.getResId((Context)this.getContext(), (String)"cp_btn_mute_id", (String)"id"));
        RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(this.mViewSize, this.mViewSize);
        rl.topMargin = this.mTopMargin;
        rl.leftMargin = this.mViewMargin;
        this.mMuteBtn.setVisibility(4);
        this.addView((View)this.mMuteBtn, 2, (ViewGroup.LayoutParams)rl);
        if (this.mIsMute) {
            this.mMuteBtn.setBackgroundResource(this.mMuteResId);
        } else {
            this.mMuteBtn.setBackgroundResource(this.mNoMuteResId);
        }
        this.mMuteBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PlayerView.this.mIsVideoPlayCompletion) {
                    return;
                }
                PlayerView.this.mIsMute = !PlayerView.this.mIsMute;
                if (PlayerView.this.mIsMute) {
                    PlayerView.this.mMuteBtn.setBackgroundResource(PlayerView.this.mMuteResId);
                    if (PlayerView.this.mMediaPlayer != null) {
                        PlayerView.this.mMediaPlayer.setVolume(0.0f, 0.0f);
                    }
                } else {
                    PlayerView.this.mMuteBtn.setBackgroundResource(PlayerView.this.mNoMuteResId);
                    if (PlayerView.this.mMediaPlayer != null) {
                        PlayerView.this.mMediaPlayer.setVolume(1.0f, 1.0f);
                    }
                }
            }
        });
    }

    private void initCloseButton() {
        if (this.getChildAt(3) != null) {
            this.removeViewAt(3);
        }
        this.mCloseBtn = new ImageView(this.getContext());
        this.mCloseBtn.setId(CommonUtil.getResId((Context)this.getContext(), (String)"cp_btn_close_id", (String)"id"));
        RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(this.mViewSize, this.mViewSize);
        rl.addRule(11);
        rl.rightMargin = this.mViewMargin;
        rl.addRule(6, this.mCountDownView.getId());
        rl.addRule(8, this.mCountDownView.getId());
        this.addView((View)this.mCloseBtn, 3, (ViewGroup.LayoutParams)rl);
        this.mCloseBtn.setImageResource(this.mCloseResId);
        ViewUtil.expandTouchArea((View)this.mCloseBtn, this.mViewSize / 2);
        this.mCloseBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PlayerView.this.mListener != null) {
                    PlayerView.this.mListener.onVideoCloseClick();
                }
            }
        });
    }

    private void showView() {
        this.showCountDownView();
        this.showMuteButton();
    }

    private void showCountDownView() {
        if (this.mCountDownView != null && !this.mCountDownView.isShown()) {
            this.mCountDownView.setVisibility(0);
        }
    }

    private void showMuteButton() {
        if (this.mMuteBtn != null && !this.mMuteBtn.isShown()) {
            this.mMuteBtn.setVisibility(0);
        }
    }

    private void startProgressThread() {
        if (this.mProgressThread != null) {
            return;
        }
        this.mFlag = true;
        this.mProgressThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (PlayerView.this.mFlag) {
                    if (PlayerView.this.mIsVideoPlayCompletion || PlayerView.this.mMediaPlayer == null || !PlayerView.this.mMediaPlayer.isPlaying() || PlayerView.this.mMainHandler == null) continue;
                    PlayerView.this.mMainHandler.sendEmptyMessage(PlayerView.this.mMediaPlayer.getCurrentPosition());
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.mProgressThread.start();
    }

    private void stopProgressThread() {
        this.mFlag = false;
        this.mProgressThread = null;
    }

    public void load(String url) {
        this.mSourcePath = url;
        this.init();
    }

    private boolean checkValid() {
        this.mFileInputStream = CPResourceManager.getInstance().getInputStream(this.mSourcePath);
        boolean error = false;
        try {
            if (this.mFileInputStream == null) {
                error = true;
            } else {
                this.mSourceFD = this.mFileInputStream.getFD();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            error = true;
        }
        if (error && this.mFileInputStream != null) {
            try {
                this.mFileInputStream.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return error;
    }

    private void initMediaPlayer() {
        if (this.mMediaPlayer == null) {
            this.mMediaPlayer = new MediaPlayer();
            this.mMediaPlayer.setVolume(this.mIsMute ? 0.0f : 1.0f, this.mIsMute ? 0.0f : 1.0f);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    LogUtil.ownShow((String)"MediaPlayer onPrepared()...");
                    PlayerView.this.mIsMediaPlayerPrepared = true;
                    PlayerView.this.mDuration = PlayerView.this.mMediaPlayer.getDuration();
                    LogUtil.ownShow((String)("MediaPlayer mDuration()..." + PlayerView.this.mDuration));
                    PlayerView.this.canSkip = PlayerView.this.mDuration / 1000 > PlayerView.this.skipMaxTime;
                    if (PlayerView.this.mCountDownView != null) {
                        PlayerView.this.mCountDownView.setDuration(PlayerView.this.mDuration);
                    }
                    PlayerView.this.mVideoProgress25 = Math.round(0.25f * (float)PlayerView.this.mDuration);
                    PlayerView.this.mVideoProgress50 = Math.round(0.5f * (float)PlayerView.this.mDuration);
                    PlayerView.this.mVideoProgress75 = Math.round(0.75f * (float)PlayerView.this.mDuration);
                    if (PlayerView.this.mCurrentPosition > 0) {
                        PlayerView.this.mMediaPlayer.seekTo(PlayerView.this.mCurrentPosition);
                    } else {
                        PlayerView.this.start();
                    }
                }
            });
            this.mMediaPlayer.setOnSeekCompleteListener(new MediaPlayer.OnSeekCompleteListener(){

                public void onSeekComplete(MediaPlayer mp) {
                    PlayerView.this.start();
                }
            });
            if (!this.mIsVideoPlayCompletion) {
                this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mp) {
                        PlayerView.this.stopProgressThread();
                        PlayerView.this.mIsVideoPlayCompletion = true;
                        PlayerView.this.mCurrentPosition = PlayerView.this.mDuration;
                        if (PlayerView.this.mListener != null) {
                            PlayerView.this.mListener.onVideoPlayCompletion();
                        }
                    }
                });
            }
            this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                public boolean onError(MediaPlayer mp, int what, int extra) {
                    if (PlayerView.this.mListener != null) {
                        PlayerView.this.mListener.onVideoShowFailed(CPErrorCode.get("402", "Video player error!"));
                    }
                    return true;
                }
            });
        }
    }

    private void initTextureView() {
        if (this.mTextureView == null) {
            this.mTextureView = new TextureView(this.getContext());
            this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
            this.mTextureView.setKeepScreenOn(true);
            RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(-1, -1);
            if (this.mVideoWidth != 0 && this.mVideoHeight != 0) {
                rl.width = this.mVideoWidth;
                rl.height = this.mVideoHeight;
            }
            rl.addRule(13);
            this.removeAllViews();
            this.addView((View)this.mTextureView, (ViewGroup.LayoutParams)rl);
            this.mTextureView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (PlayerView.this.mListener != null) {
                        PlayerView.this.mListener.onVideoClick();
                    }
                }
            });
        }
    }

    private void openPlayer() {
        block7: {
            this.init();
            try {
                this.mMediaPlayer.reset();
                if (!this.mSourceFD.valid()) {
                    throw new IllegalStateException("cp video resource is valid");
                }
                LogUtil.ownShow((String)("video resource valid - " + this.mSourceFD.valid()));
                this.mMediaPlayer.setDataSource(this.mSourceFD);
                try {
                    if (this.mFileInputStream != null) {
                        this.mFileInputStream.close();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                if (this.mSurface == null) {
                    this.mSurface = new Surface(this.mSurfaceTexture);
                }
                this.mMediaPlayer.setSurface(this.mSurface);
                this.mMediaPlayer.prepareAsync();
            }
            catch (Throwable e) {
                e.printStackTrace();
                if (this.mListener == null) break block7;
                this.mListener.onVideoShowFailed(CPErrorCode.get("402", e.getMessage()));
            }
        }
    }

    public void showCloseButton() {
        this.initCloseButton();
    }

    public void start() {
        LogUtil.ownShow((String)"start()");
        if (this.mMediaPlayer != null && this.mIsMediaPlayerPrepared) {
            this.mMediaPlayer.start();
        }
        this.startProgressThread();
    }

    public void pause() {
        LogUtil.ownShow((String)"pause()");
        this.stopProgressThread();
        if (this.isPlaying()) {
            this.mMediaPlayer.pause();
        }
    }

    public void stop() {
        LogUtil.ownShow((String)"stop()");
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
        }
    }

    public void release() {
        if (!this.mIsMediaPlayerPrepared) {
            return;
        }
        LogUtil.ownShow((String)"release...");
        this.stopProgressThread();
        this.mSurfaceTexture = null;
        this.mSurface = null;
        if (this.mMediaPlayer != null) {
            if (this.mMediaPlayer.isPlaying()) {
                this.mMediaPlayer.stop();
            }
            this.mMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        if (this.mMainHandler != null) {
            this.mMainHandler.removeCallbacksAndMessages(null);
        }
        this.mIsMediaPlayerPrepared = false;
    }

    public boolean isPlaying() {
        if (this.mMediaPlayer != null && this.mIsMediaPlayerPrepared) {
            return this.mMediaPlayer.isPlaying();
        }
        return false;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        LogUtil.ownShow((String)"onSurfaceTextureAvailable()...");
        this.mSurfaceTexture = surface;
        this.openPlayer();
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        LogUtil.ownShow((String)"onSurfaceTextureDestroyed()...");
        this.release();
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        LogUtil.ownShow((String)"onDetachedFromWindow()...");
        this.release();
    }

    public static interface OnPlayerListener {
        public void onVideoPlayStart();

        public void onVideoUpdateProgress(int var1);

        public void onVideoPlayEnd();

        public void onVideoPlayCompletion();

        public void onVideoShowFailed(CPError var1);

        public void onVideoPlayProgress(int var1);

        public void onVideoCloseClick();

        public void onVideoClick();

        public void onVideoSkip();
    }

    static class SavedState
    extends View.BaseSavedState {
        int savePosition;
        boolean saveVideoPlay25;
        boolean saveVideoPlay50;
        boolean saveVideoPlay75;
        boolean saveIsVideoStart;
        boolean saveIsVideoPlayCompletion;
        boolean saveIsMute;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.savePosition = source.readInt();
            boolean[] booleans = new boolean[6];
            source.readBooleanArray(booleans);
            this.saveVideoPlay25 = booleans[0];
            this.saveVideoPlay50 = booleans[1];
            this.saveVideoPlay75 = booleans[2];
            this.saveIsVideoStart = booleans[3];
            this.saveIsVideoPlayCompletion = booleans[4];
            this.saveIsMute = booleans[5];
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.savePosition);
            boolean[] booleans = new boolean[]{this.saveVideoPlay25, this.saveVideoPlay50, this.saveVideoPlay75, this.saveIsVideoStart, this.saveIsVideoPlayCompletion, this.saveIsMute};
            out.writeBooleanArray(booleans);
        }

        public String print() {
            return "SavedState(\nsavePosition - " + this.savePosition + "\nsaveVideoPlay25 - " + this.saveVideoPlay25 + "\nsaveVideoPlay50 - " + this.saveVideoPlay50 + "\nsaveVideoPlay75 - " + this.saveVideoPlay75 + "\nsaveIsVideoStart - " + this.saveIsVideoStart + "\nsaveIsVideoPlayCompletion - " + this.saveIsVideoPlayCompletion + "\nsaveIsMute - " + this.saveIsMute + "\n)";
        }
    }
}

