/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.crosspro.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.tradplus.ads.base.CommonUtil;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.network.response.CPAdResponse;
import com.tradplus.ads.base.network.util.ImageLoader;
import com.tradplus.ads.base.network.util.ResourceEntry;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.BitmapUtil;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.crosspro.ui.RoundImageView;
import com.tradplus.crosspro.ui.util.ViewUtil;

public class EndCardView
extends RelativeLayout {
    private OnEndCardListener mListener;
    private int mWidth;
    private int mHeight;
    private int mBlurBgIndex = 0;
    private int mEndCardIndex = 1;
    private int mCloseButtonIndex = 2;
    private int mOrientation;
    private ImageView mEndCardIv;
    private RoundImageView bgIv;
    private int direction;

    public EndCardView(ViewGroup container, int width, int height, CPAdResponse cpAdResponse, int orientation, OnEndCardListener listener, int direction) {
        super(container.getContext());
        this.mListener = listener;
        this.mOrientation = orientation;
        this.direction = direction;
        this.mWidth = width;
        this.mHeight = height;
        this.init();
        this.attachTo(container);
        this.loadBitmap(cpAdResponse);
    }

    private String getEndCardWithDeviceType(CPAdResponse cpAdResponse, int direction) {
        String landUrl;
        LogUtil.ownShow((String)("getEnd_cardcpAdResponse = " + JSON.toJSONString((Object)cpAdResponse)));
        TPDataManager tpDataManager = TPDataManager.getInstance();
        String device_type = tpDataManager.getDeviceType();
        if (TextUtils.equals((CharSequence)device_type, (CharSequence)"1")) {
            String landUrl2;
            if (this.mOrientation == 2) {
                landUrl2 = this.getEndCardByIndex(cpAdResponse, 1);
                if (TextUtils.isEmpty((CharSequence)landUrl2)) {
                    this.mEndCardIv.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    landUrl2 = this.getEndCardByIndex(cpAdResponse, 0);
                }
            } else {
                landUrl2 = this.getEndCardByIndex(cpAdResponse, 0);
                if (TextUtils.isEmpty((CharSequence)landUrl2)) {
                    this.mEndCardIv.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    landUrl2 = this.getEndCardByIndex(cpAdResponse, 1);
                }
            }
            return landUrl2;
        }
        if (this.mOrientation == 2) {
            landUrl = this.getEndCardByIndex(cpAdResponse, 3);
            if (TextUtils.isEmpty((CharSequence)landUrl)) {
                landUrl = this.getEndCardByIndex(cpAdResponse, 2);
            }
        } else {
            landUrl = this.getEndCardByIndex(cpAdResponse, 2);
            if (TextUtils.isEmpty((CharSequence)landUrl)) {
                landUrl = this.getEndCardByIndex(cpAdResponse, 3);
            }
        }
        return landUrl;
    }

    private String getEndCardByIndex(CPAdResponse cpAdResponse, int index) {
        for (int i = 0; i < cpAdResponse.getEnd_card().size(); ++i) {
            if (!((CPAdResponse.EndCardBean)cpAdResponse.getEnd_card().get(i)).getType().equals(index + 1 + "")) continue;
            return ((CPAdResponse.EndCardBean)cpAdResponse.getEnd_card().get(i)).getUrl();
        }
        return "";
    }

    private void loadBitmap(final CPAdResponse cpAdResponse) {
        try {
            ImageLoader.getInstance((Context)this.getContext()).load(new ResourceEntry(1, this.getEndCardWithDeviceType(cpAdResponse, this.direction)), this.mWidth, this.mHeight, new ImageLoader.ImageLoaderListener(){

                public void onSuccess(String url, Bitmap bitmap) {
                    if (TextUtils.equals((CharSequence)url, (CharSequence)EndCardView.this.getEndCardWithDeviceType(cpAdResponse, EndCardView.this.direction))) {
                        EndCardView.this.mEndCardIv.setImageBitmap(bitmap);
                        Bitmap blurBitmap = BitmapUtil.blurBitmap((Context)EndCardView.this.getContext(), (Bitmap)bitmap);
                        EndCardView.this.bgIv.setImageBitmap(blurBitmap);
                    }
                }

                public void onFail(String url, String errorMsg) {
                    LogUtil.ownShow((String)("getend_card url = " + url + " emsg = " + errorMsg));
                }
            });
        }
        catch (OutOfMemoryError oom) {
            oom.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() {
        this.bgIv = new RoundImageView(this.getContext());
        this.bgIv.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.mEndCardIv = new RoundImageView(this.getContext());
        RelativeLayout.LayoutParams rl_bg = new RelativeLayout.LayoutParams(-1, -1);
        RelativeLayout.LayoutParams rl_endcard = new RelativeLayout.LayoutParams(this.mWidth, this.mHeight);
        rl_endcard.addRule(13);
        this.addView((View)this.bgIv, this.mBlurBgIndex, (ViewGroup.LayoutParams)rl_bg);
        this.addView((View)this.mEndCardIv, this.mEndCardIndex, (ViewGroup.LayoutParams)rl_endcard);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EndCardView.this.mListener != null) {
                    EndCardView.this.mListener.onClickEndCard();
                }
            }
        });
        this.initCloseButton();
    }

    private void initCloseButton() {
        if (this.getChildAt(this.mCloseButtonIndex) != null) {
            this.removeViewAt(this.mCloseButtonIndex);
        }
        ImageView mCloseBtn = new ImageView(this.getContext());
        mCloseBtn.setImageResource(CommonUtil.getResId((Context)this.getContext(), (String)"cp_video_close", (String)"drawable"));
        int size = (int)TypedValue.applyDimension((int)1, (float)29.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        int topMargin = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        int rightMargin = (int)TypedValue.applyDimension((int)1, (float)19.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(size, size);
        rl.addRule(11);
        rl.rightMargin = rightMargin;
        rl.topMargin = topMargin;
        this.addView((View)mCloseBtn, this.mCloseButtonIndex, (ViewGroup.LayoutParams)rl);
        ViewUtil.expandTouchArea((View)mCloseBtn, size / 2);
        mCloseBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EndCardView.this.mListener != null) {
                    EndCardView.this.mListener.onCloseEndCard();
                }
            }
        });
    }

    private void attachTo(ViewGroup container) {
        if (container.getChildCount() == 2) {
            container.removeViewAt(0);
        }
        RelativeLayout.LayoutParams rl = new RelativeLayout.LayoutParams(-1, -1);
        container.addView((View)this, 0, (ViewGroup.LayoutParams)rl);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public static interface OnEndCardListener {
        public void onClickEndCard();

        public void onCloseEndCard();
    }
}

