/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.BidderTokenProvider;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.facebook.FacebookErrorUtil;
import com.tradplus.ads.facebook.FacebookInitManager;
import java.util.Map;

public class FacebookInterstitial
extends TPInterstitialAdapter {
    private InterstitialAd mFacebookInterstitial;
    private String payload;
    private String placementId;
    private static final String TAG = "FacebookInterstitial";
    private String mName;
    private final InterstitialAdListener interstitialAdListener = new InterstitialAdListener(){

        public void onError(Ad ad, AdError adError) {
            Log.i((String)FacebookInterstitial.TAG, (String)("Facebook interstitial ad load failed  ,ErrorCode : " + adError.getErrorCode() + ", ErrorMessage : " + adError.getErrorMessage()));
            if (FacebookInterstitial.this.mLoadAdapterListener != null) {
                FacebookInterstitial.this.mLoadAdapterListener.loadAdapterLoadFailed(FacebookErrorUtil.getTradPlusErrorCode(adError));
            }
        }

        public void onAdLoaded(Ad ad) {
            if (FacebookInterstitial.this.mFacebookInterstitial == null) {
                return;
            }
            FacebookInterstitial.this.setFirstLoadedTime();
            Log.i((String)FacebookInterstitial.TAG, (String)"Facebook interstitial ad loaded successfully.");
            if (FacebookInterstitial.this.mLoadAdapterListener != null) {
                FacebookInterstitial.this.setNetworkObjectAd(FacebookInterstitial.this.mFacebookInterstitial);
                FacebookInterstitial.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
        }

        public void onAdClicked(Ad ad) {
            Log.i((String)FacebookInterstitial.TAG, (String)"Facebook interstitial ad clicked.");
            if (FacebookInterstitial.this.mShowListener != null) {
                FacebookInterstitial.this.mShowListener.onAdClicked();
            }
        }

        public void onLoggingImpression(Ad ad) {
            Log.i((String)FacebookInterstitial.TAG, (String)"Facebook interstitial ad onLoggingImpression.");
            if (FacebookInterstitial.this.mShowListener != null) {
                FacebookInterstitial.this.mShowListener.onAdShown();
            }
        }

        public void onInterstitialDisplayed(Ad ad) {
            Log.i((String)FacebookInterstitial.TAG, (String)"Showing Facebook interstitial ad.");
        }

        public void onInterstitialDismissed(Ad ad) {
            Log.i((String)FacebookInterstitial.TAG, (String)"Facebook interstitial ad dismissed.");
            if (FacebookInterstitial.this.mShowListener != null) {
                FacebookInterstitial.this.mShowListener.onAdClosed();
            }
        }
    };

    public String getNetworkName() {
        return TextUtils.isEmpty((CharSequence)this.mName) ? "Meta Audience Network" : this.mName;
    }

    public String getNetworkVersion() {
        return "6.17.0";
    }

    public void loadCustomAd(final Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        if (this.extrasAreValid(serverExtras)) {
            this.placementId = serverExtras.get("placementId");
            this.payload = serverExtras.get("Bidding-Payload");
            if (serverExtras.containsKey("name")) {
                this.mName = serverExtras.get("name");
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        if (localExtras.size() > 0 && localExtras.containsKey("COPPA")) {
            boolean coppa = (Boolean)localExtras.get("COPPA");
            Log.i((String)"privacylaws", (String)("coppa: " + coppa));
            if (coppa) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Third-party network failed to provide an ad."));
                return;
            }
        }
        FacebookInitManager.getInstance().initSDK(context, localExtras, serverExtras, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                FacebookInterstitial.this.requestAd(context);
            }

            public void onFailed(String code, String msg) {
            }
        });
    }

    private void requestAd(Context context) {
        this.mFacebookInterstitial = new InterstitialAd(context, this.placementId);
        InterstitialAd.InterstitialAdLoadConfigBuilder interstitialAdLoadConfigBuilder = this.mFacebookInterstitial.buildLoadAdConfig().withAdListener(this.interstitialAdListener);
        interstitialAdLoadConfigBuilder.withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload);
        this.mFacebookInterstitial.loadAd(interstitialAdLoadConfigBuilder.build());
    }

    public void showAd() {
        if (this.mFacebookInterstitial != null && this.mFacebookInterstitial.isAdLoaded()) {
            this.mFacebookInterstitial.show();
            String msg = "isAdLoaded";
        } else {
            Log.i((String)TAG, (String)"Tried to show a Facebook interstitial ad before it finished loading. Please try again.");
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
            } else {
                Log.i((String)TAG, (String)"Interstitial listener not instantiated. Please load interstitial again.");
            }
            String msg = "noAdLoaded";
        }
    }

    public void clean() {
        super.clean();
        if (this.mFacebookInterstitial != null) {
            this.mFacebookInterstitial.destroy();
            this.mFacebookInterstitial = null;
        }
    }

    public boolean isReady() {
        if (this.mFacebookInterstitial != null) {
            return !this.isAdsTimeOut() && !this.mFacebookInterstitial.isAdInvalidated();
        }
        return false;
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        String placementId = serverExtras.get("placementId");
        return placementId != null && placementId.length() > 0;
    }

    public String getBiddingToken() {
        try {
            return BidderTokenProvider.getBidderToken((Context)GlobalTradPlus.getInstance().getContext());
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

