/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.BidderTokenProvider;
import com.facebook.ads.RewardData;
import com.facebook.ads.RewardedInterstitialAd;
import com.facebook.ads.RewardedInterstitialAdListener;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.facebook.FacebookErrorUtil;
import com.tradplus.ads.facebook.FacebookInitManager;
import java.util.Map;

public class FacebookInterstitialVideo
extends TPRewardAdapter {
    private RewardedVideoAd mRewardedVideoAd;
    private String mPlacementId;
    private String payload;
    private String userId;
    private String customData;
    private boolean hasGrantedReward = false;
    private boolean alwaysRewardUser;
    private int isRewardedInterstitialAd;
    private RewardedInterstitialAd rewardedInterstitialAd;
    private static final String TAG = "FacebookRewardedVideo";
    private String mName;
    private final RewardedInterstitialAdListener rewardedInterstitialAdListener = new RewardedInterstitialAdListener(){

        public void onError(Ad ad, AdError adError) {
            Log.i((String)FacebookInterstitialVideo.TAG, (String)("onError: errorCode : " + adError.getErrorCode() + " , errorMsg : " + adError.getErrorMessage()));
            if (FacebookInterstitialVideo.this.mLoadAdapterListener != null) {
                FacebookInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(FacebookErrorUtil.getTradPlusErrorCode(adError));
            }
        }

        public void onAdLoaded(Ad ad) {
            if (FacebookInterstitialVideo.this.rewardedInterstitialAd == null) {
                return;
            }
            FacebookInterstitialVideo.this.setFirstLoadedTime();
            Log.i((String)FacebookInterstitialVideo.TAG, (String)"onAdLoaded: ");
            if (FacebookInterstitialVideo.this.mLoadAdapterListener != null) {
                FacebookInterstitialVideo.this.setNetworkObjectAd(FacebookInterstitialVideo.this.rewardedInterstitialAd);
                FacebookInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
        }

        public void onAdClicked(Ad ad) {
            Log.i((String)FacebookInterstitialVideo.TAG, (String)"onAdClicked: ");
            if (FacebookInterstitialVideo.this.mShowListener != null) {
                FacebookInterstitialVideo.this.mShowListener.onAdClicked();
            }
        }

        public void onLoggingImpression(Ad ad) {
            Log.i((String)FacebookInterstitialVideo.TAG, (String)"onLoggingImpression: ");
            if (FacebookInterstitialVideo.this.mShowListener != null) {
                FacebookInterstitialVideo.this.mShowListener.onAdShown();
                FacebookInterstitialVideo.this.mShowListener.onAdVideoStart();
            }
        }

        public void onRewardedInterstitialCompleted() {
            Log.i((String)FacebookInterstitialVideo.TAG, (String)"onRewardedInterstitialCompleted: ");
            FacebookInterstitialVideo.this.hasGrantedReward = true;
            if (FacebookInterstitialVideo.this.mShowListener != null) {
                FacebookInterstitialVideo.this.mShowListener.onAdVideoEnd();
            }
        }

        public void onRewardedInterstitialClosed() {
            Log.i((String)FacebookInterstitialVideo.TAG, (String)"onRewardedInterstitialClosed: ");
            if ((FacebookInterstitialVideo.this.hasGrantedReward || FacebookInterstitialVideo.this.alwaysRewardUser) && FacebookInterstitialVideo.this.mShowListener != null) {
                FacebookInterstitialVideo.this.mShowListener.onReward();
            }
            if (FacebookInterstitialVideo.this.mShowListener != null) {
                FacebookInterstitialVideo.this.mShowListener.onAdClosed();
            }
        }
    };
    private final RewardedVideoAdListener rewardedVideoAdListener = new RewardedVideoAdListener(){

        public void onRewardedVideoCompleted() {
            Log.i((String)FacebookInterstitialVideo.TAG, (String)"onRewardedVideoCompleted: ");
            FacebookInterstitialVideo.this.hasGrantedReward = true;
            if (FacebookInterstitialVideo.this.mShowListener != null) {
                FacebookInterstitialVideo.this.mShowListener.onAdVideoEnd();
            }
        }

        public void onError(Ad ad, AdError adError) {
            Log.i((String)FacebookInterstitialVideo.TAG, (String)("onError: errorCode : " + adError.getErrorCode() + " , errorMsg : " + adError.getErrorMessage()));
            if (FacebookInterstitialVideo.this.mLoadAdapterListener != null) {
                FacebookInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(FacebookErrorUtil.getTradPlusErrorCode(adError));
            }
        }

        public void onAdLoaded(Ad ad) {
            if (FacebookInterstitialVideo.this.mRewardedVideoAd == null) {
                return;
            }
            FacebookInterstitialVideo.this.setFirstLoadedTime();
            Log.i((String)FacebookInterstitialVideo.TAG, (String)"onAdLoaded: ");
            if (FacebookInterstitialVideo.this.mLoadAdapterListener != null) {
                FacebookInterstitialVideo.this.setNetworkObjectAd(FacebookInterstitialVideo.this.mRewardedVideoAd);
                FacebookInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
        }

        public void onAdClicked(Ad ad) {
            Log.i((String)FacebookInterstitialVideo.TAG, (String)"onAdClicked: ");
            if (FacebookInterstitialVideo.this.mShowListener != null) {
                FacebookInterstitialVideo.this.mShowListener.onAdClicked();
            }
        }

        public void onLoggingImpression(Ad ad) {
            Log.i((String)FacebookInterstitialVideo.TAG, (String)"onLoggingImpression: ");
            if (FacebookInterstitialVideo.this.mShowListener != null) {
                FacebookInterstitialVideo.this.mShowListener.onAdShown();
                FacebookInterstitialVideo.this.mShowListener.onAdVideoStart();
            }
        }

        public void onRewardedVideoClosed() {
            Log.i((String)FacebookInterstitialVideo.TAG, (String)"onRewardedVideoClosed: ");
            if ((FacebookInterstitialVideo.this.hasGrantedReward || FacebookInterstitialVideo.this.alwaysRewardUser) && FacebookInterstitialVideo.this.mShowListener != null) {
                FacebookInterstitialVideo.this.mShowListener.onReward();
            }
            if (FacebookInterstitialVideo.this.mShowListener != null) {
                FacebookInterstitialVideo.this.mShowListener.onAdClosed();
            }
        }
    };

    public void loadCustomAd(final Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        if (this.extrasAreValid(serverExtras)) {
            this.mPlacementId = serverExtras.get("placementId");
            this.payload = serverExtras.get("Bidding-Payload");
            if (serverExtras.containsKey("adsource_type")) {
                this.isRewardedInterstitialAd = Integer.parseInt(serverExtras.get("adsource_type"));
            }
            if (!TextUtils.isEmpty((CharSequence)serverExtras.get("always_reward"))) {
                int rewardUser = Integer.parseInt(serverExtras.get("always_reward"));
                boolean bl = this.alwaysRewardUser = rewardUser == 1;
            }
            if (serverExtras.containsKey("name")) {
                this.mName = serverExtras.get("name");
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        if (localExtras != null && localExtras.size() > 0) {
            this.userId = (String)localExtras.get("user_id");
            this.customData = (String)localExtras.get("custom_data");
            if (TextUtils.isEmpty((CharSequence)this.userId)) {
                this.userId = "";
            }
            if (TextUtils.isEmpty((CharSequence)this.customData)) {
                this.customData = "";
            }
        }
        if (localExtras.size() > 0 && localExtras.containsKey("COPPA")) {
            boolean coppa = (Boolean)localExtras.get("COPPA");
            Log.i((String)"privacylaws", (String)("coppa: " + coppa));
            if (coppa) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Third-party network failed to provide an ad."));
                return;
            }
        }
        FacebookInitManager.getInstance().initSDK(context, localExtras, serverExtras, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                FacebookInterstitialVideo.this.requestAd(context);
            }

            public void onFailed(String code, String msg) {
            }
        });
    }

    private void requestAd(Context context) {
        if (this.isRewardedInterstitialAd == 2) {
            Log.i((String)TAG, (String)"load \u5956\u52b1\u5f0f\u63d2\u5c4f");
            this.rewardedInterstitialAd = new RewardedInterstitialAd(context, this.mPlacementId);
            RewardedInterstitialAd.RewardedInterstitialAdLoadConfigBuilder configBuilder = this.rewardedInterstitialAd.buildLoadAdConfig().withAdListener(this.rewardedInterstitialAdListener).withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload);
            if (!TextUtils.isEmpty((CharSequence)this.userId)) {
                RewardData rewardData = new RewardData(this.userId, TextUtils.isEmpty((CharSequence)this.customData) ? "" : this.customData);
                Log.i((String)TAG, (String)("RewardData: userId : " + this.userId + " , customData : " + this.customData));
                configBuilder.withRewardData(rewardData);
            }
            this.rewardedInterstitialAd.loadAd(configBuilder.build());
        } else {
            Log.i((String)TAG, (String)"load \u6fc0\u52b1\u89c6\u9891");
            this.mRewardedVideoAd = new RewardedVideoAd(context, this.mPlacementId);
            RewardedVideoAd.RewardedVideoAdLoadConfigBuilder rewardedVideoAdLoadConfigBuilder = this.mRewardedVideoAd.buildLoadAdConfig().withAdListener(this.rewardedVideoAdListener);
            rewardedVideoAdLoadConfigBuilder.withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload);
            LogUtil.ownShow((String)(TextUtils.isEmpty((CharSequence)this.payload) ? "normal load" : "bidding load"));
            LogUtil.ownShow((String)("bidding payload = " + this.payload));
            if (!TextUtils.isEmpty((CharSequence)this.userId)) {
                RewardData rewardData = new RewardData(this.userId, TextUtils.isEmpty((CharSequence)this.customData) ? "" : this.customData);
                Log.i((String)TAG, (String)("RewardData: userId : " + this.userId + " , customData : " + this.customData));
                rewardedVideoAdLoadConfigBuilder.withRewardData(rewardData);
            }
            this.mRewardedVideoAd.loadAd(rewardedVideoAdLoadConfigBuilder.build());
        }
    }

    public void showAd() {
        if (this.isRewardedInterstitialAd == 2) {
            if (this.rewardedInterstitialAd != null && this.rewardedInterstitialAd.isAdLoaded()) {
                this.rewardedInterstitialAd.show();
            } else if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
            }
        } else if (this.mRewardedVideoAd != null && this.mRewardedVideoAd.isAdLoaded()) {
            this.mRewardedVideoAd.show();
        } else if (this.mShowListener != null) {
            this.mShowListener.onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
        }
    }

    public void clean() {
        super.clean();
        if (this.mRewardedVideoAd != null) {
            this.mRewardedVideoAd.destroy();
            this.mRewardedVideoAd = null;
        }
        if (this.rewardedInterstitialAd != null) {
            this.rewardedInterstitialAd.destroy();
            this.rewardedInterstitialAd = null;
        }
    }

    public boolean isReady() {
        if (this.mRewardedVideoAd != null) {
            return !this.isAdsTimeOut() && !this.mRewardedVideoAd.isAdInvalidated();
        }
        if (this.rewardedInterstitialAd != null) {
            return !this.isAdsTimeOut() && !this.rewardedInterstitialAd.isAdInvalidated();
        }
        return false;
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        String placementId = serverExtras.get("placementId");
        return placementId != null && placementId.length() > 0;
    }

    public String getNetworkName() {
        return TextUtils.isEmpty((CharSequence)this.mName) ? "Meta Audience Network" : this.mName;
    }

    public String getNetworkVersion() {
        return "6.17.0";
    }

    public String getBiddingToken() {
        try {
            return BidderTokenProvider.getBidderToken((Context)GlobalTradPlus.getInstance().getContext());
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

