/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSettings;
import com.facebook.ads.BidderTokenProvider;
import com.facebook.ads.NativeAd;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdListener;
import com.facebook.ads.NativeAdView;
import com.facebook.ads.NativeBannerAd;
import com.facebook.ads.NativeBannerAdView;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.facebook.FacebookErrorUtil;
import com.tradplus.ads.facebook.FacebookInitManager;
import com.tradplus.ads.facebook.FacebookNativeAd;
import java.util.Map;

public class FacebookNative
extends TPNativeAdapter {
    private NativeAd mFacebookNative;
    private FacebookNativeAd mFacebookNativeAd;
    private NativeBannerAd mNativeBannerAd;
    private String payload;
    private String placementId;
    private String mAdSize;
    private String secType;
    private boolean mNeedDownloadImg = false;
    private int mIsTemplateRending;
    private int mAdWidth;
    private int mAdHeight;
    private static final String TAG = "FacebookNative";
    private int placementAdType;
    private boolean mSingleIcon;
    private String mName;
    NativeAdListener nativeAdListener = new NativeAdListener(){

        public void onError(Ad ad, AdError adError) {
            Log.i((String)FacebookNative.TAG, (String)("onError: ErrorCode : " + adError.getErrorCode() + ", ErrorMessage : " + adError.getErrorMessage()));
            if (FacebookNative.this.mLoadAdapterListener != null) {
                FacebookNative.this.mLoadAdapterListener.loadAdapterLoadFailed(FacebookErrorUtil.getTradPlusErrorCode(adError));
            }
        }

        public void onAdLoaded(Ad ad) {
            Context context = GlobalTradPlus.getInstance().getContext();
            if (context == null) {
                if (FacebookNative.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Context == null");
                    tpError.setErrorMessage("context == null");
                    FacebookNative.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
                return;
            }
            if (FacebookNative.this.mIsTemplateRending == 1) {
                if (!"2".equals(FacebookNative.this.secType)) {
                    if (FacebookNative.this.placementAdType == 1) {
                        FacebookNative.this.AdLoadedTemplateNativeBanner(context);
                    } else {
                        FacebookNative.this.AdLoadedTemplateNative(context);
                    }
                } else {
                    FacebookNative.this.AdLoadedTemplateNativeBanner(context);
                }
            } else if (!"2".equals(FacebookNative.this.secType)) {
                if (FacebookNative.this.placementAdType == 1) {
                    FacebookNative.this.AdLoadedNativeBanner(context);
                } else {
                    FacebookNative.this.AdLoadedNative(context);
                }
            } else {
                FacebookNative.this.AdLoadedNativeBanner(context);
            }
        }

        public void onAdClicked(Ad ad) {
            Log.i((String)FacebookNative.TAG, (String)"onAdClicked: ");
            if (FacebookNative.this.mFacebookNativeAd != null) {
                FacebookNative.this.mFacebookNativeAd.onAdViewClicked();
            }
        }

        public void onLoggingImpression(Ad ad) {
            Log.i((String)FacebookNative.TAG, (String)"onLoggingImpression: ");
            if (FacebookNative.this.mFacebookNativeAd != null) {
                FacebookNative.this.mFacebookNativeAd.onAdViewExpanded();
            }
        }

        public void onMediaDownloaded(Ad ad) {
        }
    };

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.serverExtrasAreValid(tpParams)) {
            String placementAdTypeBanner;
            this.placementId = tpParams.get("placementId");
            String template = tpParams.get("is_template_rendering");
            this.secType = tpParams.get("sec_ad_type");
            this.payload = tpParams.get("Bidding-Payload");
            if (!TextUtils.isEmpty((CharSequence)template)) {
                this.mIsTemplateRending = Integer.parseInt(template);
            }
            String adSize = tpParams.get("ad_size" + this.placementId);
            Log.i((String)TAG, (String)("adSize: " + adSize));
            this.mAdSize = !TextUtils.isEmpty((CharSequence)adSize) && !"0".equals(adSize) ? adSize : "1";
            if (tpParams.containsKey("placement_ad_type") && !TextUtils.isEmpty((CharSequence)(placementAdTypeBanner = tpParams.get("placement_ad_type")))) {
                this.placementAdType = Integer.parseInt(placementAdTypeBanner);
            }
            if (tpParams.containsKey("name")) {
                this.mName = tpParams.get("name");
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        if (userParams.size() > 0) {
            Object singleIcon;
            String downLoadImg;
            if (userParams.containsKey("COPPA")) {
                boolean coppa = (Boolean)userParams.get("COPPA");
                Log.i((String)"privacylaws", (String)("coppa: " + coppa));
                if (coppa) {
                    this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Third-party network failed to provide an ad."));
                    return;
                }
            }
            if (userParams.containsKey("com_tp_ad_width")) {
                this.mAdWidth = (Integer)userParams.get("com_tp_ad_width");
            }
            if (userParams.containsKey("com_tp_ad_height")) {
                this.mAdHeight = (Integer)userParams.get("com_tp_ad_height");
            }
            Log.i((String)TAG, (String)("Width :" + this.mAdWidth + ", Height :" + this.mAdHeight));
            if (userParams.containsKey("need_down_load_img") && (downLoadImg = (String)userParams.get("need_down_load_img")).equals("true")) {
                this.mNeedDownloadImg = true;
            }
            if (userParams.containsKey("meta_singleIcon") && (singleIcon = userParams.get("meta_singleIcon")) instanceof Boolean) {
                this.mSingleIcon = (Boolean)singleIcon;
            }
            if (this.mAdHeight == 0 || this.mAdWidth == 0) {
                this.mAdHeight = 320;
                this.mAdWidth = 340;
            }
        }
        FacebookInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                FacebookNative.this.requestAd(context);
            }

            public void onFailed(String code, String msg) {
            }
        });
    }

    private void requestAd(Context context) {
        if (this.mIsTemplateRending == 1) {
            if (this.secType == null || !this.secType.equals("2")) {
                if (this.placementAdType == 1) {
                    this.loadNativeBannerTemplateAd(context, this.placementId);
                } else {
                    this.loadNativeTemplateAd(context, this.placementId);
                }
            } else {
                this.loadNativeBannerTemplateAd(context, this.placementId);
            }
        } else if (this.secType == null || !this.secType.equals("2")) {
            if (this.placementAdType == 1) {
                this.loadNativeBannerAd(context, this.placementId);
            } else {
                this.loadNativeAd(context, this.placementId);
            }
        } else {
            this.loadNativeBannerAd(context, this.placementId);
        }
    }

    private void loadNativeBannerTemplateAd(Context context, String placementId) {
        Log.i((String)TAG, (String)"loadNativeBannerTemplateAd: ");
        this.mNativeBannerAd = new NativeBannerAd(context, placementId);
        this.mNativeBannerAd.loadAd(this.mNativeBannerAd.buildLoadAdConfig().withAdListener(this.nativeAdListener).withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload).build());
    }

    private void loadNativeTemplateAd(Context context, String placementId) {
        Log.i((String)TAG, (String)"loadNativeTemplateAd: ");
        this.mFacebookNative = new NativeAd(context, placementId);
        this.mFacebookNative.loadAd(this.mFacebookNative.buildLoadAdConfig().withAdListener(this.nativeAdListener).withMediaCacheFlag(NativeAdBase.MediaCacheFlag.ALL).withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload).build());
    }

    private void loadNativeBannerAd(Context context, String placementId) {
        this.mNativeBannerAd = new NativeBannerAd(context, placementId);
        this.mNativeBannerAd.loadAd(this.mNativeBannerAd.buildLoadAdConfig().withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload).withMediaCacheFlag(NativeAdBase.MediaCacheFlag.ALL).withAdListener(this.nativeAdListener).build());
    }

    private void loadNativeAd(Context context, String placementId) {
        this.mFacebookNative = new NativeAd(context, placementId);
        this.mFacebookNative.loadAd(this.mFacebookNative.buildLoadAdConfig().withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload).withAdListener(this.nativeAdListener).build());
    }

    private void AdLoadedNativeBanner(Context context) {
        if (this.mNativeBannerAd != null) {
            this.mNativeBannerAd.unregisterView();
            this.mFacebookNativeAd = new FacebookNativeAd(context, this.mNativeBannerAd, this.mSingleIcon);
            if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)this.mFacebookNativeAd);
            }
        } else if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Unspecified error."));
        }
    }

    private void AdLoadedNative(Context context) {
        if (this.mFacebookNative != null) {
            this.mFacebookNative.unregisterView();
            this.mFacebookNativeAd = new FacebookNativeAd(context, this.mFacebookNative, this.mSingleIcon);
            this.downloadAndCallback(this.mFacebookNativeAd, this.mNeedDownloadImg);
        } else if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Unspecified error."));
        }
    }

    private void AdLoadedTemplateNativeBanner(Context context) {
        if (this.mNativeBannerAd != null) {
            if (this.mNativeBannerAd.isAdLoaded() && !this.mNativeBannerAd.isAdInvalidated()) {
                Log.i((String)TAG, (String)"TemplateNativeBannerAdLoaded: ");
                View adView = NativeBannerAdView.render((Context)context, (NativeBannerAd)this.mNativeBannerAd, (NativeBannerAdView.Type)this.calculateAdSize(this.mAdSize));
                this.mFacebookNativeAd = new FacebookNativeAd(adView, 1);
                if (this.mLoadAdapterListener != null) {
                    this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)this.mFacebookNativeAd);
                }
            } else if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Unspecified error."));
            }
        } else if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Unspecified error."));
        }
    }

    private void AdLoadedTemplateNative(Context context) {
        if (this.mFacebookNative != null) {
            Log.i((String)TAG, (String)"TemplateNativeAdLoaded: ");
            View adView = NativeAdView.render((Context)context, (NativeAd)this.mFacebookNative);
            if (this.mAdWidth != 0 && this.mAdHeight != 0) {
                RelativeLayout relativeLayout = new RelativeLayout(context);
                relativeLayout.addView(adView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(DeviceUtils.dip2px((Context)context, (float)this.mAdWidth), DeviceUtils.dip2px((Context)context, (float)this.mAdHeight)));
                relativeLayout.setGravity(17);
                this.mFacebookNativeAd = new FacebookNativeAd((View)relativeLayout, 1);
            } else {
                this.mFacebookNativeAd = new FacebookNativeAd(adView, 1);
            }
            if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)this.mFacebookNativeAd);
            }
        } else if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Unspecified error."));
        }
    }

    public void clean() {
        AdSettings.clearTestDevices();
        if (this.mFacebookNativeAd != null) {
            this.mFacebookNativeAd.clean();
        }
    }

    public String getNetworkName() {
        return TextUtils.isEmpty((CharSequence)this.mName) ? "Meta Audience Network" : this.mName;
    }

    public String getNetworkVersion() {
        return "6.17.0";
    }

    private NativeBannerAdView.Type calculateAdSize(String adSize) {
        if (adSize.equals("1")) {
            return NativeBannerAdView.Type.HEIGHT_50;
        }
        if (adSize.equals("2")) {
            return NativeBannerAdView.Type.HEIGHT_100;
        }
        if (adSize.equals("3")) {
            return NativeBannerAdView.Type.HEIGHT_120;
        }
        return NativeBannerAdView.Type.HEIGHT_50;
    }

    private boolean serverExtrasAreValid(Map<String, String> serverExtras) {
        String placementId = serverExtras.get("placementId");
        return placementId != null && placementId.length() > 0;
    }

    public String getBiddingToken() {
        try {
            return BidderTokenProvider.getBidderToken((Context)GlobalTradPlus.getInstance().getContext());
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

