/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.facebook.ads.AdOptionsView;
import com.facebook.ads.MediaView;
import com.facebook.ads.NativeAdLayout;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.facebook.FacebookListNative;
import com.tradplus.ads.nativeads.BaseNativeAd;
import com.tradplus.ads.nativeads.MoPubAdRenderer;
import com.tradplus.ads.nativeads.NativeRendererHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class FacebookAdRenderer
implements MoPubAdRenderer<FacebookListNative.FacebookNativeAd> {
    private final FacebookViewBinder mViewBinder;
    final WeakHashMap<View, FacebookNativeViewHolder> mViewHolderMap;

    public FacebookAdRenderer(FacebookViewBinder viewBinder) {
        this.mViewBinder = viewBinder;
        this.mViewHolderMap = new WeakHashMap();
    }

    public View createAdView(Context context, ViewGroup parent) {
        Preconditions.checkNotNull((Object)context);
        return LayoutInflater.from((Context)context).inflate(this.mViewBinder.layoutId, parent, false);
    }

    public void renderAdView(View view, FacebookListNative.FacebookNativeAd facebookNativeAd) {
        Preconditions.checkNotNull((Object)((Object)facebookNativeAd));
        Preconditions.checkNotNull((Object)view);
        FacebookNativeViewHolder facebookNativeViewHolder = this.mViewHolderMap.get(view);
        if (facebookNativeViewHolder == null) {
            facebookNativeViewHolder = FacebookNativeViewHolder.fromViewBinder(view, this.mViewBinder);
            this.mViewHolderMap.put(view, facebookNativeViewHolder);
        }
        this.update(facebookNativeViewHolder, facebookNativeAd);
        NativeRendererHelper.updateExtras((View)facebookNativeViewHolder.getMainView(), this.mViewBinder.extras, facebookNativeAd.getExtras());
    }

    public boolean supports(BaseNativeAd nativeAd) {
        Preconditions.checkNotNull((Object)nativeAd);
        return nativeAd instanceof FacebookListNative.FacebookNativeAd;
    }

    private void update(FacebookNativeViewHolder facebookNativeViewHolder, FacebookListNative.FacebookNativeAd nativeAd) {
        NativeRendererHelper.addTextView((TextView)facebookNativeViewHolder.getTitleView(), (String)nativeAd.getTitle());
        NativeRendererHelper.addTextView((TextView)facebookNativeViewHolder.getTextView(), (String)nativeAd.getText());
        NativeRendererHelper.addTextView((TextView)facebookNativeViewHolder.getCallToActionView(), (String)nativeAd.getCallToAction());
        NativeRendererHelper.addTextView((TextView)facebookNativeViewHolder.getAdvertiserNameView(), (String)nativeAd.getAdvertiserName());
        NativeRendererHelper.addTextView((TextView)facebookNativeViewHolder.getSponsoredLabelView(), (String)nativeAd.getSponsoredName());
        RelativeLayout adChoicesContainer = facebookNativeViewHolder.getAdChoicesContainer();
        nativeAd.registerChildViewsForInteraction(facebookNativeViewHolder.getMainView(), facebookNativeViewHolder.getMediaView(), facebookNativeViewHolder.getAdIconView());
        if (adChoicesContainer != null) {
            AdOptionsView adOptionsView;
            ViewGroup.LayoutParams layoutParams;
            adChoicesContainer.removeAllViews();
            NativeAdLayout nativeAdLayout = null;
            if (facebookNativeViewHolder.mainView instanceof NativeAdLayout) {
                nativeAdLayout = (NativeAdLayout)facebookNativeViewHolder.mainView;
            }
            if ((layoutParams = (adOptionsView = new AdOptionsView(adChoicesContainer.getContext(), nativeAd.getFacebookNativeAd(), nativeAdLayout)).getLayoutParams()) instanceof RelativeLayout.LayoutParams) {
                if (Build.VERSION.SDK_INT >= 17) {
                    ((RelativeLayout.LayoutParams)layoutParams).addRule(21);
                } else {
                    ((RelativeLayout.LayoutParams)layoutParams).addRule(11);
                }
            }
            adChoicesContainer.addView((View)adOptionsView);
        }
    }

    public static class FacebookViewBinder {
        final int layoutId;
        final int titleId;
        final int textId;
        final int callToActionId;
        final int adChoicesRelativeLayoutId;
        final Map<String, Integer> extras;
        final int mediaViewId;
        final int adIconViewId;
        final int advertiserNameId;
        final int sponsoredLabelId;

        private FacebookViewBinder(Builder builder) {
            Preconditions.checkNotNull((Object)builder);
            this.layoutId = builder.layoutId;
            this.titleId = builder.titleId;
            this.textId = builder.textId;
            this.callToActionId = builder.callToActionId;
            this.adChoicesRelativeLayoutId = builder.adChoicesRelativeLayoutId;
            this.extras = builder.extras;
            this.mediaViewId = builder.mediaViewId;
            this.adIconViewId = builder.adIconViewId;
            this.advertiserNameId = builder.advertiserNameId;
            this.sponsoredLabelId = builder.sponsoredLabelId;
        }

        public static class Builder {
            private final int layoutId;
            private int titleId;
            private int textId;
            private int callToActionId;
            private int adChoicesRelativeLayoutId;
            private Map<String, Integer> extras = Collections.emptyMap();
            private int mediaViewId;
            private int adIconViewId;
            private int advertiserNameId;
            private int sponsoredLabelId;

            public Builder(int layoutId) {
                this.layoutId = layoutId;
                this.extras = new HashMap<String, Integer>();
            }

            public final Builder titleId(int titleId) {
                this.titleId = titleId;
                return this;
            }

            public final Builder textId(int textId) {
                this.textId = textId;
                return this;
            }

            public final Builder callToActionId(int callToActionId) {
                this.callToActionId = callToActionId;
                return this;
            }

            public final Builder adChoicesRelativeLayoutId(int adChoicesRelativeLayoutId) {
                this.adChoicesRelativeLayoutId = adChoicesRelativeLayoutId;
                return this;
            }

            public final Builder extras(Map<String, Integer> resourceIds) {
                this.extras = new HashMap<String, Integer>(resourceIds);
                return this;
            }

            public final Builder addExtra(String key, int resourceId) {
                this.extras.put(key, resourceId);
                return this;
            }

            public Builder mediaViewId(int mediaViewId) {
                this.mediaViewId = mediaViewId;
                return this;
            }

            public Builder adIconViewId(int adIconViewId) {
                this.adIconViewId = adIconViewId;
                return this;
            }

            public Builder advertiserNameId(int advertiserNameId) {
                this.advertiserNameId = advertiserNameId;
                return this;
            }

            public Builder sponsoredNameId(int sponsoredLabelId) {
                this.sponsoredLabelId = sponsoredLabelId;
                return this;
            }

            public FacebookViewBinder build() {
                return new FacebookViewBinder(this);
            }
        }
    }

    static class FacebookNativeViewHolder {
        private View mainView;
        private TextView titleView;
        private TextView textView;
        private TextView callToActionView;
        private RelativeLayout adChoicesContainer;
        private MediaView mediaView;
        private MediaView adIconView;
        private TextView advertiserNameView;
        private TextView sponsoredLabelView;

        private FacebookNativeViewHolder() {
        }

        static FacebookNativeViewHolder fromViewBinder(View view, FacebookViewBinder facebookViewBinder) {
            if (view == null || facebookViewBinder == null) {
                return new FacebookNativeViewHolder();
            }
            FacebookNativeViewHolder viewHolder = new FacebookNativeViewHolder();
            viewHolder.mainView = view;
            viewHolder.titleView = (TextView)view.findViewById(facebookViewBinder.titleId);
            viewHolder.textView = (TextView)view.findViewById(facebookViewBinder.textId);
            viewHolder.callToActionView = (TextView)view.findViewById(facebookViewBinder.callToActionId);
            viewHolder.adChoicesContainer = (RelativeLayout)view.findViewById(facebookViewBinder.adChoicesRelativeLayoutId);
            viewHolder.mediaView = (MediaView)view.findViewById(facebookViewBinder.mediaViewId);
            viewHolder.adIconView = (MediaView)view.findViewById(facebookViewBinder.adIconViewId);
            viewHolder.advertiserNameView = (TextView)view.findViewById(facebookViewBinder.advertiserNameId);
            viewHolder.sponsoredLabelView = (TextView)view.findViewById(facebookViewBinder.sponsoredLabelId);
            return viewHolder;
        }

        public View getMainView() {
            return this.mainView;
        }

        public TextView getTitleView() {
            return this.titleView;
        }

        public TextView getTextView() {
            return this.textView;
        }

        public TextView getCallToActionView() {
            return this.callToActionView;
        }

        public RelativeLayout getAdChoicesContainer() {
            return this.adChoicesContainer;
        }

        public MediaView getAdIconView() {
            return this.adIconView;
        }

        public MediaView getMediaView() {
            return this.mediaView;
        }

        public TextView getAdvertiserNameView() {
            return this.advertiserNameView;
        }

        public TextView getSponsoredLabelView() {
            return this.sponsoredLabelView;
        }
    }
}

