/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.content.Context;
import android.util.Log;
import android.view.View;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.tradplus.ads.base.adapter.banner.TPBannerAdImpl;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.common.util.Views;
import com.tradplus.ads.facebook.FacebookErrorUtil;
import com.tradplus.ads.facebook.FacebookInitializeHelper;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.mobileads.util.TestDeviceUtil;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class FacebookBanner
extends TPBannerAdapter {
    private AdView mFacebookBanner;
    private String mAdSize;
    private String placementId;
    private TPBannerAdImpl mTpBannerAd;

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.serverExtrasAreValid(tpParams)) {
            this.placementId = tpParams.get("placementId");
            Log.d((String)"TradPlus Banner size", (String)("adsize == " + tpParams.get("ad_size" + this.placementId)));
            this.mAdSize = tpParams.get("ad_size" + this.placementId) != null && !tpParams.get("ad_size" + this.placementId).equals("0") ? tpParams.get("ad_size" + this.placementId) : "1";
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        if (userParams.size() > 0) {
            boolean coppa;
            Log.i((String)"FacebookBanner", (String)("suportGDPR ccpa: " + userParams.get("CCPA") + ":COPPA:" + userParams.get("COPPA")));
            if (userParams.containsKey("CCPA")) {
                boolean cppa = (Boolean)userParams.get("CCPA");
                if (cppa) {
                    AdSettings.setDataProcessingOptions((String[])new String[0]);
                } else {
                    AdSettings.setDataProcessingOptions((String[])new String[]{"LDU"}, (int)1, (int)1000);
                }
            }
            if (userParams.containsKey("COPPA") && (coppa = ((Boolean)userParams.get("COPPA")).booleanValue())) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.NETWORK_NO_FILL);
                return;
            }
        }
        FacebookInitializeHelper.initialize(context);
        AdSettings.setTestMode((boolean)TestDeviceUtil.getInstance().isNeedTestDevice());
        this.mFacebookBanner = new AdView(context, this.placementId, this.calculateAdSize(this.mAdSize));
        AdListener adListener = new AdListener(){

            public void onError(Ad ad, AdError adError) {
                Log.d((String)"Tradplus", (String)("Facebook banner ad load failed  , ErrorCode : " + adError.getErrorCode() + ", ErrorMessage : " + adError.getErrorMessage()));
                if (FacebookBanner.this.mLoadAdapterListener != null) {
                    FacebookBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(FacebookErrorUtil.getTradPlusErrorCode(adError));
                }
            }

            public void onAdLoaded(Ad ad) {
                if (FacebookBanner.this.mFacebookBanner == null) {
                    return;
                }
                Log.d((String)"TradPlus", (String)"Facebook banner ad loaded successfully. Showing ad...");
                FacebookBanner.this.mTpBannerAd = new TPBannerAdImpl(null, (View)FacebookBanner.this.mFacebookBanner);
                FacebookBanner.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)FacebookBanner.this.mTpBannerAd);
            }

            public void onAdClicked(Ad ad) {
                Log.d((String)"TradPlus", (String)"Facebook banner ad clicked.");
                if (FacebookBanner.this.mTpBannerAd != null) {
                    FacebookBanner.this.mTpBannerAd.adClicked();
                }
            }

            public void onLoggingImpression(Ad ad) {
                Log.d((String)"TradPlus", (String)"Facebook banner ad onLoggingImpression.");
                if (FacebookBanner.this.mTpBannerAd != null) {
                    FacebookBanner.this.mTpBannerAd.adShown();
                }
            }
        };
        this.mFacebookBanner.loadAd(this.mFacebookBanner.buildLoadAdConfig().withAdListener(adListener).build());
    }

    public void clean() {
        if (this.mFacebookBanner != null) {
            Views.removeFromParent((View)this.mFacebookBanner);
            this.mFacebookBanner.destroy();
            this.mFacebookBanner = null;
        }
    }

    public String getNetworkVersion() {
        return "6.2.0";
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("1");
    }

    private boolean serverExtrasAreValid(Map<String, String> serverExtras) {
        String placementId = serverExtras.get("placementId");
        return placementId != null && placementId.length() > 0;
    }

    private AdSize calculateAdSize(String adSize) {
        if (adSize.equals("1")) {
            return AdSize.BANNER_HEIGHT_50;
        }
        if (adSize.equals("2")) {
            return AdSize.BANNER_HEIGHT_90;
        }
        if (adSize.equals("3")) {
            return AdSize.RECTANGLE_HEIGHT_250;
        }
        return AdSize.BANNER_HEIGHT_50;
    }
}

