/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSettings;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.facebook.FacebookErrorUtil;
import com.tradplus.ads.facebook.FacebookInitializeHelper;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.mobileads.util.TestDeviceUtil;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class FacebookInterstitialVideo
extends TPRewardAdapter {
    public static final String CURRENCY_NAME_KEY = "currencyName";
    public static final String AMOUNT_KEY = "amount";
    private RewardedVideoAd mRewardedVideoAd;
    private long mAdLoadTimeStamp;
    private String mAdUnitId;
    private String mParams;
    private String mPlacementId;
    private String mCurrencyName;
    private String mAmount;
    private String payload;

    public void loadCustomAd(Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        if (!this.extrasAreValid(serverExtras)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        this.mPlacementId = serverExtras.get("placementId");
        this.mCurrencyName = serverExtras.get(CURRENCY_NAME_KEY);
        this.mAmount = serverExtras.get(AMOUNT_KEY);
        if (localExtras.size() > 0) {
            boolean coppa;
            this.payload = (String)localExtras.get("Bidding-Payload");
            Log.i((String)"FacebookInter", (String)("suportGDPR ccpa: " + localExtras.get("CCPA") + ":COPPA:" + localExtras.get("COPPA")));
            if (localExtras.containsKey("CCPA")) {
                boolean cppa = (Boolean)localExtras.get("CCPA");
                if (cppa) {
                    AdSettings.setDataProcessingOptions((String[])new String[0]);
                } else {
                    AdSettings.setDataProcessingOptions((String[])new String[]{"LDU"}, (int)1, (int)1000);
                }
            }
            if (localExtras.containsKey("COPPA") && (coppa = ((Boolean)localExtras.get("COPPA")).booleanValue())) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.NETWORK_NO_FILL);
                return;
            }
        }
        FacebookInitializeHelper.initialize(context);
        this.mAdUnitId = (String)localExtras.get("com_mopub_ad_unit_id");
        this.mParams = serverExtras.toString();
        this.mAdLoadTimeStamp = System.currentTimeMillis();
        AdSettings.setTestMode((boolean)TestDeviceUtil.getInstance().isNeedTestDevice());
        this.mRewardedVideoAd = new RewardedVideoAd(context, this.mPlacementId);
        RewardedVideoAdListener rewardedVideoAdListener = new RewardedVideoAdListener(){

            public void onRewardedVideoCompleted() {
                Log.d((String)"TradPlus", (String)"Facebook rewarded video ad onRewardedVideoCompleted.");
                if (FacebookInterstitialVideo.this.mShowListener != null) {
                    FacebookInterstitialVideo.this.mShowListener.onReward();
                }
            }

            public void onError(Ad ad, AdError adError) {
                Log.d((String)"TradPlus", (String)("Facebook RewardedVideo ad load failed  , ErrorCode : " + adError.getErrorCode() + ", ErrorMessage : " + adError.getErrorMessage()));
                if (FacebookInterstitialVideo.this.mLoadAdapterListener != null) {
                    FacebookInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(FacebookErrorUtil.getTradPlusErrorCode(adError));
                }
            }

            public void onAdLoaded(Ad ad) {
                if (FacebookInterstitialVideo.this.mRewardedVideoAd == null) {
                    return;
                }
                FacebookInterstitialVideo.this.setFirstLoadedTime();
                Log.d((String)"TradPlus", (String)"Facebook rewarded video ad loaded successfully.");
                if (FacebookInterstitialVideo.this.mLoadAdapterListener != null) {
                    FacebookInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }

            public void onAdClicked(Ad ad) {
                Log.d((String)"TradPlus", (String)"Facebook rewarded video ad clicked.");
                if (FacebookInterstitialVideo.this.mShowListener != null) {
                    FacebookInterstitialVideo.this.mShowListener.onAdClicked();
                }
            }

            public void onLoggingImpression(Ad ad) {
                Log.d((String)"TradPlus", (String)"Facebook rewarded video ad onLoggingImpression.");
                if (FacebookInterstitialVideo.this.mShowListener != null) {
                    FacebookInterstitialVideo.this.mShowListener.onAdShown();
                }
            }

            public void onRewardedVideoClosed() {
                Log.d((String)"TradPlus", (String)"Facebook rewarded video ad onRewardedVideoClosed.");
                if (FacebookInterstitialVideo.this.mShowListener != null) {
                    FacebookInterstitialVideo.this.mShowListener.onAdClosed();
                }
            }
        };
        RewardedVideoAd.RewardedVideoAdLoadConfigBuilder rewardedVideoAdLoadConfigBuilder = this.mRewardedVideoAd.buildLoadAdConfig().withAdListener(rewardedVideoAdListener);
        rewardedVideoAdLoadConfigBuilder.withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload);
        LogUtil.ownShow((String)(TextUtils.isEmpty((CharSequence)this.payload) ? "normal load" : "bidding load"));
        LogUtil.ownShow((String)("bidding payload = " + this.payload));
        this.mRewardedVideoAd.loadAd(rewardedVideoAdLoadConfigBuilder.build());
    }

    public void showAd() {
        if (this.mRewardedVideoAd != null && this.mRewardedVideoAd.isAdLoaded()) {
            this.mRewardedVideoAd.show();
            String msg = "isAdLoaded";
        } else {
            Log.d((String)"TradPlus", (String)"Tried to show a Facebook rewarded video ad before it finished loading. Please try again.");
            if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.SHOW_FAILED);
            } else {
                Log.d((String)"TradPlus", (String)"rewarded video listener not instantiated. Please load interstitial again.");
            }
            String msg = "noAdLoaded";
        }
    }

    public void clean() {
        super.clean();
        if (this.mRewardedVideoAd != null) {
            this.mRewardedVideoAd.destroy();
            this.mRewardedVideoAd = null;
        }
    }

    public boolean isReady() {
        if (this.mRewardedVideoAd != null) {
            return !this.isAdsTimeOut() && !this.mRewardedVideoAd.isAdInvalidated();
        }
        return false;
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        String placementId = serverExtras.get("placementId");
        return placementId != null && placementId.length() > 0;
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("1");
    }

    public String getNetworkVersion() {
        return "6.2.0";
    }
}

