/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSettings;
import com.facebook.ads.MediaView;
import com.facebook.ads.NativeAd;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdListener;
import com.facebook.ads.NativeBannerAd;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.facebook.FacebookErrorUtil;
import com.tradplus.ads.facebook.FacebookInitializeHelper;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.mobileads.util.TestDeviceUtil;
import com.tradplus.ads.nativeads.BaseNativeAd;
import com.tradplus.ads.nativeads.CustomEventNative;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class FacebookListNative
extends CustomEventNative {
    public static final String NATIVE_BANNER_KEY = "native_banner";
    private static final String ADAPTER_NAME = FacebookListNative.class.getSimpleName();
    private static AtomicBoolean sIsInitialized = new AtomicBoolean(false);
    private Boolean isNativeBanner;
    private static String mPlacementId;

    protected void loadNativeAd(Context context, CustomEventNative.CustomEventNativeListener customEventNativeListener, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)customEventNativeListener);
        Preconditions.checkNotNull(localExtras);
        Preconditions.checkNotNull(serverExtras);
        LogUtil.ownShow((String)"--------FacebookListNative");
        if (TextUtils.isEmpty((CharSequence)serverExtras.get("placementId"))) {
            customEventNativeListener.onNativeAdFailed(TradPlusErrorCode.NETWORK_NO_FILL);
            LogUtil.show((String)(ADAPTER_NAME + TradPlusErrorCode.NETWORK_NO_FILL + TradPlusErrorCode.NETWORK_NO_FILL));
            return;
        }
        String placementId = serverExtras.get("placementId");
        if (localExtras.size() > 0) {
            boolean coppa;
            Log.i((String)"FacebookListNative", (String)("suportGDPR ccpa: " + localExtras.get("CCPA") + ":COPPA:" + localExtras.get("COPPA")));
            if (localExtras.containsKey("CCPA")) {
                boolean cppa = (Boolean)localExtras.get("CCPA");
                if (cppa) {
                    AdSettings.setDataProcessingOptions((String[])new String[0]);
                } else {
                    AdSettings.setDataProcessingOptions((String[])new String[]{"LDU"}, (int)1, (int)1000);
                }
            }
            if (localExtras.containsKey("COPPA") && (coppa = ((Boolean)localExtras.get("COPPA")).booleanValue())) {
                customEventNativeListener.onNativeAdFailed(TradPlusErrorCode.NETWORK_NO_FILL);
                return;
            }
        }
        FacebookInitializeHelper.initialize(context);
        FacebookNativeAd facebookNativeAd = new FacebookNativeAd(context, (NativeAdBase)new NativeAd(context, placementId), customEventNativeListener, "");
        facebookNativeAd.loadAd();
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        mPlacementId = serverExtras.get("placementId");
        return !TextUtils.isEmpty((CharSequence)mPlacementId);
    }

    private static void registerChildViewsForInteraction(View view, NativeAdBase nativeAdBase, MediaView mediaView, MediaView adIconView) {
        if (nativeAdBase == null) {
            return;
        }
        ArrayList<View> clickableViews = new ArrayList<View>();
        FacebookListNative.assembleChildViewsWithLimit(view, clickableViews, 10);
        if (nativeAdBase instanceof NativeAd && mediaView != null) {
            NativeAd nativeAd = (NativeAd)nativeAdBase;
            if (clickableViews.size() == 1) {
                nativeAd.registerViewForInteraction(view, mediaView, adIconView);
            } else {
                nativeAd.registerViewForInteraction(view, mediaView, adIconView, clickableViews);
            }
        } else if (nativeAdBase instanceof NativeBannerAd) {
            NativeBannerAd nativeBannerAd = (NativeBannerAd)nativeAdBase;
            if (clickableViews.size() == 1) {
                nativeBannerAd.registerViewForInteraction(view, adIconView);
            } else {
                nativeBannerAd.registerViewForInteraction(view, adIconView, clickableViews);
            }
        }
    }

    private static void assembleChildViewsWithLimit(View view, List<View> clickableViews, int limit) {
        if (view == null) {
            LogUtil.show((String)"View given is null. Ignoring");
            return;
        }
        if (limit <= 0) {
            LogUtil.show((String)"Depth limit reached; adding this view regardless of its type.");
            clickableViews.add(view);
            return;
        }
        if (view instanceof ViewGroup && ((ViewGroup)view).getChildCount() > 0) {
            ViewGroup vg = (ViewGroup)view;
            for (int i = 0; i < vg.getChildCount(); ++i) {
                FacebookListNative.assembleChildViewsWithLimit(vg.getChildAt(i), clickableViews, limit - 1);
            }
            return;
        }
        clickableViews.add(view);
    }

    private static String getAdNetworkId() {
        return mPlacementId;
    }

    static class FacebookNativeAd
    extends BaseNativeAd {
        private static final String SOCIAL_CONTEXT_FOR_AD = "socialContextForAd";
        private final NativeAdBase mNativeAd;
        private final CustomEventNative.CustomEventNativeListener mCustomEventNativeListener;
        private final Map<String, Object> mExtras;
        private final String mBid;

        FacebookNativeAd(Context context, NativeAdBase nativeAd, CustomEventNative.CustomEventNativeListener customEventNativeListener, String bid) {
            this.mNativeAd = nativeAd;
            this.mCustomEventNativeListener = customEventNativeListener;
            this.mExtras = new HashMap<String, Object>();
            this.mBid = bid;
            AdSettings.setTestMode((boolean)TestDeviceUtil.getInstance().isNeedTestDevice());
        }

        void loadAd() {
            NativeAdBase.NativeAdLoadConfigBuilder nativeAdLoadConfigBuilder = this.mNativeAd.buildLoadAdConfig();
            NativeAdListener nativeAdListener = new NativeAdListener(){

                public void onError(Ad ad, AdError adError) {
                    Log.d((String)"TradPlus", (String)("Facebook RewardedVideo ad load failed  , ErrorCode : " + adError.getErrorCode() + ", ErrorMessage : " + adError.getErrorMessage()));
                    if (FacebookNativeAd.this.mCustomEventNativeListener != null) {
                        FacebookNativeAd.this.mCustomEventNativeListener.onNativeAdFailed(FacebookErrorUtil.getTradPlusErrorCode(adError));
                    }
                }

                public void onAdLoaded(Ad ad) {
                    if (!FacebookNativeAd.this.mNativeAd.equals(ad) || !FacebookNativeAd.this.mNativeAd.isAdLoaded()) {
                        FacebookNativeAd.this.mCustomEventNativeListener.onNativeAdFailed(TradPlusErrorCode.NETWORK_NO_FILL);
                        LogUtil.show((String)(ADAPTER_NAME + TradPlusErrorCode.NETWORK_NO_FILL + TradPlusErrorCode.NETWORK_NO_FILL));
                        return;
                    }
                    FacebookNativeAd.this.addExtra(FacebookNativeAd.SOCIAL_CONTEXT_FOR_AD, FacebookNativeAd.this.mNativeAd.getAdSocialContext());
                    FacebookNativeAd.this.mCustomEventNativeListener.onNativeAdLoaded((BaseNativeAd)FacebookNativeAd.this);
                    LogUtil.show((String)ADAPTER_NAME);
                }

                public void onAdClicked(Ad ad) {
                    FacebookNativeAd.this.notifyAdClicked();
                    FacebookNativeAd.this.mCustomEventNativeListener.onNativeAdClicked("Facebook");
                    LogUtil.show((String)ADAPTER_NAME);
                }

                public void onLoggingImpression(Ad ad) {
                    FacebookNativeAd.this.notifyAdImpressed();
                    LogUtil.show((String)ADAPTER_NAME);
                }

                public void onMediaDownloaded(Ad ad) {
                }
            };
            if (!TextUtils.isEmpty((CharSequence)this.mBid)) {
                this.mNativeAd.loadAd(this.mNativeAd.buildLoadAdConfig().withAdListener(nativeAdListener).build());
                LogUtil.show((String)ADAPTER_NAME);
            } else {
                this.mNativeAd.loadAd(this.mNativeAd.buildLoadAdConfig().withAdListener(nativeAdListener).build());
                LogUtil.show((String)ADAPTER_NAME);
            }
        }

        public final String getAdvertiserName() {
            return this.mNativeAd.getAdvertiserName();
        }

        public final String getTitle() {
            return this.mNativeAd.getAdHeadline();
        }

        public final String getText() {
            return this.mNativeAd.getAdBodyText();
        }

        public final String getCallToAction() {
            return this.mNativeAd.getAdCallToAction();
        }

        public final String getSponsoredName() {
            return this.mNativeAd instanceof NativeBannerAd ? this.mNativeAd.getSponsoredTranslation() : null;
        }

        public final String getPrivacyInformationIconClickThroughUrl() {
            return this.mNativeAd.getAdChoicesLinkUrl();
        }

        public void prepare(View view) {
        }

        public void clear(View view) {
            Preconditions.checkNotNull((Object)view);
            this.mNativeAd.unregisterView();
        }

        public void destroy() {
            this.mNativeAd.destroy();
        }

        public final Object getExtra(String key) {
            if (!Preconditions.NoThrow.checkNotNull((Object)key, (String)"getExtra key is not allowed to be null")) {
                return null;
            }
            return this.mExtras.get(key);
        }

        public final Map<String, Object> getExtras() {
            return new HashMap<String, Object>(this.mExtras);
        }

        public final void addExtra(String key, Object value) {
            if (!Preconditions.NoThrow.checkNotNull((Object)key, (String)"addExtra key is not allowed to be null")) {
                return;
            }
            this.mExtras.put(key, value);
        }

        void registerChildViewsForInteraction(View view, MediaView mediaView, MediaView adIconView) {
            FacebookListNative.registerChildViewsForInteraction(view, this.mNativeAd, mediaView, adIconView);
        }

        NativeAdBase getFacebookNativeAd() {
            return this.mNativeAd;
        }
    }
}

