/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.BidderTokenProvider;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.facebook.FacebookErrorUtil;
import com.tradplus.ads.facebook.FacebookInitializeHelper;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class FacebookInterstitial
extends TPInterstitialAdapter {
    private InterstitialAd mFacebookInterstitial;
    private String payload;
    private static final String TAG = "FacebookInterstitial";

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("1");
    }

    public String getNetworkVersion() {
        return "6.5.1";
    }

    public void loadCustomAd(Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        if (!this.extrasAreValid(serverExtras)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        String placementId = serverExtras.get("placementId");
        this.payload = serverExtras.get("Bidding-Payload");
        if (localExtras.size() > 0) {
            boolean coppa;
            Log.i((String)TAG, (String)("suportGDPR :COPPA:" + localExtras.get("COPPA")));
            if (localExtras.containsKey("COPPA") && (coppa = ((Boolean)localExtras.get("COPPA")).booleanValue())) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Third-party network failed to provide an ad."));
                return;
            }
        }
        FacebookInitializeHelper.initialize(context);
        this.mFacebookInterstitial = new InterstitialAd(context, placementId);
        InterstitialAdListener interstitialAdListener = new InterstitialAdListener(){

            public void onError(Ad ad, AdError adError) {
                Log.i((String)FacebookInterstitial.TAG, (String)("Facebook interstitial ad load failed  ,ErrorCode : " + adError.getErrorCode() + ", ErrorMessage : " + adError.getErrorMessage()));
                if (FacebookInterstitial.this.mLoadAdapterListener != null) {
                    FacebookInterstitial.this.mLoadAdapterListener.loadAdapterLoadFailed(FacebookErrorUtil.getTradPlusErrorCode(adError));
                }
            }

            public void onAdLoaded(Ad ad) {
                if (FacebookInterstitial.this.mFacebookInterstitial == null) {
                    return;
                }
                FacebookInterstitial.this.setFirstLoadedTime();
                Log.i((String)FacebookInterstitial.TAG, (String)"Facebook interstitial ad loaded successfully.");
                if (FacebookInterstitial.this.mLoadAdapterListener != null) {
                    FacebookInterstitial.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }

            public void onAdClicked(Ad ad) {
                Log.i((String)FacebookInterstitial.TAG, (String)"Facebook interstitial ad clicked.");
                if (FacebookInterstitial.this.mShowListener != null) {
                    FacebookInterstitial.this.mShowListener.onAdClicked();
                }
            }

            public void onLoggingImpression(Ad ad) {
                Log.i((String)FacebookInterstitial.TAG, (String)"Facebook interstitial ad onLoggingImpression.");
            }

            public void onInterstitialDisplayed(Ad ad) {
                Log.i((String)FacebookInterstitial.TAG, (String)"Showing Facebook interstitial ad.");
                if (FacebookInterstitial.this.mShowListener != null) {
                    FacebookInterstitial.this.mShowListener.onAdShown();
                }
            }

            public void onInterstitialDismissed(Ad ad) {
                Log.i((String)FacebookInterstitial.TAG, (String)"Facebook interstitial ad dismissed.");
                if (FacebookInterstitial.this.mShowListener != null) {
                    FacebookInterstitial.this.mShowListener.onAdClosed();
                }
            }
        };
        InterstitialAd.InterstitialAdLoadConfigBuilder interstitialAdLoadConfigBuilder = this.mFacebookInterstitial.buildLoadAdConfig().withAdListener(interstitialAdListener);
        interstitialAdLoadConfigBuilder.withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload);
        this.mFacebookInterstitial.loadAd(interstitialAdLoadConfigBuilder.build());
    }

    public void showAd() {
        if (this.mFacebookInterstitial != null && this.mFacebookInterstitial.isAdLoaded()) {
            this.mFacebookInterstitial.show();
            String msg = "isAdLoaded";
        } else {
            Log.i((String)TAG, (String)"Tried to show a Facebook interstitial ad before it finished loading. Please try again.");
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
            } else {
                Log.i((String)TAG, (String)"Interstitial listener not instantiated. Please load interstitial again.");
            }
            String msg = "noAdLoaded";
        }
    }

    public void clean() {
        super.clean();
        if (this.mFacebookInterstitial != null) {
            this.mFacebookInterstitial.destroy();
            this.mFacebookInterstitial = null;
        }
    }

    public boolean isReady() {
        if (this.mFacebookInterstitial != null) {
            return !this.isAdsTimeOut() && !this.mFacebookInterstitial.isAdInvalidated();
        }
        return false;
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        String placementId = serverExtras.get("placementId");
        return placementId != null && placementId.length() > 0;
    }

    public String getBiddingToken() {
        try {
            return BidderTokenProvider.getBidderToken((Context)GlobalTradPlus.getInstance().getContext());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

