/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSettings;
import com.facebook.ads.BidderTokenProvider;
import com.facebook.ads.NativeAd;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdListener;
import com.facebook.ads.NativeAdView;
import com.facebook.ads.NativeBannerAd;
import com.facebook.ads.NativeBannerAdView;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.facebook.FacebookErrorUtil;
import com.tradplus.ads.facebook.FacebookInitializeHelper;
import com.tradplus.ads.facebook.FacebookNativeAd;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.lang.ref.WeakReference;
import java.util.Map;

public class FacebookNative
extends TPNativeAdapter {
    private NativeAd mFacebookNative;
    private FacebookNativeAd mFacebookNativeAd;
    private NativeBannerAd mNativeBannerAd;
    private WeakReference<Context> mContextWeakReference;
    private String payload;
    private String placementId;
    private String mAdSize;
    private String template;
    private String secType;
    private boolean mNeedDownloadImg = false;
    private int mIsTemplateRending;
    private int mAdWidth;
    private int mAdHeight;
    private static final String TAG = "FacebookNative";
    NativeAdListener nativeAdListener = new NativeAdListener(){

        public void onError(Ad ad, AdError adError) {
            Log.i((String)FacebookNative.TAG, (String)("onError: ErrorCode : " + adError.getErrorCode() + ", ErrorMessage : " + adError.getErrorMessage()));
            if (FacebookNative.this.mLoadAdapterListener != null) {
                FacebookNative.this.mLoadAdapterListener.loadAdapterLoadFailed(FacebookErrorUtil.getTradPlusErrorCode(adError));
            }
        }

        public void onAdLoaded(Ad ad) {
            if (FacebookNative.this.mIsTemplateRending == 1) {
                if (FacebookNative.this.mContextWeakReference.get() != null) {
                    if (!FacebookNative.this.secType.equals("2")) {
                        FacebookNative.this.AdLoadedTemplateNative();
                    } else {
                        FacebookNative.this.AdLoadedTemplateNativeBanner();
                    }
                } else if (FacebookNative.this.mLoadAdapterListener != null) {
                    FacebookNative.this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Unspecified error."));
                }
            } else if (FacebookNative.this.mContextWeakReference.get() != null) {
                if (!FacebookNative.this.secType.equals("2")) {
                    FacebookNative.this.AdLoadedNative();
                } else {
                    FacebookNative.this.AdLoadedNativeBanner();
                }
            } else if (FacebookNative.this.mLoadAdapterListener != null) {
                FacebookNative.this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Unspecified error."));
            }
        }

        public void onAdClicked(Ad ad) {
            Log.i((String)FacebookNative.TAG, (String)"onAdClicked: ");
            if (FacebookNative.this.mFacebookNativeAd != null) {
                FacebookNative.this.mFacebookNativeAd.onAdViewClicked();
            }
        }

        public void onLoggingImpression(Ad ad) {
            Log.i((String)FacebookNative.TAG, (String)"onLoggingImpression: ");
            if (FacebookNative.this.mFacebookNativeAd != null) {
                FacebookNative.this.mFacebookNativeAd.onAdViewExpanded();
            }
        }

        public void onMediaDownloaded(Ad ad) {
        }
    };

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        String placementId;
        this.mContextWeakReference = new WeakReference<Context>(context);
        if (this.serverExtrasAreValid(tpParams)) {
            placementId = tpParams.get("placementId");
            this.template = tpParams.get("is_template_rendering");
            this.secType = tpParams.get("sec_ad_type");
            this.payload = tpParams.get("Bidding-Payload");
            if (!TextUtils.isEmpty((CharSequence)this.template)) {
                this.mIsTemplateRending = Integer.parseInt(this.template);
            }
            Log.i((String)TAG, (String)("adsize == " + tpParams.get("ad_size" + placementId)));
            this.mAdSize = tpParams.get("ad_size" + placementId) != null && !tpParams.get("ad_size" + placementId).equals("0") ? tpParams.get("ad_size" + placementId) : "1";
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        if (userParams.size() > 0) {
            String downLoadImg;
            boolean coppa;
            Log.i((String)TAG, (String)("suportGDPR :COPPA:" + userParams.get("COPPA")));
            if (userParams.containsKey("COPPA") && (coppa = ((Boolean)userParams.get("COPPA")).booleanValue())) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Third-party network failed to provide an ad."));
                return;
            }
            if (userParams.containsKey("com_tp_ad_width")) {
                this.mAdWidth = (Integer)userParams.get("com_tp_ad_width");
            }
            if (userParams.containsKey("com_tp_ad_height")) {
                this.mAdHeight = (Integer)userParams.get("com_tp_ad_height");
            }
            Log.i((String)TAG, (String)("Width :" + this.mAdWidth + ", Height :" + this.mAdHeight));
            if (userParams.containsKey("need_down_load_img") && (downLoadImg = (String)userParams.get("need_down_load_img")).equals("true")) {
                this.mNeedDownloadImg = true;
            }
            if (this.mAdHeight == 0 || this.mAdWidth == 0) {
                this.mAdHeight = 320;
                this.mAdWidth = 340;
            }
        }
        FacebookInitializeHelper.initialize(context);
        if (this.mIsTemplateRending == 1) {
            if (this.secType == null || !this.secType.equals("2")) {
                this.loadNativeTemplateAd(context, placementId);
            } else {
                this.loadNativeBannerTemplateAd(context, placementId);
            }
        } else if (this.secType == null || !this.secType.equals("2")) {
            this.loadNativeAd(context, placementId);
        } else {
            this.loadNativeBannerAd(context, placementId);
        }
    }

    private void loadNativeBannerTemplateAd(Context context, String placementId) {
        Log.i((String)TAG, (String)"loadNativeBannerTemplateAd: ");
        this.mNativeBannerAd = new NativeBannerAd(context, placementId);
        this.mNativeBannerAd.loadAd(this.mNativeBannerAd.buildLoadAdConfig().withAdListener(this.nativeAdListener).withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload).build());
    }

    private void loadNativeTemplateAd(Context context, String placementId) {
        Log.i((String)TAG, (String)"loadNativeTemplateAd: ");
        this.mFacebookNative = new NativeAd(context, placementId);
        this.mFacebookNative.loadAd(this.mFacebookNative.buildLoadAdConfig().withAdListener(this.nativeAdListener).withMediaCacheFlag(NativeAdBase.MediaCacheFlag.ALL).withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload).build());
    }

    private void loadNativeBannerAd(Context context, String placementId) {
        this.mNativeBannerAd = new NativeBannerAd(context, placementId);
        this.mNativeBannerAd.loadAd(this.mNativeBannerAd.buildLoadAdConfig().withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload).withMediaCacheFlag(NativeAdBase.MediaCacheFlag.ALL).withAdListener(this.nativeAdListener).build());
    }

    private void loadNativeAd(Context context, String placementId) {
        this.mFacebookNative = new NativeAd(context, placementId);
        this.mFacebookNative.loadAd(this.mFacebookNative.buildLoadAdConfig().withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload).withAdListener(this.nativeAdListener).build());
    }

    private void AdLoadedNativeBanner() {
        if (this.mNativeBannerAd != null) {
            this.mNativeBannerAd.unregisterView();
            this.mFacebookNativeAd = new FacebookNativeAd((Context)this.mContextWeakReference.get(), this.mNativeBannerAd);
            if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)this.mFacebookNativeAd);
            }
        } else if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Unspecified error."));
        }
    }

    private void AdLoadedNative() {
        if (this.mFacebookNative != null) {
            this.mFacebookNative.unregisterView();
            this.mFacebookNativeAd = new FacebookNativeAd((Context)this.mContextWeakReference.get(), this.mFacebookNative);
            this.downloadAndCallback(this.mFacebookNativeAd, this.mNeedDownloadImg);
        } else if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Unspecified error."));
        }
    }

    private void AdLoadedTemplateNativeBanner() {
        if (this.mNativeBannerAd != null) {
            Activity activity = GlobalTradPlus.getInstance().getActivity();
            if (activity != null && this.mNativeBannerAd != null && this.mNativeBannerAd.isAdLoaded() && !this.mNativeBannerAd.isAdInvalidated()) {
                Log.i((String)TAG, (String)"TemplateNativeBannerAdLoaded: ");
                View adView = NativeBannerAdView.render((Context)activity, (NativeBannerAd)this.mNativeBannerAd, (NativeBannerAdView.Type)this.calculateAdSize(this.mAdSize));
                this.mFacebookNativeAd = new FacebookNativeAd(adView, 1);
                if (this.mLoadAdapterListener != null) {
                    this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)this.mFacebookNativeAd);
                }
            } else if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Unspecified error."));
            }
        } else if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Unspecified error."));
        }
    }

    private void AdLoadedTemplateNative() {
        if (this.mFacebookNative != null) {
            Log.i((String)TAG, (String)"TemplateNativeAdLoaded: ");
            View adView = NativeAdView.render((Context)((Context)this.mContextWeakReference.get()), (NativeAd)this.mFacebookNative);
            if (this.mAdWidth != 0 && this.mAdHeight != 0) {
                RelativeLayout relativeLayout = new RelativeLayout((Context)this.mContextWeakReference.get());
                relativeLayout.addView(adView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(DeviceUtils.dip2px((Context)((Context)this.mContextWeakReference.get()), (float)this.mAdWidth), DeviceUtils.dip2px((Context)((Context)this.mContextWeakReference.get()), (float)this.mAdHeight)));
                relativeLayout.setGravity(17);
                this.mFacebookNativeAd = new FacebookNativeAd((View)relativeLayout, 1);
            } else {
                this.mFacebookNativeAd = new FacebookNativeAd(adView, 1);
            }
            if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)this.mFacebookNativeAd);
            }
        } else if (this.mLoadAdapterListener != null) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Unspecified error."));
        }
    }

    public void clean() {
        AdSettings.clearTestDevices();
        if (this.mFacebookNativeAd != null) {
            this.mFacebookNativeAd.clean();
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("1");
    }

    public String getNetworkVersion() {
        return "6.5.1";
    }

    private NativeBannerAdView.Type calculateAdSize(String adSize) {
        if (adSize.equals("1")) {
            return NativeBannerAdView.Type.HEIGHT_50;
        }
        if (adSize.equals("2")) {
            return NativeBannerAdView.Type.HEIGHT_100;
        }
        if (adSize.equals("3")) {
            return NativeBannerAdView.Type.HEIGHT_120;
        }
        return NativeBannerAdView.Type.HEIGHT_50;
    }

    private boolean serverExtrasAreValid(Map<String, String> serverExtras) {
        String placementId = serverExtras.get("placementId");
        return placementId != null && placementId.length() > 0;
    }

    public String getBiddingToken() {
        try {
            return BidderTokenProvider.getBidderToken((Context)GlobalTradPlus.getInstance().getContext());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

