/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.BidderTokenProvider;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.banner.TPBannerAdImpl;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.common.util.Views;
import com.tradplus.ads.facebook.FacebookErrorUtil;
import com.tradplus.ads.facebook.FacebookInitializeHelper;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class FacebookBanner
extends TPBannerAdapter {
    private AdView mFacebookBanner;
    private String mAdSize;
    private String placementId;
    private TPBannerAdImpl mTpBannerAd;
    private String payload;
    private static final String TAG = "FacebookBanner";

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.serverExtrasAreValid(tpParams)) {
            this.placementId = tpParams.get("placementId");
            Log.d((String)TAG, (String)("adsize:" + tpParams.get("ad_size" + this.placementId)));
            this.mAdSize = tpParams.get("ad_size" + this.placementId) != null && !tpParams.get("ad_size" + this.placementId).equals("0") ? tpParams.get("ad_size" + this.placementId) : "1";
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        this.payload = tpParams.get("Bidding-Payload");
        if (userParams.size() > 0) {
            boolean coppa;
            Log.i((String)TAG, (String)("suportGDPR ccpa: " + userParams.get("CCPA") + ":COPPA:" + userParams.get("COPPA")));
            if (userParams.containsKey("CCPA")) {
                boolean cppa = (Boolean)userParams.get("CCPA");
                if (cppa) {
                    AdSettings.setDataProcessingOptions((String[])new String[0]);
                } else {
                    AdSettings.setDataProcessingOptions((String[])new String[]{"LDU"}, (int)1, (int)1000);
                }
            } else {
                AdSettings.setDataProcessingOptions((String[])new String[]{"LDU"}, (int)0, (int)0);
            }
            if (userParams.containsKey("COPPA") && (coppa = ((Boolean)userParams.get("COPPA")).booleanValue())) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.NETWORK_NO_FILL);
                return;
            }
        }
        FacebookInitializeHelper.initialize(context);
        this.mFacebookBanner = new AdView(context, this.placementId, this.calculateAdSize(this.mAdSize));
        AdListener adListener = new AdListener(){

            public void onError(Ad ad, AdError adError) {
                Log.i((String)FacebookBanner.TAG, (String)("Facebook banner ad load failed  , ErrorCode : " + adError.getErrorCode() + ", ErrorMessage : " + adError.getErrorMessage()));
                if (FacebookBanner.this.mLoadAdapterListener != null) {
                    FacebookBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(FacebookErrorUtil.getTradPlusErrorCode(adError));
                }
            }

            public void onAdLoaded(Ad ad) {
                if (FacebookBanner.this.mFacebookBanner == null) {
                    return;
                }
                Log.i((String)FacebookBanner.TAG, (String)"onAdLoaded: ");
                FacebookBanner.this.mTpBannerAd = new TPBannerAdImpl(null, (View)FacebookBanner.this.mFacebookBanner);
                FacebookBanner.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)FacebookBanner.this.mTpBannerAd);
            }

            public void onAdClicked(Ad ad) {
                Log.i((String)FacebookBanner.TAG, (String)"onAdClicked: ");
                if (FacebookBanner.this.mTpBannerAd != null) {
                    FacebookBanner.this.mTpBannerAd.adClicked();
                }
            }

            public void onLoggingImpression(Ad ad) {
                Log.i((String)FacebookBanner.TAG, (String)"onLoggingImpression: ");
                if (FacebookBanner.this.mTpBannerAd != null) {
                    FacebookBanner.this.mTpBannerAd.adShown();
                }
            }
        };
        this.mFacebookBanner.loadAd(this.mFacebookBanner.buildLoadAdConfig().withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload).withAdListener(adListener).build());
    }

    public void clean() {
        Log.i((String)TAG, (String)"clean: ");
        if (this.mFacebookBanner != null) {
            Views.removeFromParent((View)this.mFacebookBanner);
            this.mFacebookBanner.destroy();
            this.mFacebookBanner = null;
        }
    }

    public String getNetworkVersion() {
        return "6.5.1";
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("1");
    }

    private boolean serverExtrasAreValid(Map<String, String> serverExtras) {
        String placementId = serverExtras.get("placementId");
        return placementId != null && placementId.length() > 0;
    }

    private AdSize calculateAdSize(String adSize) {
        if (adSize.equals("1")) {
            return AdSize.BANNER_HEIGHT_50;
        }
        if (adSize.equals("2")) {
            return AdSize.BANNER_HEIGHT_90;
        }
        if (adSize.equals("3")) {
            return AdSize.RECTANGLE_HEIGHT_250;
        }
        return AdSize.BANNER_HEIGHT_50;
    }

    public String getBiddingToken() {
        try {
            return BidderTokenProvider.getBidderToken((Context)GlobalTradPlus.getInstance().getContext());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

