/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.facebook.ads.AdOptionsView;
import com.facebook.ads.MediaView;
import com.facebook.ads.NativeAd;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdLayout;
import com.facebook.ads.NativeBannerAd;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdView;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPImageLoader;
import com.tradplus.ads.common.util.DeviceUtils;
import java.util.ArrayList;
import java.util.List;

public class FacebookNativeAd
extends TPBaseAd {
    private static final String TAG = "FacebookNative";
    private NativeAd mFacebookNative;
    private TPNativeAdView mNativeAdView;
    private NativeAdLayout mContainer;
    private NativeBannerAd mFacebookNativeBanner;
    private AdOptionsView adOptionsView;
    private String mAdSize;
    private Context mContext;

    public FacebookNativeAd(Context context, NativeAd facebookNative) {
        this.mFacebookNative = facebookNative;
        this.initNativeAd(context);
    }

    public FacebookNativeAd(Context context, NativeBannerAd facebookNative, String adSize) {
        this.mFacebookNativeBanner = facebookNative;
        this.mContext = context;
        this.mAdSize = adSize;
        this.initNativeBannerAd(context);
    }

    private void initNativeAd(Context context) {
        this.mNativeAdView = new TPNativeAdView();
        this.mContainer = new NativeAdLayout(context);
        MediaView nativeAdMedia = new MediaView(context);
        this.adOptionsView = new AdOptionsView(context, (NativeAdBase)this.mFacebookNative, this.mContainer);
        this.mNativeAdView.setCallToAction(this.mFacebookNative.getAdCallToAction());
        this.mNativeAdView.setTitle(this.mFacebookNative.getAdHeadline());
        this.mNativeAdView.setSubTitle(this.mFacebookNative.getAdBodyText());
        this.mNativeAdView.setAdSource(this.mFacebookNative.getSponsoredTranslation());
        this.mNativeAdView.setIconImageUrl(this.mFacebookNative.getAdIcon().getUrl());
        this.mNativeAdView.setMediaView((View)nativeAdMedia);
    }

    public ArrayList<String> getDownloadImgUrls() {
        this.downloadImgUrls.clear();
        this.downloadImgUrls.add(this.mNativeAdView.getIconImageUrl());
        return super.getDownloadImgUrls();
    }

    private void initNativeBannerAd(Context context) {
        this.mNativeAdView = new TPNativeAdView();
        this.mContainer = new NativeAdLayout(context);
        this.adOptionsView = new AdOptionsView(context, (NativeAdBase)this.mFacebookNativeBanner, this.mContainer);
        this.mNativeAdView.setCallToAction(this.mFacebookNativeBanner.getAdCallToAction());
        this.mNativeAdView.setTitle(this.mFacebookNativeBanner.getAdHeadline());
        this.mNativeAdView.setSubTitle(this.mFacebookNativeBanner.getAdBodyText());
        this.mNativeAdView.setAdSource(this.mFacebookNativeBanner.getSponsoredTranslation());
        this.mNativeAdView.setIconImageUrl(this.mFacebookNativeBanner.getAdIcon().getUrl());
        TPImageLoader.getInstance().loadImage(null, this.mFacebookNativeBanner.getAdIcon().getUrl());
    }

    public void onAdViewClicked() {
        if (this.mShowListener != null) {
            this.mShowListener.onAdClicked();
        }
    }

    public void onAdViewExpanded() {
        if (this.mShowListener != null) {
            this.mShowListener.onAdShown();
        }
    }

    public Object getNetworkObj() {
        return this.mFacebookNative == null ? this.mFacebookNativeBanner : this.mFacebookNative;
    }

    public void registerClickView(ViewGroup viewGroup, ArrayList<View> clickViews) {
        if (this.mFacebookNativeBanner != null) {
            View iconView = viewGroup.findViewWithTag((Object)"tp_icon");
            View callToAction = viewGroup.findViewWithTag((Object)"tp_action");
            FrameLayout adChoicesView = (FrameLayout)viewGroup.findViewWithTag((Object)"tp_adchoices");
            if (adChoicesView != null && this.adOptionsView != null) {
                adChoicesView.removeAllViews();
                adChoicesView.addView((View)this.adOptionsView, 0);
            }
            if (iconView instanceof ImageView) {
                if (this.mAdSize.equals("2")) {
                    ViewGroup.LayoutParams clp = iconView.getLayoutParams();
                    clp.width = DeviceUtils.dip2px((Context)this.mContext, (float)100.0f);
                    clp.height = DeviceUtils.dip2px((Context)this.mContext, (float)100.0f);
                    iconView.setLayoutParams(clp);
                    ViewGroup.LayoutParams layoutParams = callToAction.getLayoutParams();
                    layoutParams.width = DeviceUtils.dip2px((Context)this.mContext, (float)100.0f);
                    layoutParams.height = DeviceUtils.dip2px((Context)this.mContext, (float)100.0f);
                    callToAction.setLayoutParams(layoutParams);
                } else if (this.mAdSize.equals("3")) {
                    ViewGroup.LayoutParams clp = iconView.getLayoutParams();
                    clp.width = DeviceUtils.dip2px((Context)this.mContext, (float)120.0f);
                    clp.height = DeviceUtils.dip2px((Context)this.mContext, (float)120.0f);
                    iconView.setLayoutParams(clp);
                    ViewGroup.LayoutParams layoutParams = callToAction.getLayoutParams();
                    layoutParams.width = DeviceUtils.dip2px((Context)this.mContext, (float)120.0f);
                    layoutParams.height = DeviceUtils.dip2px((Context)this.mContext, (float)120.0f);
                    callToAction.setLayoutParams(layoutParams);
                }
                this.mFacebookNativeBanner.registerViewForInteraction((View)viewGroup, (ImageView)iconView, clickViews);
            }
            return;
        }
        if (this.mFacebookNative != null) {
            FrameLayout adChoicesView;
            View iconView = viewGroup.findViewWithTag((Object)"tp_icon");
            if (this.mNativeAdView != null && this.mNativeAdView.getMediaView() instanceof MediaView && iconView instanceof ImageView) {
                this.mFacebookNative.registerViewForInteraction((View)viewGroup, (MediaView)this.mNativeAdView.getMediaView(), (ImageView)iconView, clickViews);
            }
            if ((adChoicesView = (FrameLayout)viewGroup.findViewWithTag((Object)"tp_adchoices")) != null && this.adOptionsView != null) {
                adChoicesView.removeAllViews();
                adChoicesView.addView((View)this.adOptionsView, 0);
            }
        }
    }

    public TPNativeAdView getTPNativeView() {
        return this.mNativeAdView;
    }

    public int getNativeAdType() {
        return 0;
    }

    public View getRenderView() {
        return null;
    }

    public List<View> getMediaViews() {
        return null;
    }

    public ViewGroup getCustomAdContainer() {
        return this.mContainer;
    }

    public void clean() {
        if (this.mFacebookNative != null) {
            this.mFacebookNative.unregisterView();
            this.mFacebookNative.destroy();
            this.mFacebookNative = null;
        }
        if (this.mFacebookNativeBanner != null) {
            this.mFacebookNativeBanner.unregisterView();
            this.mFacebookNativeBanner.destroy();
            this.mFacebookNativeBanner = null;
        }
        this.mNativeAdView = null;
        this.mContainer = null;
    }
}

