/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.admanager.AdManagerInterstitialAd;
import com.google.android.gms.ads.admanager.AdManagerInterstitialAdLoadCallback;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.google.AdManagerInit;
import java.util.Map;

public class AdManagerInterstital
extends TPInterstitialAdapter {
    private String placementId;
    private AdManagerAdRequest request;
    private AdManagerInterstitialAd mAdManagerInterstitialAd;
    private Integer mVideoMute = 0;
    private String name;
    private static final String TAG = "GAMInterstital";

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (tpParams == null || tpParams.size() <= 0) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.placementId = tpParams.get("placementId");
        this.name = tpParams.get("name");
        if (userParams != null && userParams.size() > 0 && userParams.containsKey("video_admob_mute")) {
            this.mVideoMute = (int)((Integer)userParams.get("video_admob_mute"));
        }
        this.request = AdManagerInit.getInstance().getAdmobAdRequest(userParams, null, null);
        AdManagerInit.getInstance().initSDK(context, (AdRequest)this.request, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                if (AdManagerInterstital.this.mVideoMute != 0) {
                    MobileAds.setAppMuted((AdManagerInterstital.this.mVideoMute == 1 ? 1 : 0) != 0);
                }
                AdManagerInterstital.this.requestInterstitial(context);
            }

            public void onFailed(String code, String msg) {
                if (AdManagerInterstital.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    AdManagerInterstital.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestInterstitial(Context context) {
        AdManagerInterstitialAd.load((Context)context, (String)this.placementId, (AdManagerAdRequest)this.request, (AdManagerInterstitialAdLoadCallback)new AdManagerInterstitialAdLoadCallback(){

            public void onAdLoaded(@NonNull AdManagerInterstitialAd interstitialAd) {
                Log.i((String)AdManagerInterstital.TAG, (String)"onAdLoaded");
                AdManagerInterstital.this.mAdManagerInterstitialAd = interstitialAd;
                AdManagerInterstital.this.setFirstLoadedTime();
                if (AdManagerInterstital.this.mLoadAdapterListener != null) {
                    AdManagerInterstital.this.setNetworkObjectAd(interstitialAd);
                    AdManagerInterstital.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                Log.i((String)AdManagerInterstital.TAG, (String)("onAdFailedToLoad: code: " + loadAdError.getCode() + " ,msg:" + loadAdError.getMessage()));
                AdManagerInterstital.this.mAdManagerInterstitialAd = null;
                TPError tpError = new TPError("Third-party network failed to provide an ad.");
                tpError.setErrorMessage(loadAdError.getMessage());
                tpError.setErrorCode(loadAdError.getCode() + "");
                if (AdManagerInterstital.this.mLoadAdapterListener != null) {
                    AdManagerInterstital.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    public void showAd() {
        Activity activity = GlobalTradPlus.getInstance().getActivity();
        if (activity == null) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
            return;
        }
        if (this.mAdManagerInterstitialAd == null) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Unspecified error."));
            }
            return;
        }
        this.mAdManagerInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

            public void onAdDismissedFullScreenContent() {
                Log.i((String)AdManagerInterstital.TAG, (String)"onAdDismissedFullScreenContent: ");
                if (AdManagerInterstital.this.mShowListener != null) {
                    AdManagerInterstital.this.mShowListener.onAdClosed();
                }
            }

            public void onAdFailedToShowFullScreenContent(AdError adError) {
                Log.i((String)AdManagerInterstital.TAG, (String)("onAdFailedToShowFullScreenContent: code :" + adError.getCode() + ", msg :" + adError.getMessage()));
                if (AdManagerInterstital.this.mShowListener != null) {
                    TPError tpError = new TPError("Didn't find valid adv.Show Failed");
                    tpError.setErrorCode(adError.getCode() + "");
                    tpError.setErrorMessage(adError.getMessage());
                    AdManagerInterstital.this.mShowListener.onAdVideoError(tpError);
                }
            }

            public void onAdShowedFullScreenContent() {
                AdManagerInterstital.this.mAdManagerInterstitialAd = null;
                Log.i((String)AdManagerInterstital.TAG, (String)"onAdShowedFullScreenContent: ");
                if (AdManagerInterstital.this.mShowListener != null) {
                    AdManagerInterstital.this.mShowListener.onAdShown();
                }
            }

            public void onAdClicked() {
                Log.i((String)AdManagerInterstital.TAG, (String)"onAdClicked: ");
                if (AdManagerInterstital.this.mShowListener != null) {
                    AdManagerInterstital.this.mShowListener.onAdVideoClicked();
                }
            }
        });
        this.mAdManagerInterstitialAd.show(activity);
    }

    public void clean() {
        if (this.mAdManagerInterstitialAd != null) {
            this.mAdManagerInterstitialAd.setFullScreenContentCallback(null);
            this.mAdManagerInterstitialAd = null;
        }
    }

    public boolean isReady() {
        return !this.isAdsTimeOut();
    }

    public String getNetworkName() {
        return this.name;
    }

    public String getNetworkVersion() {
        VersionInfo version = MobileAds.getVersion();
        int majorVersion = version.getMajorVersion();
        int minorVersion = version.getMinorVersion();
        int microVersion = version.getMicroVersion();
        return majorVersion + "." + minorVersion + "." + microVersion + "";
    }
}

