/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.util.TestDeviceUtil;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AdManagerInit
extends TPInitMediation {
    private static final String TAG = "GAM";
    private static AdManagerInit sInstance;
    private String name;

    public static synchronized AdManagerInit getInstance() {
        if (sInstance == null) {
            sInstance = new AdManagerInit();
        }
        return sInstance;
    }

    public void initSDK(Context context, AdRequest request, Map<String, Object> userParams, Map<String, String> tpParams, TPInitMediation.InitCallback initCallback) {
        final String customAs = RequestUtils.getInstance().getCustomAs("2");
        this.removeInited(customAs);
        this.suportGDPR(context, userParams);
        if (AdManagerInit.isInited((String)customAs)) {
            initCallback.onSuccess();
            return;
        }
        if (this.hasInit(customAs, initCallback)) {
            return;
        }
        this.setTestDevice(request, context);
        MobileAds.disableMediationAdapterInitialization((Context)context);
        String isInitNoCallBack = "1";
        if (tpParams != null && tpParams.size() > 0) {
            this.name = tpParams.get("name");
            if (tpParams.containsKey("init_no_callback")) {
                isInitNoCallBack = tpParams.get("init_no_callback");
            }
        }
        Log.d((String)"InitNetworkSDK", (String)"initSDK: ");
        Log.i((String)TAG, (String)("isInitNoCallBack: " + isInitNoCallBack));
        if ("0".equals(isInitNoCallBack)) {
            MobileAds.initialize((Context)context, (OnInitializationCompleteListener)new OnInitializationCompleteListener(){

                public void onInitializationComplete(InitializationStatus initializationStatus) {
                    AdapterStatus.State state;
                    AdapterStatus status = (AdapterStatus)initializationStatus.getAdapterStatusMap().get("com.google.android.gms.ads.MobileAds");
                    AdapterStatus.State state2 = state = status != null ? status.getInitializationState() : null;
                    if (state == AdapterStatus.State.READY) {
                        Log.i((String)AdManagerInit.TAG, (String)"onInitializationComplete: ");
                        AdManagerInit.this.sendResult(customAs, true);
                    } else {
                        AdManagerInit.this.sendResult(customAs, false, "", "NOT READY");
                    }
                }
            });
        } else {
            MobileAds.initialize((Context)context);
            this.sendResult(customAs, true);
        }
    }

    public void setTestDevice(AdRequest request, Context context) {
        if (TestDeviceUtil.getInstance().isNeedTestDevice()) {
            String admobTestDevice = TestDeviceUtil.getInstance().getAdmobTestDevice();
            if (!TextUtils.isEmpty((CharSequence)admobTestDevice)) {
                List<String> testDeviceIds = Arrays.asList(admobTestDevice);
                RequestConfiguration configuration = new RequestConfiguration.Builder().setTestDeviceIds(testDeviceIds).build();
                MobileAds.setRequestConfiguration((RequestConfiguration)configuration);
            }
            boolean testDevice = request.isTestDevice(context);
            Log.i((String)TAG, (String)("isTestDevice  : " + testDevice));
        }
    }

    public void initSDK(Context context, Map<String, Object> userParams, Map<String, String> tpParams, TPInitMediation.InitCallback initCallback) {
        this.initSDK(context, (AdRequest)this.getAdmobAdRequest(userParams, tpParams, null, null), userParams, tpParams, initCallback);
    }

    public AdManagerAdRequest getAdmobAdRequest(Map<String, Object> userParams, Map<String, String> tpParams, String contentUrls, ArrayList<String> neighboringUrls) {
        Boolean userConsent;
        String mdn = "tradplus";
        String collapsible = "";
        if (tpParams != null && tpParams.size() > 0) {
            if (tpParams.containsKey("mdn")) {
                mdn = tpParams.get("mdn");
            }
            if (tpParams.containsKey("collapsible")) {
                collapsible = tpParams.get("collapsible");
                Log.i((String)TAG, (String)("collapsible: " + collapsible));
            }
        }
        if (userParams == null || userParams.size() <= 0) {
            return ((AdManagerAdRequest.Builder)new AdManagerAdRequest.Builder().setRequestAgent(mdn)).build();
        }
        Bundle networkExtrasBundle = new Bundle();
        boolean openPersonalizedAd = GlobalTradPlus.getInstance().isOpenPersonalizedAd();
        if (!openPersonalizedAd) {
            networkExtrasBundle.putString("npa", "1");
        }
        Log.i((String)"PersonalizeEnable", (String)("GAM openPersonalizedAd \u4e2a\u6027\u5316\u5f00\u5173: " + openPersonalizedAd));
        if (userParams.containsKey("CCPA")) {
            boolean ccpa = (Boolean)userParams.get("CCPA");
            Log.i((String)"privacylaws", (String)("ccpa: " + ccpa));
            if (ccpa) {
                networkExtrasBundle.putInt("rdp", 1);
            }
        }
        if (this.checkGoogleUMP(userParams) && (userConsent = this.updateUserConsent(userParams)) != null && !userConsent.booleanValue()) {
            networkExtrasBundle.putString("npa", "1");
        }
        AdManagerAdRequest.Builder builder = new AdManagerAdRequest.Builder();
        if (!TextUtils.isEmpty((CharSequence)contentUrls)) {
            builder.setContentUrl(contentUrls);
            Log.i((String)TAG, (String)("contentUrls: " + contentUrls));
        } else if (neighboringUrls != null) {
            builder.setNeighboringContentUrls(neighboringUrls);
            Log.i((String)TAG, (String)("neighboringUrls: " + neighboringUrls));
        }
        Log.i((String)TAG, (String)("mdn: " + mdn));
        builder.setRequestAgent(mdn);
        if (!TextUtils.isEmpty((CharSequence)collapsible) && !"0".equals(collapsible)) {
            networkExtrasBundle.putString("collapsible", "1".equals(collapsible) ? "top" : "bottom");
        }
        return ((AdManagerAdRequest.Builder)builder.addNetworkExtrasBundle(AdMobAdapter.class, networkExtrasBundle)).build();
    }

    public void suportGDPR(Context context, Map<String, Object> userParams) {
        if (userParams != null && userParams.size() > 0) {
            RequestConfiguration requestConfiguration = MobileAds.getRequestConfiguration();
            RequestConfiguration.Builder builder = requestConfiguration.toBuilder();
            if (userParams.containsKey("COPPA")) {
                boolean coppa = (Boolean)userParams.get("COPPA");
                Log.i((String)"privacylaws", (String)("coppa: " + coppa));
                builder.setTagForChildDirectedTreatment(coppa ? 1 : 0);
            }
            if (userParams.containsKey("isue")) {
                if (userParams.containsKey("gdpr_child")) {
                    boolean gdprchild = (Boolean)userParams.get("gdpr_child");
                    Log.i((String)"privacylaws", (String)("gdprchild: " + gdprchild));
                    builder.setTagForUnderAgeOfConsent(gdprchild ? 1 : 0);
                } else {
                    builder.setTagForUnderAgeOfConsent(-1);
                }
            }
            if (userParams.containsKey("max_ad_content_rating")) {
                String maxAdContentRating = (String)userParams.get("max_ad_content_rating");
                Log.i((String)"privacylaws", (String)("maxAdContentRating: " + maxAdContentRating));
                if (!TextUtils.isEmpty((CharSequence)maxAdContentRating)) {
                    builder.setMaxAdContentRating(maxAdContentRating);
                }
            }
            builder.build();
            MobileAds.setRequestConfiguration((RequestConfiguration)requestConfiguration);
        }
    }

    private boolean checkGoogleUMP(Map<String, Object> localExtras) {
        if (localExtras.containsKey("IABTCF_TCString")) {
            String consentString = (String)localExtras.get("IABTCF_TCString");
            Log.i((String)"privacylaws", (String)("GAM TCString: " + consentString));
            return TextUtils.isEmpty((CharSequence)consentString);
        }
        return true;
    }

    public String getNetworkVersionCode() {
        VersionInfo version = MobileAds.getVersion();
        int majorVersion = version.getMajorVersion();
        int minorVersion = version.getMinorVersion();
        int microVersion = version.getMicroVersion();
        return majorVersion + "." + minorVersion + "." + microVersion + "";
    }

    public String getNetworkVersionName() {
        return this.name;
    }

    public String getDefaultSPName(Context context) {
        return context.getPackageName() + "_preferences";
    }
}

