/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.admanager.AdManagerInterstitialAd;
import com.google.android.gms.ads.admanager.AdManagerInterstitialAdLoadCallback;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.google.GoogleInitManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AdManagerInterstital
extends TPInterstitialAdapter {
    private Context mCxt;
    private String placementId;
    private AdRequest request;
    private AdManagerInterstitialAd mAdManagerInterstitialAd;
    private static final String TAG = "AdManagerInterstital";

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        this.mCxt = context;
        if (tpParams == null || tpParams.size() <= 0) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.placementId = tpParams.get("placementId");
        this.request = new AdRequest.Builder().build();
        GoogleInitManager.getInstance().initSDK(context, this.request, userParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                AdManagerInterstital.this.requestInterstitial();
            }

            public void onFailed(String code, String msg) {
                if (AdManagerInterstital.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    AdManagerInterstital.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestInterstitial() {
        AdManagerAdRequest adRequest = new AdManagerAdRequest.Builder().build();
        AdManagerInterstitialAd.load((Context)this.mCxt, (String)this.placementId, (AdManagerAdRequest)adRequest, (AdManagerInterstitialAdLoadCallback)new AdManagerInterstitialAdLoadCallback(){

            public void onAdLoaded(@NonNull AdManagerInterstitialAd interstitialAd) {
                Log.i((String)AdManagerInterstital.TAG, (String)"onAdLoaded");
                AdManagerInterstital.this.mAdManagerInterstitialAd = interstitialAd;
                AdManagerInterstital.this.setFirstLoadedTime();
                if (AdManagerInterstital.this.mLoadAdapterListener != null) {
                    AdManagerInterstital.this.mLoadAdapterListener.loadAdapterLoaded(null);
                }
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                Log.i((String)AdManagerInterstital.TAG, (String)("onAdFailedToLoad: code: " + loadAdError.getCode() + " ,msg:" + loadAdError.getMessage()));
                AdManagerInterstital.this.mAdManagerInterstitialAd = null;
                TPError tpError = new TPError("Third-party network failed to provide an ad.");
                tpError.setErrorMessage(loadAdError.getMessage());
                tpError.setErrorCode(loadAdError.getCode() + "");
                if (AdManagerInterstital.this.mLoadAdapterListener != null) {
                    AdManagerInterstital.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    public void showAd() {
        Activity activity = GlobalTradPlus.getInstance().getActivity();
        if (activity == null) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
            return;
        }
        if (this.mAdManagerInterstitialAd == null) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Unspecified error."));
            }
            return;
        }
        this.mAdManagerInterstitialAd.show(activity);
    }

    public void clean() {
        if (this.mAdManagerInterstitialAd != null) {
            this.mAdManagerInterstitialAd.setFullScreenContentCallback(null);
            this.mAdManagerInterstitialAd = null;
        }
    }

    public boolean isReady() {
        return !this.isAdsTimeOut();
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("2");
    }

    public String getNetworkVersion() {
        return MobileAds.getVersionString();
    }
}

