/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.google.ads.consent.ConsentInformation;
import com.google.ads.consent.ConsentStatus;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.mobileads.util.TestDeviceUtil;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class GoogleInitManager
extends TPInitMediation {
    private static final String TAG = "Admob";
    private static GoogleInitManager sInstance;
    private AdRequest mAdRequest;

    public static synchronized GoogleInitManager getInstance() {
        if (sInstance == null) {
            sInstance = new GoogleInitManager();
        }
        return sInstance;
    }

    public void initSDK(Context context, AdRequest request, Map<String, Object> userParams, TPInitMediation.InitCallback initCallback) {
        this.mAdRequest = request;
        final String customAs = RequestUtils.getInstance().getCustomAs("2");
        if (this.isInited(customAs)) {
            initCallback.onSuccess();
            return;
        }
        if (this.hasInit(customAs, initCallback)) {
            return;
        }
        this.suportGDPR(context, userParams);
        this.setTestDevice(request, context);
        MobileAds.disableMediationAdapterInitialization((Context)context);
        Log.d((String)"InitNetworkSDK", (String)"initSDK: ");
        MobileAds.initialize((Context)context, (OnInitializationCompleteListener)new OnInitializationCompleteListener(){

            public void onInitializationComplete(InitializationStatus initializationStatus) {
                AdapterStatus.State state;
                AdapterStatus status = (AdapterStatus)initializationStatus.getAdapterStatusMap().get("com.google.android.gms.ads.MobileAds");
                AdapterStatus.State state2 = state = status != null ? status.getInitializationState() : null;
                if (state == AdapterStatus.State.READY) {
                    Log.i((String)GoogleInitManager.TAG, (String)"onInitializationComplete: ");
                    GoogleInitManager.this.sendResult(customAs, true);
                } else {
                    GoogleInitManager.this.sendResult(customAs, false, "", "NOT READY");
                }
            }
        });
    }

    public void setTestDevice(AdRequest request, Context context) {
        if (TestDeviceUtil.getInstance().isNeedTestDevice()) {
            String admobTestDevice = TestDeviceUtil.getInstance().getAdmobTestDevice();
            if (!TextUtils.isEmpty((CharSequence)admobTestDevice)) {
                List<String> testDeviceIds = Arrays.asList(admobTestDevice);
                RequestConfiguration configuration = new RequestConfiguration.Builder().setTestDeviceIds(testDeviceIds).build();
                MobileAds.setRequestConfiguration((RequestConfiguration)configuration);
            }
            boolean testDevice = request.isTestDevice(context);
            Log.i((String)TAG, (String)("isTestDevice  : " + testDevice));
        }
    }

    public void initSDK(Context context, Map<String, Object> userParams, Map<String, String> tpParams, TPInitMediation.InitCallback initCallback) {
    }

    public void suportGDPR(Context context, Map<String, Object> userParams) {
        if (userParams != null && userParams.size() > 0 && userParams.containsKey("CCPA")) {
            boolean ccpa = (Boolean)userParams.get("CCPA");
            Log.i((String)TAG, (String)("ccpa: " + ccpa));
            if (ccpa) {
                Bundle networkExtrasBundle = new Bundle();
                networkExtrasBundle.putInt("rdp", 1);
                this.mAdRequest = new AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter.class, networkExtrasBundle).build();
            }
        }
        if (userParams != null && userParams.size() > 0) {
            if (userParams.containsKey("gdpr_consent") && userParams.containsKey("isue")) {
                boolean need_set_gdpr = false;
                int consent = (Integer)userParams.get("gdpr_consent");
                if (consent == 0) {
                    need_set_gdpr = true;
                }
                boolean isEu = (Boolean)userParams.get("isue");
                Log.i((String)"gdpr", (String)("suportGDPR: " + need_set_gdpr + ":isUe:" + isEu));
                ConsentInformation.getInstance((Context)context).setConsentStatus(need_set_gdpr ? ConsentStatus.PERSONALIZED : ConsentStatus.NON_PERSONALIZED);
            }
            Log.i((String)TAG, (String)("suportGDPR gdpr_child: " + userParams.get("gdpr_child") + ":COPPA:" + userParams.get("COPPA")));
            boolean gdpr_child = (Boolean)userParams.get("gdpr_child");
            ConsentInformation.getInstance((Context)context).setTagForUnderAgeOfConsent(gdpr_child);
            if (userParams.containsKey("COPPA")) {
                boolean coppa = (Boolean)userParams.get("COPPA");
                RequestConfiguration requestConfiguration = MobileAds.getRequestConfiguration().toBuilder().setTagForChildDirectedTreatment(coppa ? 1 : 0).build();
                MobileAds.setRequestConfiguration((RequestConfiguration)requestConfiguration);
            }
        }
    }
}

