/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.gms.ads.rewarded.ServerSideVerificationOptions;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAd;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAdLoadCallback;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.google.GoogleErrorUtil;
import com.tradplus.ads.google.GoogleInitManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.lang.ref.WeakReference;
import java.util.Map;

public class GooglePlayServicesInterstitialVideo
extends TPRewardAdapter {
    private RewardedAd mRewardedAd;
    private RewardedInterstitialAd rewardedInterstitialAd;
    private WeakReference<Context> contextWeakReference;
    private int isRewardedInterstitialAd;
    private String mAdUnitId;
    private String customData;
    private String userid;
    private AdRequest request;
    private Context mContext;
    private static final String TAG = "AdmobRewardedVideo";
    private final RewardedInterstitialAdLoadCallback mRewardedInterstitialAdLoadCallback = new RewardedInterstitialAdLoadCallback(){

        public void onAdLoaded(RewardedInterstitialAd ad) {
            GooglePlayServicesInterstitialVideo.this.rewardedInterstitialAd = ad;
            Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)"onAdLoaded");
            if (GooglePlayServicesInterstitialVideo.this.contextWeakReference.get() != null && GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener != null) {
                GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
            GooglePlayServicesInterstitialVideo.this.rewardedInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                public void onAdFailedToShowFullScreenContent(AdError adError) {
                    Log.d((String)GooglePlayServicesInterstitialVideo.TAG, (String)("onAdFailedToShowFullScreenContent, code : " + adError.getCode() + " , msg: " + adError.getMessage()));
                    if (GooglePlayServicesInterstitialVideo.this.contextWeakReference.get() != null && GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                        GooglePlayServicesInterstitialVideo.this.mShowListener.onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
                    }
                }

                public void onAdShowedFullScreenContent() {
                    Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)"onAdShowedFullScreenContent");
                    if (GooglePlayServicesInterstitialVideo.this.contextWeakReference.get() != null && GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                        GooglePlayServicesInterstitialVideo.this.mShowListener.onAdVideoStart();
                    }
                }

                public void onAdDismissedFullScreenContent() {
                    Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)"onAdDismissedFullScreenContent");
                    if (GooglePlayServicesInterstitialVideo.this.contextWeakReference.get() != null && GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                        GooglePlayServicesInterstitialVideo.this.mShowListener.onAdVideoEnd();
                    }
                }
            });
        }

        public void onAdFailedToLoad(LoadAdError loadAdError) {
            Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)("onAdFailedToLoad: code :" + loadAdError.getCode() + " , msg : " + loadAdError.getMessage()));
            if (GooglePlayServicesInterstitialVideo.this.contextWeakReference.get() != null && GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener != null) {
                GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("Third-party network failed to provide an ad."), loadAdError));
                GooglePlayServicesInterstitialVideo.this.rewardedInterstitialAd = null;
            }
        }
    };
    private final RewardedAdLoadCallback mRewardedAdLoadCallback = new RewardedAdLoadCallback(){

        public void onAdFailedToLoad(LoadAdError loadAdError) {
            Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)("onAdFailedToLoad: code :" + loadAdError.getCode() + " , msg : " + loadAdError.getMessage()));
            if (GooglePlayServicesInterstitialVideo.this.contextWeakReference.get() != null && GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener != null) {
                GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("Third-party network failed to provide an ad."), loadAdError));
                GooglePlayServicesInterstitialVideo.this.mRewardedAd = null;
            }
        }

        public void onAdLoaded(RewardedAd rewardedAd) {
            Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)"onAdLoaded: ");
            GooglePlayServicesInterstitialVideo.this.setFirstLoadedTime();
            GooglePlayServicesInterstitialVideo.this.mRewardedAd = rewardedAd;
            if (GooglePlayServicesInterstitialVideo.this.contextWeakReference.get() != null && GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener != null) {
                GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
            GooglePlayServicesInterstitialVideo.this.mRewardedAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                public void onAdShowedFullScreenContent() {
                    Log.d((String)GooglePlayServicesInterstitialVideo.TAG, (String)"Ad was shown.");
                    if (GooglePlayServicesInterstitialVideo.this.contextWeakReference.get() != null && GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                        GooglePlayServicesInterstitialVideo.this.mShowListener.onAdVideoStart();
                    }
                    GooglePlayServicesInterstitialVideo.this.mRewardedAd = null;
                }

                public void onAdFailedToShowFullScreenContent(AdError adError) {
                    Log.d((String)GooglePlayServicesInterstitialVideo.TAG, (String)("Ad failed to show, code : " + adError.getCode() + " , msg: " + adError.getMessage()));
                    if (GooglePlayServicesInterstitialVideo.this.contextWeakReference.get() != null && GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                        GooglePlayServicesInterstitialVideo.this.mShowListener.onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
                    }
                }

                public void onAdDismissedFullScreenContent() {
                    Log.d((String)GooglePlayServicesInterstitialVideo.TAG, (String)"Ad was dismissed.");
                    if (GooglePlayServicesInterstitialVideo.this.contextWeakReference.get() != null && GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                        GooglePlayServicesInterstitialVideo.this.mShowListener.onAdVideoEnd();
                    }
                }
            });
        }
    };

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        this.contextWeakReference = new WeakReference<Context>(context);
        if (!this.extrasAreValid(tpParams)) {
            if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            }
            return;
        }
        this.mAdUnitId = tpParams.get("placementId");
        this.isRewardedInterstitialAd = Integer.parseInt(tpParams.get("adsource_type"));
        if (userParams != null && userParams.size() > 0) {
            this.customData = (String)userParams.get("custom_data");
            if (TextUtils.isEmpty((CharSequence)this.customData)) {
                this.customData = "";
            }
        }
        if (userParams != null && userParams.size() > 0) {
            this.userid = (String)userParams.get("user_id");
            if (TextUtils.isEmpty((CharSequence)this.userid)) {
                this.userid = "";
            }
        }
        this.request = new AdRequest.Builder().build();
        GoogleInitManager.getInstance().initSDK(context, this.request, userParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                GooglePlayServicesInterstitialVideo.this.requestInterstitialVideo();
            }

            public void onFailed(String code, String msg) {
                if (GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestInterstitialVideo() {
        try {
            if (this.isRewardedInterstitialAd == 2) {
                Log.i((String)TAG, (String)"load RewardedInterstitialAd: \u63d2\u9875\u5f0f\u6fc0\u52b1\u89c6\u9891");
                RewardedInterstitialAd.load((Context)((Context)this.contextWeakReference.get()), (String)this.mAdUnitId, (AdRequest)this.request, (RewardedInterstitialAdLoadCallback)this.mRewardedInterstitialAdLoadCallback);
            } else {
                Log.i((String)TAG, (String)"load RewardedAd: \u6fc0\u52b1\u89c6\u9891");
                RewardedAd.load((Context)((Context)this.contextWeakReference.get()), (String)this.mAdUnitId, (AdRequest)this.request, (RewardedAdLoadCallback)this.mRewardedAdLoadCallback);
            }
        }
        catch (Exception e) {
            Log.i((String)"googleInterstitialVideo", (String)("e: " + e.getLocalizedMessage()));
        }
    }

    public void showAd() {
        Activity activity = GlobalTradPlus.getInstance().getActivity();
        if (activity == null) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
            return;
        }
        if (this.isRewardedInterstitialAd == 2) {
            if (!TextUtils.isEmpty((CharSequence)this.customData) && !TextUtils.isEmpty((CharSequence)this.userid)) {
                Log.i((String)TAG, (String)("RewardData: customData : " + this.customData));
                ServerSideVerificationOptions options = new ServerSideVerificationOptions.Builder().setCustomData(this.customData).setUserId(this.userid).build();
                this.rewardedInterstitialAd.setServerSideVerificationOptions(options);
            }
            Log.i((String)TAG, (String)"show RewardedInterstitialAd: \u63d2\u9875\u5f0f\u6fc0\u52b1\u89c6\u9891");
            this.rewardedInterstitialAd.show(activity, new OnUserEarnedRewardListener(){

                public void onUserEarnedReward(RewardItem rewardItem) {
                    Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)"onUserEarnedReward: ");
                    if (GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                        GooglePlayServicesInterstitialVideo.this.mShowListener.onReward();
                    }
                }
            });
        } else if (this.mRewardedAd != null) {
            if (!TextUtils.isEmpty((CharSequence)this.customData) && !TextUtils.isEmpty((CharSequence)this.userid)) {
                Log.i((String)TAG, (String)("RewardData: customData : " + this.customData));
                ServerSideVerificationOptions options = new ServerSideVerificationOptions.Builder().setCustomData(this.customData).setUserId(this.userid).build();
                this.mRewardedAd.setServerSideVerificationOptions(options);
            }
            Log.i((String)TAG, (String)"show RewardedAd: \u6fc0\u52b1\u89c6\u9891");
            this.mRewardedAd.show(activity, new OnUserEarnedRewardListener(){

                public void onUserEarnedReward(RewardItem rewardItem) {
                    if (GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                        GooglePlayServicesInterstitialVideo.this.mShowListener.onReward();
                    }
                }
            });
        } else {
            Log.d((String)"TAG", (String)"The rewarded ad wasn't loaded yet.");
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
            }
        }
    }

    public boolean isReady() {
        boolean isMainThread;
        if (this.isRewardedInterstitialAd != 2) {
            boolean isMainThread2;
            if (this.mRewardedAd == null) {
                return false;
            }
            boolean bl = isMainThread2 = Looper.myLooper() == Looper.getMainLooper();
            if (isMainThread2) {
                return !this.isAdsTimeOut();
            }
            return !this.isAdsTimeOut();
        }
        if (this.rewardedInterstitialAd == null) {
            return false;
        }
        boolean bl = isMainThread = Looper.myLooper() == Looper.getMainLooper();
        if (isMainThread) {
            return !this.isAdsTimeOut();
        }
        return !this.isAdsTimeOut();
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("2");
    }

    public String getNetworkVersion() {
        return MobileAds.getVersionString();
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("placementId");
    }
}

