/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.content.Context;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VersionInfo;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.banner.TPBannerAdImpl;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.common.util.Views;
import com.tradplus.ads.google.GoogleErrorUtil;
import com.tradplus.ads.google.GoogleInitManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

class GooglePlayServicesBanner
extends TPBannerAdapter {
    private AdView mGoogleAdView;
    private String placementId;
    private String mAdSize;
    private AdRequest request;
    private TPBannerAdImpl tpBannerAd;
    private String id;
    private static final String TAG = "AdmobBanner";

    GooglePlayServicesBanner() {
    }

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.serverExtrasAreValid(tpParams)) {
            this.placementId = tpParams.get("placementId");
            if (tpParams.containsKey("ad_size" + this.placementId)) {
                this.mAdSize = tpParams.get("ad_size" + this.placementId);
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.id = tpParams.get("id");
        Log.i((String)TAG, (String)("BannerSize: " + this.mAdSize));
        this.request = GoogleInitManager.getInstance().getAdmobAdRequest(userParams);
        GoogleInitManager.getInstance().initSDK(context, this.request, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                GooglePlayServicesBanner.this.requestBanner(context);
            }

            public void onFailed(String code, String msg) {
                if (GooglePlayServicesBanner.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    GooglePlayServicesBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestBanner(Context context) {
        block2: {
            this.mGoogleAdView = new AdView(context);
            this.mGoogleAdView.setAdListener((AdListener)new AdViewListener());
            this.mGoogleAdView.setAdUnitId(this.placementId);
            this.mGoogleAdView.setAdSize(this.calculateAdSize(this.mAdSize, context));
            try {
                this.mGoogleAdView.loadAd(this.request);
            }
            catch (Exception e) {
                Log.i((String)TAG, (String)("Exception: " + e.getLocalizedMessage()));
                if (this.mLoadAdapterListener == null) break block2;
                TPError tpError = new TPError("Unspecified error.");
                tpError.setErrorMessage(e.getLocalizedMessage());
                this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            }
        }
    }

    private AdSize calculateAdSize(String adSize, Context context) {
        if ("2".equals(adSize)) {
            return AdSize.LARGE_BANNER;
        }
        if ("3".equals(adSize)) {
            return AdSize.MEDIUM_RECTANGLE;
        }
        if ("4".equals(adSize)) {
            return AdSize.FULL_BANNER;
        }
        if ("5".equals(adSize)) {
            return AdSize.LEADERBOARD;
        }
        if ("6".equals(adSize)) {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            float widthPixels = displayMetrics.widthPixels;
            float density = displayMetrics.density;
            int adWidth = (int)(widthPixels / density);
            return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)context, (int)adWidth);
        }
        return AdSize.BANNER;
    }

    public void clean() {
        Log.i((String)TAG, (String)"clean: ");
        if (this.mGoogleAdView != null) {
            Views.removeFromParent((View)this.mGoogleAdView);
            this.mGoogleAdView.setAdListener(null);
            this.mGoogleAdView.destroy();
            this.mGoogleAdView = null;
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs(this.id);
    }

    public String getNetworkVersion() {
        VersionInfo version = MobileAds.getVersion();
        int majorVersion = version.getMajorVersion();
        int minorVersion = version.getMinorVersion();
        int microVersion = version.getMicroVersion();
        return majorVersion + "." + minorVersion + "." + microVersion + "";
    }

    private boolean localExtrasAreValid(Map<String, Object> localExtras) {
        return localExtras.get("com_tp_ad_width") instanceof Integer && localExtras.get("com_tp_ad_height") instanceof Integer;
    }

    private boolean serverExtrasAreValid(Map<String, String> serverExtras) {
        String placementId = serverExtras.get("placementId");
        return placementId != null && placementId.length() > 0;
    }

    private class AdViewListener
    extends AdListener {
        private AdViewListener() {
        }

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            Log.i((String)GooglePlayServicesBanner.TAG, (String)("Google Play Services banner ad failed to load \uff0c errorCode : " + loadAdError.getMessage()));
            if (GooglePlayServicesBanner.this.mLoadAdapterListener != null) {
                GooglePlayServicesBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("Third-party network failed to provide an ad."), loadAdError));
            }
        }

        public void onAdClicked() {
            Log.i((String)GooglePlayServicesBanner.TAG, (String)"onAdClicked: ");
            if (GooglePlayServicesBanner.this.tpBannerAd != null) {
                GooglePlayServicesBanner.this.tpBannerAd.adClicked();
            }
        }

        public void onAdImpression() {
            Log.i((String)GooglePlayServicesBanner.TAG, (String)"onAdImpression: ");
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (GooglePlayServicesBanner.this.tpBannerAd != null) {
                        GooglePlayServicesBanner.this.tpBannerAd.adShown();
                    }
                }
            }, 1000L);
        }

        public void onAdClosed() {
            Log.i((String)GooglePlayServicesBanner.TAG, (String)"onAdClosed: ");
        }

        public void onAdLoaded() {
            if (GooglePlayServicesBanner.this.mGoogleAdView == null) {
                return;
            }
            Log.i((String)GooglePlayServicesBanner.TAG, (String)"onAdLoaded:");
            if (GooglePlayServicesBanner.this.mLoadAdapterListener != null) {
                if (GooglePlayServicesBanner.this.tpBannerAd == null) {
                    GooglePlayServicesBanner.this.tpBannerAd = new TPBannerAdImpl(null, (View)GooglePlayServicesBanner.this.mGoogleAdView);
                }
                GooglePlayServicesBanner.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)GooglePlayServicesBanner.this.tpBannerAd);
            }
        }

        public void onAdOpened() {
            Log.i((String)GooglePlayServicesBanner.TAG, (String)"onAdOpened: ");
        }
    }
}

