/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.admanager.AdManagerAdRequest;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.splash.TPSplashAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.google.AdManagerInit;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AdManagerSplash
extends TPSplashAdapter {
    public static final String TAG = "GAMSplash";
    private String placementId;
    private AdManagerAdRequest request;
    private AppOpenAd mAppOpenAd;
    private Integer mVideoMute = 0;
    private int mOrientation = 1;
    private String id;
    private final AppOpenAd.AppOpenAdLoadCallback mAppOpenAdLoadCallback = new AppOpenAd.AppOpenAdLoadCallback(){

        public void onAdLoaded(AppOpenAd ad) {
            Log.i((String)AdManagerSplash.TAG, (String)"onAdLoaded: ");
            AdManagerSplash.this.mAppOpenAd = ad;
            if (AdManagerSplash.this.mLoadAdapterListener != null) {
                AdManagerSplash.this.setNetworkObjectAd(ad);
                AdManagerSplash.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
        }

        public void onAdFailedToLoad(LoadAdError loadAdError) {
            Log.i((String)AdManagerSplash.TAG, (String)("onAdFailedToLoad: code: " + loadAdError.getCode() + " ,msg:" + loadAdError.getMessage()));
            AdManagerSplash.this.mAppOpenAd = null;
            TPError tpError = new TPError("Third-party network failed to provide an ad.");
            tpError.setErrorMessage(loadAdError.getMessage());
            tpError.setErrorCode(loadAdError.getCode() + "");
            if (AdManagerSplash.this.mLoadAdapterListener != null) {
                AdManagerSplash.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            }
        }
    };
    private final FullScreenContentCallback fullScreenContentCallback = new FullScreenContentCallback(){

        public void onAdDismissedFullScreenContent() {
            Log.i((String)AdManagerSplash.TAG, (String)"onAdDismissedFullScreenContent");
            AdManagerSplash.this.mAppOpenAd = null;
            if (AdManagerSplash.this.mShowListener != null) {
                AdManagerSplash.this.mShowListener.onAdClosed();
            }
        }

        public void onAdFailedToShowFullScreenContent(AdError adError) {
            Log.i((String)AdManagerSplash.TAG, (String)("onAdFailedToShowFullScreenContent: code:" + adError.getCode() + ", msg:" + adError.getMessage()));
            TPError tpError = new TPError("Third-party network failed to provide an ad.");
            tpError.setErrorMessage(adError.getMessage());
            tpError.setErrorCode(adError.getCode() + "");
            if (AdManagerSplash.this.mShowListener != null) {
                AdManagerSplash.this.mShowListener.onAdVideoError(tpError);
            }
        }

        public void onAdShowedFullScreenContent() {
            Log.i((String)AdManagerSplash.TAG, (String)"onAdShowedFullScreenContent");
            if (AdManagerSplash.this.mShowListener != null) {
                AdManagerSplash.this.mShowListener.onAdShown();
            }
        }

        public void onAdClicked() {
            Log.i((String)AdManagerSplash.TAG, (String)"onAdClicked: ");
            if (AdManagerSplash.this.mShowListener != null) {
                AdManagerSplash.this.mShowListener.onAdClicked();
            }
        }
    };

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (tpParams == null || tpParams.size() <= 0) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.placementId = tpParams.get("placementId");
        this.id = tpParams.get("id");
        if (userParams != null && userParams.size() > 0) {
            if (userParams.containsKey("Admob_Direction")) {
                this.mOrientation = (Integer)userParams.get("Admob_Direction");
            }
            if (userParams.containsKey("video_admob_mute")) {
                this.mVideoMute = (int)((Integer)userParams.get("video_admob_mute"));
            }
        }
        this.request = AdManagerInit.getInstance().getAdmobAdRequest(userParams, null, null);
        AdManagerInit.getInstance().initSDK(context, (AdRequest)this.request, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                if (AdManagerSplash.this.mVideoMute != 0) {
                    MobileAds.setAppMuted((AdManagerSplash.this.mVideoMute == 1 ? 1 : 0) != 0);
                }
                AdManagerSplash.this.requestSplash(context);
            }

            public void onFailed(String code, String msg) {
                if (AdManagerSplash.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    AdManagerSplash.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestSplash(Context context) {
        if (this.mOrientation == 2) {
            this.mOrientation = 2;
        }
        Log.i((String)TAG, (String)("Orientation: " + this.mOrientation + ", 1:\u7ad6\u5c4f\uff1b2:\u6a2a\u5c4f"));
        AppOpenAd.load((Context)context, (String)this.placementId, (AdManagerAdRequest)this.request, (int)this.mOrientation, (AppOpenAd.AppOpenAdLoadCallback)this.mAppOpenAdLoadCallback);
    }

    public void showAd() {
        Activity activity = GlobalTradPlus.getInstance().getActivity();
        if (activity == null) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
            return;
        }
        if (this.mAppOpenAd == null) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Unspecified error."));
            }
            return;
        }
        this.mAppOpenAd.setFullScreenContentCallback(this.fullScreenContentCallback);
        this.mAppOpenAd.show(activity);
    }

    public void clean() {
        if (this.mAppOpenAd != null) {
            this.mAppOpenAd.setFullScreenContentCallback(null);
            this.mAppOpenAd = null;
        }
    }

    public boolean isReady() {
        return true;
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs(this.id);
    }

    public String getNetworkVersion() {
        VersionInfo version = MobileAds.getVersion();
        int majorVersion = version.getMajorVersion();
        int minorVersion = version.getMinorVersion();
        int microVersion = version.getMicroVersion();
        return majorVersion + "." + minorVersion + "." + microVersion + "";
    }
}

