/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.MediaContent;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdView;
import com.tradplus.ads.base.bean.TPBaseAd;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GoogleNativeAd
extends TPBaseAd {
    private NativeAd mNativeAd;
    private NativeAdView mNativeAdView;
    private TPNativeAdView mTpNativeAdView;
    private MediaView mMediaView;
    private Context mContext;
    private static final String TAG = "AdmobNative";
    private VideoController.VideoLifecycleCallbacks videoLifecycleCallbacks = new VideoController.VideoLifecycleCallbacks(){

        public void onVideoEnd() {
            Log.i((String)GoogleNativeAd.TAG, (String)"onVideoEnd: ");
            if (GoogleNativeAd.this.mShowListener != null) {
                GoogleNativeAd.this.mShowListener.onAdVideoEnd();
            }
        }

        public void onVideoMute(boolean b) {
        }

        public void onVideoPause() {
        }

        public void onVideoPlay() {
        }

        public void onVideoStart() {
            Log.i((String)GoogleNativeAd.TAG, (String)"onVideoStart: ");
            if (GoogleNativeAd.this.mShowListener != null) {
                GoogleNativeAd.this.mShowListener.onAdVideoStart();
            }
        }
    };

    public GoogleNativeAd(Context context, NativeAd nativeAd) {
        String advertiser;
        String callToAction;
        String body;
        String headline;
        Drawable drawable;
        NativeAd.Image image;
        this.mContext = context;
        this.mNativeAd = nativeAd;
        this.mNativeAdView = new NativeAdView(context);
        this.mTpNativeAdView = new TPNativeAdView();
        List images = this.mNativeAd.getImages();
        MediaContent mediaContent = this.mNativeAd.getMediaContent();
        if (mediaContent != null) {
            this.mMediaView = new MediaView(context);
            boolean videoContent = mediaContent.hasVideoContent();
            if (videoContent) {
                VideoController videoController = mediaContent.getVideoController();
                videoController.setVideoLifecycleCallbacks(this.videoLifecycleCallbacks);
            }
            this.mTpNativeAdView.setMediaView((View)this.mMediaView);
        } else if (images != null && images.size() > 0 && (image = (NativeAd.Image)images.get(0)) != null && (drawable = image.getDrawable()) != null) {
            this.mTpNativeAdView.setMainImage(drawable);
        }
        NativeAd.Image icon = this.mNativeAd.getIcon();
        if (icon != null) {
            drawable = icon.getDrawable();
            Uri uri = icon.getUri();
            if (drawable != null) {
                this.mTpNativeAdView.setIconImage(drawable);
            } else if (uri != null) {
                this.mTpNativeAdView.setIconImageUrl(uri.toString());
            } else {
                Log.i((String)TAG, (String)"icon == null");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(headline = this.mNativeAd.getHeadline()))) {
            this.mTpNativeAdView.setTitle(headline);
        }
        if (!TextUtils.isEmpty((CharSequence)(body = this.mNativeAd.getBody()))) {
            this.mTpNativeAdView.setSubTitle(body);
        }
        if (!TextUtils.isEmpty((CharSequence)(callToAction = this.mNativeAd.getCallToAction()))) {
            this.mTpNativeAdView.setCallToAction(callToAction);
        }
        if (!TextUtils.isEmpty((CharSequence)(advertiser = this.mNativeAd.getAdvertiser()))) {
            this.mTpNativeAdView.setAdvertiserName(advertiser);
        }
        Double starRating = this.mNativeAd.getStarRating();
        Log.i((String)"StarRating", (String)("Admob StarRating: " + starRating));
        if (starRating != null) {
            this.mTpNativeAdView.setStarRating(starRating);
        }
    }

    public void onAdImpPaid(Map<String, Object> map) {
        if (this.mShowListener != null) {
            this.mShowListener.onAdImpPaid(map);
        }
    }

    public void onAdViewExpanded() {
        if (this.mShowListener != null) {
            this.mShowListener.onAdShown();
        }
    }

    public void onAdViewClicked() {
        if (this.mShowListener != null) {
            this.mShowListener.onAdClicked();
        }
    }

    public void registerClickView(ViewGroup viewGroup, ArrayList<View> clickViews) {
        View callToAction;
        View subTitleView;
        View titleView;
        View imageView = viewGroup.findViewWithTag((Object)"tp_image");
        if (this.mTpNativeAdView.getMediaView() != null) {
            this.mNativeAdView.setMediaView((MediaView)this.mTpNativeAdView.getMediaView());
        } else if (imageView != null) {
            this.mNativeAdView.setImageView(imageView);
        }
        View iconView = viewGroup.findViewWithTag((Object)"tp_icon");
        if (iconView != null) {
            this.mNativeAdView.setIconView(iconView);
        }
        if ((titleView = viewGroup.findViewWithTag((Object)"tp_title")) != null) {
            this.mNativeAdView.setHeadlineView(titleView);
        }
        if ((subTitleView = viewGroup.findViewWithTag((Object)"tp_subtitle")) != null) {
            this.mNativeAdView.setBodyView(subTitleView);
        }
        if ((callToAction = viewGroup.findViewWithTag((Object)"tp_action")) != null) {
            this.mNativeAdView.setCallToActionView(callToAction);
        }
        this.mNativeAdView.setNativeAd(this.mNativeAd);
    }

    public Object getNetworkObj() {
        return this.mNativeAd == null ? null : this.mNativeAd;
    }

    public TPNativeAdView getTPNativeView() {
        return this.mTpNativeAdView;
    }

    public int getNativeAdType() {
        return 0;
    }

    public View getRenderView() {
        return null;
    }

    public List<View> getMediaViews() {
        return null;
    }

    public ViewGroup getCustomAdContainer() {
        return this.mNativeAdView;
    }

    public void clean() {
        if (this.mNativeAdView != null) {
            this.mNativeAdView.destroy();
        }
    }
}

