/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.google;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.gms.ads.rewarded.ServerSideVerificationOptions;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAd;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAdLoadCallback;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.reward.TPRewardAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.google.GoogleErrorUtil;
import com.tradplus.ads.google.GoogleInitManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.HashMap;
import java.util.Map;

public class GooglePlayServicesInterstitialVideo
extends TPRewardAdapter {
    private RewardedAd mRewardedAd;
    private RewardedInterstitialAd rewardedInterstitialAd;
    private int isRewardedInterstitialAd;
    private String mAdUnitId;
    private String customData;
    private String userid;
    private AdRequest request;
    private boolean hasGrantedReward = false;
    private boolean alwaysRewardUser;
    private Integer mVideoMute = 0;
    private String id;
    private static final String TAG = "AdmobRewardedVideo";
    private final RewardedInterstitialAdLoadCallback mRewardedInterstitialAdLoadCallback = new RewardedInterstitialAdLoadCallback(){

        public void onAdLoaded(RewardedInterstitialAd ad) {
            GooglePlayServicesInterstitialVideo.this.setFirstLoadedTime();
            GooglePlayServicesInterstitialVideo.this.rewardedInterstitialAd = ad;
            GooglePlayServicesInterstitialVideo.this.rewardedInterstitialAd.setOnPaidEventListener(new OnPaidEventListener(){

                public void onPaidEvent(@NonNull AdValue adValue) {
                    Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)"onAdImpression: ");
                    long valueMicros = adValue.getValueMicros();
                    String currencyCode = adValue.getCurrencyCode();
                    int precision = adValue.getPrecisionType();
                    if (GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        Long value = new Long(valueMicros);
                        double dvalue = value.doubleValue();
                        map.put("paid_valueMicros", dvalue / 1000.0 / 1000.0);
                        map.put("paid_currencycode", currencyCode);
                        map.put("paid_precision", precision);
                        GooglePlayServicesInterstitialVideo.this.mShowListener.onAdImpPaid(map);
                    }
                }
            });
            Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)"onAdLoaded");
            if (GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener != null) {
                GooglePlayServicesInterstitialVideo.this.setNetworkObjectAd(ad);
                GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
            GooglePlayServicesInterstitialVideo.this.rewardedInterstitialAd.setFullScreenContentCallback(GooglePlayServicesInterstitialVideo.this.mFullScreenContentCallback);
        }

        public void onAdFailedToLoad(LoadAdError loadAdError) {
            Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)("onAdFailedToLoad: code :" + loadAdError.getCode() + " , msg : " + loadAdError.getMessage()));
            if (GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener != null) {
                GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("Third-party network failed to provide an ad."), loadAdError));
                GooglePlayServicesInterstitialVideo.this.rewardedInterstitialAd = null;
            }
        }
    };
    private final RewardedAdLoadCallback mRewardedAdLoadCallback = new RewardedAdLoadCallback(){

        public void onAdFailedToLoad(LoadAdError loadAdError) {
            Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)("onAdFailedToLoad: code :" + loadAdError.getCode() + " , msg : " + loadAdError.getMessage()));
            if (GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener != null) {
                GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(GoogleErrorUtil.getTradPlusErrorCode(new TPError("Third-party network failed to provide an ad."), loadAdError));
                GooglePlayServicesInterstitialVideo.this.mRewardedAd = null;
            }
        }

        public void onAdLoaded(RewardedAd rewardedAd) {
            Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)"onAdLoaded: ");
            GooglePlayServicesInterstitialVideo.this.setFirstLoadedTime();
            GooglePlayServicesInterstitialVideo.this.mRewardedAd = rewardedAd;
            GooglePlayServicesInterstitialVideo.this.mRewardedAd.setOnPaidEventListener(new OnPaidEventListener(){

                public void onPaidEvent(@NonNull AdValue adValue) {
                    Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)"onAdImpression: ");
                    long valueMicros = adValue.getValueMicros();
                    String currencyCode = adValue.getCurrencyCode();
                    int precision = adValue.getPrecisionType();
                    if (GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        Long value = new Long(valueMicros);
                        double dvalue = value.doubleValue();
                        map.put("paid_valueMicros", dvalue / 1000.0 / 1000.0);
                        map.put("paid_currencycode", currencyCode);
                        map.put("paid_precision", precision);
                        GooglePlayServicesInterstitialVideo.this.mShowListener.onAdImpPaid(map);
                    }
                }
            });
            if (GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener != null) {
                GooglePlayServicesInterstitialVideo.this.setNetworkObjectAd(rewardedAd);
                GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoaded(null);
            }
            GooglePlayServicesInterstitialVideo.this.mRewardedAd.setFullScreenContentCallback(GooglePlayServicesInterstitialVideo.this.mFullScreenContentCallback);
        }
    };
    private final FullScreenContentCallback mFullScreenContentCallback = new FullScreenContentCallback(){

        public void onAdShowedFullScreenContent() {
            Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)"Ad was shown.");
            if (GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                GooglePlayServicesInterstitialVideo.this.mShowListener.onAdVideoStart();
            }
            if (GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                GooglePlayServicesInterstitialVideo.this.mShowListener.onAdShown();
            }
        }

        public void onAdFailedToShowFullScreenContent(AdError adError) {
            Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)("Ad failed to show, code : " + adError.getCode() + " , msg: " + adError.getMessage()));
            if (GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                GooglePlayServicesInterstitialVideo.this.mShowListener.onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
            }
        }

        public void onAdDismissedFullScreenContent() {
            Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)"Ad was dismissed.");
            if (GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                GooglePlayServicesInterstitialVideo.this.mShowListener.onAdVideoEnd();
            }
            if ((GooglePlayServicesInterstitialVideo.this.hasGrantedReward || GooglePlayServicesInterstitialVideo.this.alwaysRewardUser) && GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                GooglePlayServicesInterstitialVideo.this.mShowListener.onReward();
            }
            if (GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                GooglePlayServicesInterstitialVideo.this.mShowListener.onAdClosed();
            }
        }

        public void onAdClicked() {
            Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)"onAdClicked: ");
            if (GooglePlayServicesInterstitialVideo.this.mShowListener != null) {
                GooglePlayServicesInterstitialVideo.this.mShowListener.onAdVideoClicked();
            }
        }
    };
    private final OnUserEarnedRewardListener mOnUserEarnedRewardListener = new OnUserEarnedRewardListener(){

        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
            Log.i((String)GooglePlayServicesInterstitialVideo.TAG, (String)"onUserEarnedReward: ");
            GooglePlayServicesInterstitialVideo.this.hasGrantedReward = true;
        }
    };

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.extrasAreValid(tpParams)) {
            this.mAdUnitId = tpParams.get("placementId");
            this.isRewardedInterstitialAd = Integer.parseInt(tpParams.get("adsource_type"));
            if (!TextUtils.isEmpty((CharSequence)tpParams.get("always_reward"))) {
                int rewardUser = Integer.parseInt(tpParams.get("always_reward"));
                this.alwaysRewardUser = rewardUser == 1;
            }
        } else {
            if (this.mLoadAdapterListener != null) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            }
            return;
        }
        this.id = tpParams.get("id");
        if (userParams != null && userParams.size() > 0) {
            if (userParams.containsKey("custom_data")) {
                this.customData = (String)userParams.get("custom_data");
                if (TextUtils.isEmpty((CharSequence)this.customData)) {
                    this.customData = "";
                }
            }
            if (userParams.containsKey("user_id")) {
                this.userid = (String)userParams.get("user_id");
                if (TextUtils.isEmpty((CharSequence)this.userid)) {
                    this.userid = "";
                }
            }
            if (userParams.containsKey("video_admob_mute")) {
                this.mVideoMute = (int)((Integer)userParams.get("video_admob_mute"));
            }
        }
        this.request = GoogleInitManager.getInstance().getAdmobAdRequest(userParams, null, null);
        GoogleInitManager.getInstance().initSDK(context, this.request, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                if (GooglePlayServicesInterstitialVideo.this.mVideoMute != 0) {
                    MobileAds.setAppMuted((GooglePlayServicesInterstitialVideo.this.mVideoMute == 1 ? 1 : 0) != 0);
                }
                GooglePlayServicesInterstitialVideo.this.requestInterstitialVideo(context);
            }

            public void onFailed(String code, String msg) {
                if (GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener != null) {
                    TPError tpError = new TPError("Third-party network SDK failed to init");
                    tpError.setErrorCode(code);
                    tpError.setErrorMessage(msg);
                    GooglePlayServicesInterstitialVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                }
            }
        });
    }

    private void requestInterstitialVideo(Context context) {
        block4: {
            try {
                if (this.isRewardedInterstitialAd == 2) {
                    Log.i((String)TAG, (String)"load RewardedInterstitialAd: \u63d2\u9875\u5f0f\u6fc0\u52b1\u89c6\u9891");
                    RewardedInterstitialAd.load((Context)context, (String)this.mAdUnitId, (AdRequest)this.request, (RewardedInterstitialAdLoadCallback)this.mRewardedInterstitialAdLoadCallback);
                } else {
                    Log.i((String)TAG, (String)"load RewardedAd: \u6fc0\u52b1\u89c6\u9891");
                    RewardedAd.load((Context)context, (String)this.mAdUnitId, (AdRequest)this.request, (RewardedAdLoadCallback)this.mRewardedAdLoadCallback);
                }
            }
            catch (Throwable e) {
                Log.i((String)"googleInterstitialVideo", (String)("e: " + e.getLocalizedMessage()));
                if (this.mLoadAdapterListener == null) break block4;
                TPError tpError = new TPError("Unspecified error.");
                tpError.setErrorMessage(e.getLocalizedMessage());
                this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
            }
        }
    }

    public void showAd() {
        Activity activity = GlobalTradPlus.getInstance().getActivity();
        if (activity == null) {
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Context is not Acvitiy context"));
            }
            return;
        }
        if (this.isRewardedInterstitialAd == 2) {
            if (!TextUtils.isEmpty((CharSequence)this.userid)) {
                Log.i((String)TAG, (String)("RewardData: userid:" + this.userid + ",customData : " + this.customData));
                ServerSideVerificationOptions options = new ServerSideVerificationOptions.Builder().setCustomData(TextUtils.isEmpty((CharSequence)this.customData) ? "" : this.customData).setUserId(this.userid).build();
                this.rewardedInterstitialAd.setServerSideVerificationOptions(options);
            }
            Log.i((String)TAG, (String)"show RewardedInterstitialAd: \u63d2\u9875\u5f0f\u6fc0\u52b1\u89c6\u9891");
            this.rewardedInterstitialAd.show(activity, this.mOnUserEarnedRewardListener);
        } else if (this.mRewardedAd != null) {
            if (!TextUtils.isEmpty((CharSequence)this.userid)) {
                Log.i((String)TAG, (String)("RewardData: customData : " + this.customData));
                ServerSideVerificationOptions options = new ServerSideVerificationOptions.Builder().setCustomData(TextUtils.isEmpty((CharSequence)this.customData) ? "" : this.customData).setUserId(this.userid).build();
                this.mRewardedAd.setServerSideVerificationOptions(options);
            }
            Log.i((String)TAG, (String)"show RewardedAd: \u6fc0\u52b1\u89c6\u9891");
            this.mRewardedAd.show(activity, this.mOnUserEarnedRewardListener);
        } else {
            Log.i((String)"TAG", (String)"The rewarded ad wasn't loaded yet.");
            if (this.mShowListener != null) {
                this.mShowListener.onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
            }
        }
    }

    public boolean isReady() {
        boolean isMainThread;
        if (this.isRewardedInterstitialAd != 2) {
            boolean isMainThread2;
            if (this.mRewardedAd == null) {
                return false;
            }
            boolean bl = isMainThread2 = Looper.myLooper() == Looper.getMainLooper();
            if (isMainThread2) {
                return !this.isAdsTimeOut();
            }
            return !this.isAdsTimeOut();
        }
        if (this.rewardedInterstitialAd == null) {
            return false;
        }
        boolean bl = isMainThread = Looper.myLooper() == Looper.getMainLooper();
        if (isMainThread) {
            return !this.isAdsTimeOut();
        }
        return !this.isAdsTimeOut();
    }

    public void clean() {
        if (this.mRewardedAd != null) {
            this.mRewardedAd.setFullScreenContentCallback(null);
            this.mRewardedAd = null;
        }
        if (this.rewardedInterstitialAd != null) {
            this.rewardedInterstitialAd.setFullScreenContentCallback(null);
            this.rewardedInterstitialAd = null;
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs(this.id);
    }

    public String getNetworkVersion() {
        VersionInfo version = MobileAds.getVersion();
        int majorVersion = version.getMajorVersion();
        int minorVersion = version.getMinorVersion();
        int microVersion = version.getMicroVersion();
        return majorVersion + "." + minorVersion + "." + microVersion + "";
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("placementId");
    }
}

