/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.bytedance.sdk.openadsdk.api.init.PAGConfig;
import com.bytedance.sdk.openadsdk.api.init.PAGSdk;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.util.TestDeviceUtil;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class PangleInitManager
extends TPInitMediation {
    private static final String TAG = "Pangle";
    private static PangleInitManager sInstance;
    private String appId;
    private int ischild = 0;
    private boolean ccpa = true;
    private String mName;

    public static synchronized PangleInitManager getInstance() {
        if (sInstance == null) {
            sInstance = new PangleInitManager();
        }
        return sInstance;
    }

    private void setPrivacyLaws(Map<String, Object> userParams) {
        if (userParams.containsKey("COPPA")) {
            boolean coppa = (Boolean)userParams.get("COPPA");
            if (coppa) {
                this.ischild = 1;
            }
            Log.i((String)"privacylaws", (String)("coppa: " + coppa));
        }
        if (userParams.containsKey("CCPA")) {
            this.ccpa = (Boolean)userParams.get("CCPA");
            Log.i((String)"privacylaws", (String)("ccpa: " + this.ccpa));
        }
    }

    private boolean getGoogleUMP(PAGConfig.Builder builder, Map<String, Object> userParams) {
        String purposeConsents = "";
        if (userParams.containsKey("IABTCF_PurposeConsents")) {
            purposeConsents = (String)userParams.get("IABTCF_PurposeConsents");
        }
        String purposeLegitimate = "";
        if (userParams.containsKey("IABTCF_PurposeLegitimateInterests")) {
            purposeLegitimate = (String)userParams.get("IABTCF_PurposeLegitimateInterests");
        }
        if (TextUtils.isEmpty((CharSequence)purposeConsents)) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)purposeLegitimate)) {
            return false;
        }
        try {
            boolean userConsent = false;
            char[] consentChars = purposeConsents.toCharArray();
            char[] legitimateChars = purposeLegitimate.toCharArray();
            if (PangleInitManager.checkConsent(consentChars, 0) + PangleInitManager.checkConsent(consentChars, 2) + PangleInitManager.checkConsent(consentChars, 3) >= 3 && PangleInitManager.checkConsent(consentChars, 1) + PangleInitManager.checkConsent(legitimateChars, 1) >= 1 && PangleInitManager.checkConsent(consentChars, 6) + PangleInitManager.checkConsent(legitimateChars, 6) >= 1 && PangleInitManager.checkConsent(consentChars, 8) + PangleInitManager.checkConsent(legitimateChars, 8) >= 1 && PangleInitManager.checkConsent(consentChars, 9) + PangleInitManager.checkConsent(legitimateChars, 9) >= 1) {
                userConsent = true;
            }
            Log.i((String)"privacylaws", (String)("Pangle userConsent: " + userConsent));
            if (builder == null) {
                PAGConfig.setGDPRConsent((int)(userConsent ? 1 : 0));
            } else {
                builder.setGDPRConsent(userConsent ? 1 : 0);
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static int checkConsent(char[] consentChars, int index) {
        try {
            if (index >= consentChars.length) {
                return 0;
            }
            int consent = Integer.parseInt(String.valueOf(consentChars[index]));
            Log.i((String)"TCF2.0", (String)("checkConsent index: " + index + ", consent" + consent));
            return consent;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private PAGConfig buildNewConfig(Map<String, Object> userParams, String appId) {
        Boolean userConsent;
        if (userParams != null && userParams.size() > 0) {
            this.setPrivacyLaws(userParams);
        }
        String mediationName = null;
        String adapterVersion = null;
        mediationName = "tradplus";
        adapterVersion = "19.0.0";
        PAGConfig.Builder builder = new PAGConfig.Builder();
        builder.appId(appId);
        builder.useTextureView(true);
        builder.titleBarTheme(1);
        builder.supportMultiProcess(false);
        builder.needClearTaskReset(new String[0]);
        if (!this.getGoogleUMP(builder, userParams) && (userConsent = this.updateUserConsent(userParams)) != null) {
            builder.setGDPRConsent(userConsent != false ? 1 : 0);
        }
        builder.setChildDirected(this.ischild);
        builder.setDoNotSell(this.ccpa ? 0 : 1);
        builder.setUserData(PangleInitManager.getDataString(mediationName, adapterVersion));
        builder.debugLog(TestDeviceUtil.getInstance().isNeedTestDevice());
        if (userParams.containsKey("app_icon")) {
            try {
                int appIcon = (Integer)userParams.get("app_icon");
                if (appIcon != 0) {
                    builder.appIcon(appIcon);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return builder.build();
    }

    private static String getDataString(String mediationName, String adapterVersion) {
        if (TextUtils.isEmpty((CharSequence)mediationName) || TextUtils.isEmpty((CharSequence)adapterVersion)) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject mediationJson = new JSONObject();
        JSONObject versionJson = new JSONObject();
        try {
            mediationJson.put("name", (Object)"mediation");
            mediationJson.put("value", (Object)mediationName);
            versionJson.put("name", (Object)"adapter_version");
            versionJson.put("value", (Object)adapterVersion);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        jsonArray.put((Object)mediationJson);
        jsonArray.put((Object)versionJson);
        return jsonArray.toString();
    }

    public void initSDK(Context context, Map<String, Object> userParams, Map<String, String> tpParams, TPInitMediation.InitCallback initCallback) {
        if (tpParams != null && tpParams.size() > 0) {
            this.appId = tpParams.get("appId");
            if (tpParams.containsKey("name")) {
                this.mName = tpParams.get("name");
            }
        }
        this.suportGDPR(context, userParams);
        if (PangleInitManager.isInited((String)this.appId)) {
            initCallback.onSuccess();
            return;
        }
        if (this.hasInit(this.appId, initCallback)) {
            return;
        }
        Log.d((String)"InitNetworkSDK", (String)("initSDK: appId :" + this.appId));
        if (PAGSdk.isInitSuccess()) {
            this.sendResult(this.appId, true);
            return;
        }
        PAGConfig pAGInitConfig = this.buildNewConfig(userParams, this.appId);
        PAGSdk.init((Context)context, (PAGConfig)pAGInitConfig, (PAGSdk.PAGInitCallback)new PAGSdk.PAGInitCallback(){

            public void success() {
                Log.i((String)PangleInitManager.TAG, (String)"success: ");
                PangleInitManager.this.sendResult(PangleInitManager.this.appId, true);
            }

            public void fail(int code, String msg) {
                Log.i((String)PangleInitManager.TAG, (String)("fail: code :" + code + ",msg :" + code));
                PangleInitManager.this.sendResult(PangleInitManager.this.appId, false, code + "", msg);
            }
        });
    }

    public void suportGDPR(Context context, Map<String, Object> userParams) {
        if (!PAGSdk.isInitSuccess()) {
            return;
        }
        if (userParams != null && userParams.size() > 0) {
            Boolean userConsent;
            this.setPrivacyLaws(userParams);
            if (!this.getGoogleUMP(null, userParams) && (userConsent = this.updateUserConsent(userParams)) != null) {
                PAGConfig.setGDPRConsent((int)(userConsent != false ? 1 : 0));
            }
            PAGConfig.setChildDirected((int)this.ischild);
            PAGConfig.setDoNotSell((int)(this.ccpa ? 0 : 1));
        }
    }

    public String getNetworkVersionCode() {
        return PAGSdk.getSDKVersion();
    }

    public String getNetworkVersionName() {
        return TextUtils.isEmpty((CharSequence)this.mName) ? TAG : this.mName;
    }

    public String getDefaultSPName(Context context) {
        return context.getPackageName() + "_preferences";
    }
}

