/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class UIUtils {
    public static final int VIVO_NOTCH = 32;
    public static final int VIVO_FILLET = 8;

    public static float getScreenWidthDp(Context context) {
        float scale = context.getResources().getDisplayMetrics().density;
        float width = context.getResources().getDisplayMetrics().widthPixels;
        return width / (scale <= 0.0f ? 1.0f : scale) + 0.5f;
    }

    public static float getHeight(Activity activity) {
        UIUtils.hideBottomUIMenu(activity);
        int realHeight = UIUtils.getRealHeight((Context)activity);
        float height = UIUtils.hasNotchScreen(activity) ? (float)UIUtils.px2dip((Context)activity, (float)realHeight - UIUtils.getStatusBarHeight((Context)activity)) : (float)UIUtils.px2dip((Context)activity, realHeight);
        return height;
    }

    public static void hideBottomUIMenu(Activity activity) {
        if (activity == null) {
            return;
        }
        try {
            if (Build.VERSION.SDK_INT > 11 && Build.VERSION.SDK_INT < 19) {
                View v = activity.getWindow().getDecorView();
                v.setSystemUiVisibility(8);
            } else if (Build.VERSION.SDK_INT >= 19) {
                View decorView = activity.getWindow().getDecorView();
                int uiOptions = 3842;
                decorView.setSystemUiVisibility(uiOptions);
                activity.getWindow().addFlags(0x8000000);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static int getRealHeight(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealMetrics(dm);
        } else {
            display.getMetrics(dm);
        }
        int realHeight = dm.heightPixels;
        return realHeight;
    }

    public static float getStatusBarHeight(Context context) {
        float height = 0.0f;
        int resourceId = context.getApplicationContext().getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            height = context.getApplicationContext().getResources().getDimensionPixelSize(resourceId);
        }
        return height;
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / (scale <= 0.0f ? 1.0f : scale) + 0.5f);
    }

    public static int dp2px(Context context, float dp) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    public static boolean hasNotchScreen(Activity activity) {
        return UIUtils.isAndroidPHasNotch(activity) || UIUtils.getInt("ro.miui.notch", activity) == 1 || UIUtils.hasNotchAtHuawei((Context)activity) || UIUtils.hasNotchAtOPPO((Context)activity) || UIUtils.hasNotchAtVivo((Context)activity);
    }

    public static boolean isAndroidPHasNotch(Activity activity) {
        boolean result = false;
        if (Build.VERSION.SDK_INT >= 28) {
            DisplayCutout displayCutout = null;
            try {
                WindowInsets windowInsets = activity.getWindow().getDecorView().getRootWindowInsets();
                if (windowInsets != null) {
                    displayCutout = windowInsets.getDisplayCutout();
                }
                if (displayCutout != null) {
                    result = true;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static int getInt(String key, Activity activity) {
        int result = 0;
        if (UIUtils.isMiui()) {
            try {
                ClassLoader classLoader = activity.getClassLoader();
                Class<?> SystemProperties = classLoader.loadClass("android.os.SystemProperties");
                Class[] paramTypes = new Class[]{String.class, Integer.TYPE};
                Method getInt = SystemProperties.getMethod("getInt", paramTypes);
                Object[] params = new Object[]{new String(key), new Integer(0)};
                result = (Integer)getInt.invoke(SystemProperties, params);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasNotchAtHuawei(Context context) {
        boolean ret = false;
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> HwNotchSizeUtil = classLoader.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = HwNotchSizeUtil.getMethod("hasNotchInScreen", new Class[0]);
            ret = (Boolean)get.invoke(HwNotchSizeUtil, new Object[0]);
            return ret;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        catch (NoSuchMethodException noSuchMethodException) {}
        catch (Throwable throwable) {}
        finally {
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasNotchAtVivo(Context context) {
        boolean ret = false;
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> FtFeature = classLoader.loadClass("android.util.FtFeature");
            Method method = FtFeature.getMethod("isFeatureSupport", Integer.TYPE);
            ret = (Boolean)method.invoke(FtFeature, 32);
            return ret;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        catch (NoSuchMethodException noSuchMethodException) {}
        catch (Throwable throwable) {}
        finally {
            return ret;
        }
    }

    public static boolean hasNotchAtOPPO(Context context) {
        String temp = "com.kllk.feature.screen.heteromorphism";
        String name = UIUtils.getKllkDecryptString(temp);
        return context.getPackageManager().hasSystemFeature(name);
    }

    public static boolean isMiui() {
        boolean sIsMiui = false;
        try {
            Class<?> clz = Class.forName("miui.os.Build");
            if (clz != null) {
                sIsMiui = true;
                return sIsMiui;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return sIsMiui;
    }

    public static String getKllkDecryptString(String encryptionString) {
        if (TextUtils.isEmpty((CharSequence)encryptionString)) {
            return "";
        }
        String decryptTag = "";
        String decryptCapitalized = "OPPO";
        String decrypt = "oppo";
        if (encryptionString.contains("KLLK")) {
            decryptTag = encryptionString.replace("KLLK", decryptCapitalized);
        } else if (encryptionString.contains("kllk")) {
            decryptTag = encryptionString.replace("kllk", decrypt);
        }
        return decryptTag;
    }

    public static void setViewSize(View view, int width, int height) {
        if (view.getParent() instanceof FrameLayout) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)view.getLayoutParams();
            lp.width = width;
            lp.height = height;
            view.setLayoutParams((ViewGroup.LayoutParams)lp);
            view.requestLayout();
        } else if (view.getParent() instanceof RelativeLayout) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)view.getLayoutParams();
            lp.width = width;
            lp.height = height;
            view.setLayoutParams((ViewGroup.LayoutParams)lp);
            view.requestLayout();
        } else if (view.getParent() instanceof LinearLayout) {
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)view.getLayoutParams();
            lp.width = width;
            lp.height = height;
            view.setLayoutParams((ViewGroup.LayoutParams)lp);
            view.requestLayout();
        }
    }

    public static int getScreenWidthInPx(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return displayMetrics.widthPixels;
    }

    public static int getScreenHeightInPx(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return displayMetrics.heightPixels;
    }

    public static void removeFromParent(View view) {
        ViewParent vp;
        if (view != null && (vp = view.getParent()) instanceof ViewGroup) {
            ((ViewGroup)vp).removeView(view);
        }
    }

    public static int[] getScreenSize(Context context) {
        int[] size = new int[]{0, 0};
        if (context == null) {
            return size;
        }
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealMetrics(dm);
        } else {
            display.getMetrics(dm);
        }
        size[0] = dm.widthPixels;
        size[1] = dm.heightPixels;
        return size;
    }
}

