/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.content.Context;
import android.util.Log;
import android.view.View;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdManager;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTNativeExpressAd;
import com.tradplus.ads.fpangolin.PangleErrorUtil;
import com.tradplus.ads.fpangolin.TDADManagerHolder;
import com.tradplus.ads.mobileads.CustomEventAdView;
import java.util.List;
import java.util.Map;

public class TouTiaoBanner
extends CustomEventAdView
implements TTAdNative.NativeExpressAdListener {
    private Context mCxt;
    private String mAppId;
    private TTAdNative mAdNative;
    private String mPlacementId;
    private int height;
    private int width;
    private TTNativeExpressAd mTTAd;
    private CustomEventAdView.CustomEventAdViewListener mCEBannerListener;
    public static final String WIDTH = "width";
    public static final String HEIGHT = "hight";
    private static final int STANDARD_WIDTH = 600;
    private static final int STANDARD_HEIGHT = 150;
    private static final String TAG = "PangleBanner";

    protected void loadAdView(Context context, CustomEventAdView.CustomEventAdViewListener customEventBannerListener, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        this.mCEBannerListener = customEventBannerListener;
        this.mCxt = context;
        if (serverExtras != null && serverExtras.size() > 0) {
            this.mAppId = serverExtras.get("appId");
            this.mPlacementId = serverExtras.get("placementId");
            if (serverExtras.get(WIDTH) != null && serverExtras.get(HEIGHT) != null) {
                this.width = Integer.parseInt(serverExtras.get(WIDTH));
                this.height = Integer.parseInt(serverExtras.get(HEIGHT));
            } else {
                this.width = 600;
                this.height = 150;
            }
        }
        TDADManagerHolder.init(context, localExtras, this.mAppId);
        TTAdManager adManager = TDADManagerHolder.get();
        this.mAdNative = adManager.createAdNative(this.mCxt);
        AdSlot adSlot = new AdSlot.Builder().setCodeId(this.mPlacementId).setAdCount(3).setSupportDeepLink(true).build();
        this.mAdNative.loadBannerExpressAd(adSlot, (TTAdNative.NativeExpressAdListener)this);
    }

    protected void onInvalidate() {
        if (this.mTTAd != null) {
            this.mTTAd.destroy();
        }
    }

    public void onError(int errorCode, String errorMsg) {
        if (this.mCEBannerListener != null) {
            Log.i((String)"TradPlus", (String)("Pangle Banner onError ,errorCode : " + errorCode + ", errorMsg : " + errorMsg));
            this.mCEBannerListener.onAdViewFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
        }
    }

    public void onNativeExpressAdLoad(List<TTNativeExpressAd> ads) {
        if (ads == null || ads.size() == 0) {
            return;
        }
        this.mTTAd = ads.get(0);
        this.mTTAd.setSlideIntervalTime(30000);
        this.bindAdListener(this.mTTAd);
        this.mTTAd.render();
    }

    private void bindAdListener(TTNativeExpressAd mTTAd) {
        mTTAd.setExpressInteractionListener(new TTNativeExpressAd.ExpressAdInteractionListener(){

            public void onAdClicked(View view, int i) {
                if (TouTiaoBanner.this.mCEBannerListener != null) {
                    Log.i((String)TouTiaoBanner.TAG, (String)"onAdClicked: ");
                    TouTiaoBanner.this.mCEBannerListener.onAdViewClicked();
                }
            }

            public void onAdShow(View view, int i) {
                if (TouTiaoBanner.this.mCEBannerListener != null) {
                    Log.i((String)TouTiaoBanner.TAG, (String)"onAdShow: ");
                    TouTiaoBanner.this.mCEBannerListener.onAdViewExpanded();
                }
            }

            public void onRenderFail(View view, String errorMsg, int errorCode) {
                if (TouTiaoBanner.this.mCEBannerListener != null) {
                    Log.i((String)TouTiaoBanner.TAG, (String)"onRenderFail: ");
                    Log.i((String)"TradPlus", (String)("Pangle Banner onRenderFail ,errorCode : " + errorCode + ", errorMsg : " + errorMsg));
                    TouTiaoBanner.this.mCEBannerListener.onAdViewFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
                }
            }

            public void onRenderSuccess(View view, float v, float v1) {
                if (TouTiaoBanner.this.mCEBannerListener != null) {
                    Log.i((String)TouTiaoBanner.TAG, (String)"onRenderSuccess: ");
                    TouTiaoBanner.this.mCEBannerListener.onAdViewLoaded(view);
                }
            }
        });
    }
}

