/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdManager;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTNativeExpressAd;
import com.tradplus.ads.fpangolin.PangleErrorUtil;
import com.tradplus.ads.fpangolin.TDADManagerHolder;
import com.tradplus.ads.mobileads.CustomEventAdView;
import java.util.List;
import java.util.Map;

public class TouTiaoTemplateNativeVideo
extends CustomEventAdView {
    private Context mCtx;
    private String mAppId;
    private TTNativeExpressAd mTtNativeExpressAd;
    private CustomEventAdView.CustomEventAdViewListener mCEListener;
    private String mPlacementId;
    private int mWidth;
    private int mHeight;
    private String mLayoutName;
    private RelativeLayout adsContainer;
    public static final String TAG = "TouTiaoNativeVideo";

    protected void loadAdView(Context context, CustomEventAdView.CustomEventAdViewListener customEventBannerListener, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        Log.i((String)TAG, (String)"loadAdView: ");
        this.mCtx = context;
        this.mCEListener = customEventBannerListener;
        if (serverExtras != null && serverExtras.size() > 0) {
            this.mAppId = serverExtras.get("appId");
            this.mPlacementId = serverExtras.get("placementId");
        }
        if (localExtras != null && localExtras.size() > 0) {
            this.mLayoutName = (String)localExtras.get("com_mopub_ad_layout_name");
            this.mWidth = (Integer)localExtras.get("com_mopub_ad_width");
            this.mHeight = (Integer)localExtras.get("com_mopub_ad_height");
        }
        if (this.mWidth <= 0 && this.mHeight <= 0) {
            this.mWidth = 320;
            this.mHeight = 340;
        }
        Log.i((String)TAG, (String)("loadAdView mWidth: " + this.mWidth + ":mHeight:" + this.mHeight));
        if (!TextUtils.isEmpty((CharSequence)this.mLayoutName)) {
            int layoutId = context.getResources().getIdentifier(this.mLayoutName, "layout", context.getPackageName());
            LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            this.adsContainer = (RelativeLayout)layoutInflater.inflate(layoutId, null);
        }
        TDADManagerHolder.init(context, localExtras, this.mAppId);
        TTAdManager adManager = TDADManagerHolder.get();
        TTAdNative adNative = adManager.createAdNative(this.mCtx);
        AdSlot slot = new AdSlot.Builder().setCodeId(this.mPlacementId).setSupportDeepLink(true).setAdCount(1).setExpressViewAcceptedSize((float)this.mWidth, (float)this.mHeight).build();
        adNative.loadNativeExpressAd(slot, new TTAdNative.NativeExpressAdListener(){

            public void onError(int errorCode, String errorMsg) {
                Log.i((String)TouTiaoTemplateNativeVideo.TAG, (String)("onError: " + errorCode + ":errorMsg:" + errorMsg));
                if (TouTiaoTemplateNativeVideo.this.mCEListener != null) {
                    TouTiaoTemplateNativeVideo.this.mCEListener.onAdViewFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
                }
            }

            public void onNativeExpressAdLoad(List<TTNativeExpressAd> list) {
                Log.i((String)TouTiaoTemplateNativeVideo.TAG, (String)"onNativeExpressAdLoad: ");
                if (list == null || list.size() == 0) {
                    return;
                }
                TouTiaoTemplateNativeVideo.this.mTtNativeExpressAd = list.get(0);
                TouTiaoTemplateNativeVideo.this.bindListener(TouTiaoTemplateNativeVideo.this.mTtNativeExpressAd);
                if (TouTiaoTemplateNativeVideo.this.mCEListener != null) {
                    TouTiaoTemplateNativeVideo.this.mCEListener.onAdsSourceLoaded((Object)TouTiaoTemplateNativeVideo.this.mTtNativeExpressAd);
                }
                TouTiaoTemplateNativeVideo.this.mTtNativeExpressAd.render();
            }
        });
    }

    private void bindListener(TTNativeExpressAd mTtNativeExpressAd) {
        Log.i((String)TAG, (String)"bindListener: ");
        if (mTtNativeExpressAd != null) {
            mTtNativeExpressAd.setExpressInteractionListener(new TTNativeExpressAd.ExpressAdInteractionListener(){

                public void onAdClicked(View view, int i) {
                    Log.i((String)TouTiaoTemplateNativeVideo.TAG, (String)"onAdClicked: ");
                    if (TouTiaoTemplateNativeVideo.this.mCEListener != null) {
                        TouTiaoTemplateNativeVideo.this.mCEListener.onAdViewClicked();
                    }
                }

                public void onAdShow(View view, int i) {
                    Log.i((String)TouTiaoTemplateNativeVideo.TAG, (String)"onAdShow: ");
                    if (TouTiaoTemplateNativeVideo.this.mCEListener != null) {
                        TouTiaoTemplateNativeVideo.this.mCEListener.onAdViewExpanded();
                    }
                }

                public void onRenderFail(View view, String errorMsg, int errorCode) {
                    Log.i((String)TouTiaoTemplateNativeVideo.TAG, (String)("onRenderFail: " + errorMsg + ":errorCode:" + errorCode));
                    if (TouTiaoTemplateNativeVideo.this.mCEListener != null) {
                        TouTiaoTemplateNativeVideo.this.mCEListener.onAdViewFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
                    }
                }

                public void onRenderSuccess(View view, float v, float v1) {
                    Log.i((String)TouTiaoTemplateNativeVideo.TAG, (String)"onRenderSuccess: ");
                    if (TouTiaoTemplateNativeVideo.this.adsContainer != null) {
                        TouTiaoTemplateNativeVideo.this.adsContainer.removeAllViews();
                        TouTiaoTemplateNativeVideo.this.adsContainer.addView(view);
                        if (TouTiaoTemplateNativeVideo.this.mCEListener != null) {
                            TouTiaoTemplateNativeVideo.this.mCEListener.onAdViewLoaded((View)TouTiaoTemplateNativeVideo.this.adsContainer);
                        }
                    }
                }
            });
        }
    }

    protected void onInvalidate() {
        Log.i((String)TAG, (String)"onInvalidate: ");
        if (this.mTtNativeExpressAd != null) {
            this.mTtNativeExpressAd.destroy();
        }
    }
}

