/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdManager;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTNativeExpressAd;
import com.tradplus.ads.common.BaseLifecycleListener;
import com.tradplus.ads.common.LifecycleListener;
import com.tradplus.ads.fpangolin.PangleErrorUtil;
import com.tradplus.ads.fpangolin.TDADManagerHolder;
import com.tradplus.ads.fpangolin.ToutiaoInterstitialCallbackRouter;
import com.tradplus.ads.mobileads.CustomEventInterstitial;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.mobileads.util.BaseTimeOutAdapter;
import com.tradplus.ads.mobileads.util.TPContextUtils;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;

public class ToutiaoInterstitialAdapter
extends CustomEventInterstitial
implements TTAdNative.NativeExpressAdListener {
    public static final String TAG = "PangleInterstitial";
    public static final float EXPRESSVIEW_WIDTH1 = 300.0f;
    public static final float EXPRESSVIEW_HEIGHT1 = 300.0f;
    public static final float EXPRESSVIEW_WIDTH2 = 300.0f;
    public static final float EXPRESSVIEW_HEIGHT2 = 450.0f;
    public static final float EXPRESSVIEW_WIDTH3 = 450.0f;
    public static final float EXPRESSVIEW_HEIGHT3 = 300.0f;
    private TTAdNative ttAdNative;
    private TTNativeExpressAd ttNativeExpressAd;
    private WeakReference<Context> contextWeakReference;
    private ToutiaoInterstitialCallbackRouter toutiaoInterstitialCallbackRouter;
    private String appId;
    private String placementId;
    private CustomEventInterstitial.CustomEventInterstitialListener mCustomEventInterstitialListener;
    private int mIsTemplateRending;

    protected void loadInterstitial(Context context, CustomEventInterstitial.CustomEventInterstitialListener customEventInterstitialListener, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        Log.i((String)TAG, (String)"loadInterstitial: ");
        this.contextWeakReference = new WeakReference<Context>(context);
        if (context instanceof Application) {
            customEventInterstitialListener.onInterstitialFailed(TradPlusErrorCode.ADAPTER_ACTIVITY_ERROR);
            return;
        }
        this.toutiaoInterstitialCallbackRouter = ToutiaoInterstitialCallbackRouter.getInstance();
        if (this.extrasAreValid(serverExtras)) {
            this.appId = serverExtras.get("appId");
            this.placementId = serverExtras.get("placementId");
            String template = serverExtras.get("is_template_rendering");
            if (!TextUtils.isEmpty((CharSequence)template)) {
                this.mIsTemplateRending = Integer.parseInt(template);
            }
        }
        this.toutiaoInterstitialCallbackRouter.addListener(this.placementId, customEventInterstitialListener);
        this.mCustomEventInterstitialListener = this.toutiaoInterstitialCallbackRouter.getListener(this.placementId);
        TDADManagerHolder.init(context, localExtras, this.appId);
        this.initInsterstitial(context);
    }

    private void initInsterstitial(Context context) {
        Log.i((String)TAG, (String)"initInsterstitial: ");
        AdSlot.Builder builder = new AdSlot.Builder().setCodeId(this.placementId).setSupportDeepLink(true).setAdCount(1);
        Log.i((String)TAG, (String)("initInsterstitial: " + this.mIsTemplateRending));
        if (this.mIsTemplateRending == 1) {
            builder.setExpressViewAcceptedSize(450.0f, 300.0f);
        }
        AdSlot adSlot = builder.build();
        TTAdManager mTTAdManager = TDADManagerHolder.get();
        if (this.ttAdNative == null) {
            this.ttAdNative = mTTAdManager.createAdNative(context);
        }
        this.ttAdNative.loadInteractionExpressAd(adSlot, (TTAdNative.NativeExpressAdListener)this);
    }

    protected void showInterstitial() {
        Context context = (Context)this.contextWeakReference.get();
        Context _ct = TPContextUtils.getInstance((Context)context).compareContext(context);
        if (_ct == null) {
            if (this.toutiaoInterstitialCallbackRouter.getListener(this.placementId) != null) {
                this.toutiaoInterstitialCallbackRouter.getListener(this.placementId).onInterstitialFailed(TradPlusErrorCode.SHOW_FAILED);
            }
        } else if (this.ttNativeExpressAd != null) {
            this.ttNativeExpressAd.showInteractionExpressAd((Activity)_ct);
        } else if (this.toutiaoInterstitialCallbackRouter.getListener(this.placementId) != null) {
            this.toutiaoInterstitialCallbackRouter.getListener(this.placementId).onInterstitialFailed(TradPlusErrorCode.SHOW_FAILED);
        }
    }

    protected void onInvalidate() {
        if (this.ttNativeExpressAd != null) {
            this.ttNativeExpressAd.destroy();
        }
    }

    protected LifecycleListener getLifecycleListener() {
        return new BaseLifecycleListener(){

            public void onPause(Activity activity) {
            }

            public void onResume(Activity activity) {
            }
        };
    }

    protected boolean isReadyInterstitial() {
        return !this.isAdsTimeOut(BaseTimeOutAdapter.ThirdADPlatform.PANGOLIN);
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("appId");
    }

    public void onError(int errorCode, String errorMsg) {
        Log.i((String)TAG, (String)("onError: " + errorCode + ":msg:" + errorMsg));
        if (this.toutiaoInterstitialCallbackRouter != null && this.toutiaoInterstitialCallbackRouter.getListener(this.placementId) != null) {
            this.toutiaoInterstitialCallbackRouter.getListener(this.placementId).onInterstitialFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
        }
    }

    public void onNativeExpressAdLoad(List<TTNativeExpressAd> ads) {
        if (ads == null || ads.size() == 0) {
            return;
        }
        this.ttNativeExpressAd = ads.get(0);
        this.bindAdListener(this.ttNativeExpressAd);
        this.ttNativeExpressAd.render();
    }

    private void bindAdListener(TTNativeExpressAd ad) {
        ad.setExpressInteractionListener(new TTNativeExpressAd.AdInteractionListener(){

            public void onAdDismiss() {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdDismiss: ");
                if (ToutiaoInterstitialAdapter.this.mCustomEventInterstitialListener != null) {
                    ToutiaoInterstitialAdapter.this.mCustomEventInterstitialListener.onInterstitialDismissed();
                }
            }

            public void onAdClicked(View view, int type) {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdClicked: ");
                if (ToutiaoInterstitialAdapter.this.mCustomEventInterstitialListener != null) {
                    ToutiaoInterstitialAdapter.this.mCustomEventInterstitialListener.onInterstitialClicked();
                }
            }

            public void onAdShow(View view, int type) {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onAdShow: ");
                if (ToutiaoInterstitialAdapter.this.mCustomEventInterstitialListener != null) {
                    ToutiaoInterstitialAdapter.this.mCustomEventInterstitialListener.onInterstitialShown();
                }
            }

            public void onRenderFail(View view, String msg, int code) {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onRenderFail: ");
                if (ToutiaoInterstitialAdapter.this.mCustomEventInterstitialListener != null) {
                    ToutiaoInterstitialAdapter.this.mCustomEventInterstitialListener.onInterstitialFailed(PangleErrorUtil.getTradPlusErrorCode(code, msg));
                }
            }

            public void onRenderSuccess(View view, float width, float height) {
                Log.i((String)ToutiaoInterstitialAdapter.TAG, (String)"onRenderSuccess: ");
                ToutiaoInterstitialAdapter.this.setFirstLoadedTime();
                if (ToutiaoInterstitialAdapter.this.mCustomEventInterstitialListener != null) {
                    ToutiaoInterstitialAdapter.this.mCustomEventInterstitialListener.onInterstitialLoaded();
                }
            }
        });
        if (ad.getInteractionType() != 4) {
            return;
        }
    }
}

