/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdManager;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTRewardVideoAd;
import com.tradplus.ads.common.BaseLifecycleListener;
import com.tradplus.ads.common.LifecycleListener;
import com.tradplus.ads.fpangolin.PangleErrorUtil;
import com.tradplus.ads.fpangolin.TDADManagerHolder;
import com.tradplus.ads.fpangolin.ToutiaoAdsInterstitialListener;
import com.tradplus.ads.fpangolin.ToutiaoInterstitialCallbackRouter;
import com.tradplus.ads.mobileads.CustomEventInterstitial;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.mobileads.TradPlusPidReward;
import com.tradplus.ads.mobileads.util.BaseTimeOutAdapter;
import com.tradplus.ads.mobileads.util.TPContextUtils;
import java.lang.ref.WeakReference;
import java.util.Map;

public class ToutiaoRewardVideoAdapter
extends CustomEventInterstitial
implements TTAdNative.RewardVideoAdListener {
    public static final String CURRENCY_NAME_KEY = "currencyName";
    public static final String AMOUNT_KEY = "amount";
    public static final String PASS_SCAN_KEY = "passScan";
    private TTAdNative ttAdNative;
    private TTRewardVideoAd mttRewardVideoAd;
    private WeakReference<Context> contextWeakReference;
    private ToutiaoInterstitialCallbackRouter toutiaoInterstitialCallbackRouter;
    private String appId;
    private String placementId;
    private String mCurrencyName;
    private String mAmount;
    private String mPassScan;
    private int mIsTemplateRending;

    protected void loadInterstitial(Context context, CustomEventInterstitial.CustomEventInterstitialListener customEventInterstitialListener, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        this.contextWeakReference = new WeakReference<Context>(context);
        this.toutiaoInterstitialCallbackRouter = ToutiaoInterstitialCallbackRouter.getInstance();
        if (serverExtras != null && serverExtras.size() > 0) {
            this.appId = serverExtras.get("appId");
            this.placementId = serverExtras.get("placementId");
            this.mCurrencyName = serverExtras.get(CURRENCY_NAME_KEY);
            this.mAmount = serverExtras.get(AMOUNT_KEY);
            this.mPassScan = serverExtras.get(PASS_SCAN_KEY);
            String template = serverExtras.get("is_template_rendering");
            if (!TextUtils.isEmpty((CharSequence)template)) {
                this.mIsTemplateRending = Integer.parseInt(template);
            }
        }
        Log.i((String)"ToutiaoRewardVideo", (String)("loadInterstitial appId: " + this.appId + ":PId:" + this.placementId));
        this.toutiaoInterstitialCallbackRouter.addListener(this.placementId, customEventInterstitialListener);
        TDADManagerHolder.init(context, localExtras, this.appId);
        this.initRewardVideo(context);
    }

    private void initRewardVideo(Context context) {
        int count = TextUtils.isEmpty((CharSequence)this.mAmount) ? 0 : Integer.parseInt(this.mAmount);
        this.toutiaoInterstitialCallbackRouter.addPidListener(this.placementId, new TradPlusPidReward(this.mCurrencyName, this.mAmount));
        int ori = context.getResources().getConfiguration().orientation;
        AdSlot.Builder builder = new AdSlot.Builder().setCodeId(this.placementId).setSupportDeepLink(true).setAdCount(1).setImageAcceptedSize(1080, 1920).setRewardName(this.mCurrencyName).setRewardAmount(count).setUserID("").setOrientation(ori == 0 ? 2 : 1);
        Log.i((String)"ToutiaoRewardVideo", (String)("initRewardVideo: " + this.mIsTemplateRending));
        if (this.mIsTemplateRending == 1) {
            builder.setExpressViewAcceptedSize(500.0f, 500.0f);
        }
        AdSlot adSlot = builder.build();
        TTAdManager mTTAdManager = TDADManagerHolder.get();
        if (this.ttAdNative == null) {
            this.ttAdNative = mTTAdManager.createAdNative(context);
        }
        this.ttAdNative.loadRewardVideoAd(adSlot, (TTAdNative.RewardVideoAdListener)this);
    }

    protected void showInterstitial() {
        Context context = (Context)this.contextWeakReference.get();
        Context _ct = TPContextUtils.getInstance((Context)context).compareContext(context);
        if (_ct == null) {
            if (this.toutiaoInterstitialCallbackRouter.getListener(this.placementId) != null) {
                this.toutiaoInterstitialCallbackRouter.getListener(this.placementId).onInterstitialFailed(TradPlusErrorCode.SHOW_FAILED);
            }
        } else if (context != null && this.mttRewardVideoAd != null) {
            this.mttRewardVideoAd.showRewardVideoAd((Activity)_ct);
        } else if (this.toutiaoInterstitialCallbackRouter.getListener(this.placementId) != null) {
            this.toutiaoInterstitialCallbackRouter.getListener(this.placementId).onInterstitialFailed(TradPlusErrorCode.SHOW_FAILED);
        }
    }

    protected void onInvalidate() {
    }

    protected LifecycleListener getLifecycleListener() {
        return new BaseLifecycleListener(){

            public void onPause(Activity activity) {
            }

            public void onResume(Activity activity) {
            }
        };
    }

    protected boolean isReadyInterstitial() {
        return !this.isAdsTimeOut(BaseTimeOutAdapter.ThirdADPlatform.PANGOLIN);
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("appId");
    }

    public void onError(int i, String s) {
        Log.i((String)"ToutiaoRewardVideo", (String)("onError: " + i + ":msg:" + s));
        if (this.toutiaoInterstitialCallbackRouter.getListener(this.placementId) != null) {
            this.toutiaoInterstitialCallbackRouter.getListener(this.placementId).onInterstitialFailed(PangleErrorUtil.getTradPlusErrorCode(i, s));
        }
    }

    public void onRewardVideoAdLoad(TTRewardVideoAd ttRewardVideoAd) {
        Log.i((String)"ToutiaoRewardVideo", (String)"onRewardVideoAdLoad: ");
        this.setFirstLoadedTime();
        this.mttRewardVideoAd = ttRewardVideoAd;
        this.mttRewardVideoAd.setRewardAdInteractionListener((TTRewardVideoAd.RewardAdInteractionListener)new ToutiaoAdsInterstitialListener(this.placementId));
        this.toutiaoInterstitialCallbackRouter.getListener(this.placementId).onInterstitialLoaded();
    }

    public void onRewardVideoCached() {
        Log.i((String)"ToutiaoRewardVideo", (String)"onRewardVideoCached: ");
    }
}

