/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdManager;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.bytedance.sdk.openadsdk.TTFeedAd;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.fpangolin.PangleErrorUtil;
import com.tradplus.ads.fpangolin.PangleInitManager;
import com.tradplus.ads.fpangolin.ToutiaoNativeAd;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.List;
import java.util.Map;

public class TouTiaoRenderNativeVideo
extends TPNativeAdapter {
    private Context mCxt;
    private String mAppId;
    private TTFeedAd mTtNativeExpressAd;
    public static final String TAG = "PangleNative";
    private String mPlacementId;
    private int mIsTemplateRending;
    private TTAdManager adManager;
    private TTAdNative mAdNative;
    private int mWidth;
    private int mHeight;
    private ToutiaoNativeAd mToutiaoNativeAd;
    private boolean mNeedDownloadImg = false;
    final TTAdNative.FeedAdListener feedAdListener = new TTAdNative.FeedAdListener(){

        public void onError(int errorCode, String errorMsg) {
            Log.i((String)TouTiaoRenderNativeVideo.TAG, (String)("onError: errorCode:" + errorCode + ", errorMsg :" + errorMsg));
            if (TouTiaoRenderNativeVideo.this.mLoadAdapterListener != null) {
                TouTiaoRenderNativeVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
            }
        }

        public void onFeedAdLoad(List<TTFeedAd> list) {
            Log.i((String)TouTiaoRenderNativeVideo.TAG, (String)"onNativeExpressAdLoad: ");
            if (list == null || list.size() == 0) {
                return;
            }
            TouTiaoRenderNativeVideo.this.mTtNativeExpressAd = list.get(0);
            ToutiaoNativeAd toutiaoNativeAd = new ToutiaoNativeAd(TouTiaoRenderNativeVideo.this.mTtNativeExpressAd);
            toutiaoNativeAd.setRenderType(TouTiaoRenderNativeVideo.this.mIsTemplateRending);
            TouTiaoRenderNativeVideo.this.downloadAndCallback(toutiaoNativeAd, TouTiaoRenderNativeVideo.this.mNeedDownloadImg);
        }
    };

    public void loadCustomAd(Context context, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        String payload;
        Log.i((String)TAG, (String)"loadAdView: ");
        if (this.mLoadAdapterListener == null) {
            return;
        }
        this.mCxt = context;
        if (serverExtras != null && serverExtras.size() > 0) {
            this.mAppId = serverExtras.get("appId");
            this.mPlacementId = serverExtras.get("placementId");
            String template = serverExtras.get("is_template_rendering");
            payload = serverExtras.get("Bidding-Payload");
            if (!TextUtils.isEmpty((CharSequence)template)) {
                this.mIsTemplateRending = Integer.parseInt(template);
            }
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        if (localExtras != null && localExtras.size() > 0) {
            String downLoadImg;
            if (localExtras.containsKey("com_tp_ad_width")) {
                this.mWidth = (Integer)localExtras.get("com_tp_ad_width");
            }
            if (localExtras.containsKey("com_tp_ad_height")) {
                this.mHeight = (Integer)localExtras.get("com_tp_ad_height");
            }
            if (localExtras.containsKey("need_down_load_img") && (downLoadImg = (String)localExtras.get("need_down_load_img")).equals("true")) {
                this.mNeedDownloadImg = true;
            }
        }
        if (this.mWidth == 0 && this.mHeight == 0) {
            this.mWidth = 600;
            this.mHeight = 257;
        }
        Log.i((String)TAG, (String)("Width :" + this.mWidth + ", Height :" + this.mHeight));
        this.adManager = TTAdSdk.getAdManager();
        this.mAdNative = this.adManager.createAdNative(this.mCxt);
        if (!TTAdSdk.isInitSuccess()) {
            final String ttAdm = payload;
            PangleInitManager.getInstance().initSDK(context, localExtras, serverExtras, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                    TouTiaoRenderNativeVideo.this.requestNative(ttAdm);
                }

                public void onFailed(String code, String msg) {
                    if (TouTiaoRenderNativeVideo.this.mLoadAdapterListener != null) {
                        TPError tpError = new TPError("Third-party network SDK failed to init");
                        tpError.setErrorCode(code);
                        tpError.setErrorMessage(msg);
                        TouTiaoRenderNativeVideo.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                    }
                }
            });
        } else {
            this.requestNative(payload);
        }
    }

    private void requestNative(String payload) {
        Log.i((String)TAG, (String)("requestNative TemplateRending: " + this.mIsTemplateRending));
        AdSlot slot = new AdSlot.Builder().setCodeId(this.mPlacementId).setImageAcceptedSize(this.mWidth, this.mHeight).withBid(payload).setAdCount(3).build();
        this.mAdNative.loadFeedAd(slot, this.feedAdListener);
    }

    public void clean() {
        Log.i((String)TAG, (String)"clean: ");
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("19");
    }

    public String getNetworkVersion() {
        return TTAdSdk.getAdManager().getSDKVersion();
    }

    public String getBiddingToken(Context context, Map<String, String> tpParams) {
        return TTAdSdk.getAdManager().getBiddingToken();
    }
}

