/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.fpangolin;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdDislike;
import com.bytedance.sdk.openadsdk.TTAdManager;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTAdSdk;
import com.bytedance.sdk.openadsdk.TTNativeExpressAd;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.banner.TPBannerAdImpl;
import com.tradplus.ads.base.adapter.banner.TPBannerAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.fpangolin.PangleErrorUtil;
import com.tradplus.ads.fpangolin.PangleInitManager;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.List;
import java.util.Map;

public class TouTiaoBanner
extends TPBannerAdapter {
    private String mAppId;
    private TTAdNative mAdNative;
    private String mPlacementId;
    private TTNativeExpressAd mTTAd;
    private TPBannerAdImpl mTpBannerAd;
    private Integer mAdSize;
    private TTAdManager adManager;
    private static final String TAG = "PangleBanner";
    private String payload;
    private int onAdShow = 0;
    TTNativeExpressAd.ExpressAdInteractionListener mExpressAdInteractionListener = new TTNativeExpressAd.ExpressAdInteractionListener(){

        public void onAdClicked(View view, int i) {
            Log.i((String)TouTiaoBanner.TAG, (String)"onAdClicked: ");
            if (TouTiaoBanner.this.mTpBannerAd != null) {
                TouTiaoBanner.this.mTpBannerAd.adClicked();
            }
        }

        public void onAdShow(View view, int i) {
            if (TouTiaoBanner.this.mTpBannerAd != null && TouTiaoBanner.this.onAdShow == 0) {
                Log.i((String)TouTiaoBanner.TAG, (String)"onAdShow: ");
                TouTiaoBanner.this.onAdShow = 1;
                TouTiaoBanner.this.mTpBannerAd.adShown();
            }
        }

        public void onRenderFail(View view, String errorMsg, int errorCode) {
            Log.i((String)TouTiaoBanner.TAG, (String)"onRenderFail: ");
            if (TouTiaoBanner.this.mLoadAdapterListener != null) {
                TouTiaoBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
            }
        }

        public void onRenderSuccess(View view, float v, float v1) {
            Log.i((String)TouTiaoBanner.TAG, (String)"onRenderSuccess: ");
            if (TouTiaoBanner.this.mLoadAdapterListener != null) {
                TouTiaoBanner.this.mAdWidth = TouTiaoBanner.this.mAdWidth / 2;
                TouTiaoBanner.this.mAdHeight = TouTiaoBanner.this.mAdHeight / 2;
                if (!TextUtils.isEmpty((CharSequence)TouTiaoBanner.this.payload)) {
                    TouTiaoBanner.this.setBannerLayoutParams(view);
                }
                TouTiaoBanner.this.mTpBannerAd = new TPBannerAdImpl(null, view);
                TouTiaoBanner.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)TouTiaoBanner.this.mTpBannerAd);
            }
        }
    };

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (tpParams != null && tpParams.size() > 0) {
            this.mAppId = tpParams.get("appId");
            this.mPlacementId = tpParams.get("placementId");
            this.payload = tpParams.get("Bidding-Payload");
            this.setAdHeightAndWidthByService(this.mPlacementId, tpParams);
            this.setDefaultAdSize(640, 100);
        }
        this.setAdHeightAndWidthByUser(userParams);
        this.adManager = TTAdSdk.getAdManager();
        this.mAdNative = this.adManager.createAdNative(context);
        if (!TTAdSdk.isInitSuccess()) {
            final String ttAdm = this.payload;
            PangleInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

                public void onSuccess() {
                    TouTiaoBanner.this.requestBanner(ttAdm);
                }

                public void onFailed(String code, String msg) {
                    if (TouTiaoBanner.this.mLoadAdapterListener != null) {
                        TPError tpError = new TPError("Third-party network SDK failed to init");
                        tpError.setErrorCode(code);
                        tpError.setErrorMessage(msg);
                        TouTiaoBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                    }
                }
            });
        } else {
            this.requestBanner(this.payload);
        }
    }

    private void requestBanner(String bidAdm) {
        AdSlot adSlot = new AdSlot.Builder().setCodeId(this.mPlacementId).setAdCount(1).withBid(bidAdm).setImageAcceptedSize(this.mAdWidth, this.mAdHeight).setExpressViewAcceptedSize(this.mAdViewWidth <= 0 ? (float)(this.mAdWidth / 2) : (float)this.mAdViewWidth, this.mAdViewHeight <= 0 ? (float)(this.mAdHeight / 2) : (float)this.mAdViewHeight).build();
        this.mAdNative.loadBannerExpressAd(adSlot, new TTAdNative.NativeExpressAdListener(){

            public void onError(int errorCode, String errorMsg) {
                Log.i((String)TouTiaoBanner.TAG, (String)("onError: errorCode : " + errorCode + ", errorMsg :" + errorMsg));
                if (TouTiaoBanner.this.mLoadAdapterListener != null) {
                    TouTiaoBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(PangleErrorUtil.getTradPlusErrorCode(errorCode, errorMsg));
                }
            }

            public void onNativeExpressAdLoad(List<TTNativeExpressAd> list) {
                if (list == null || list.size() == 0) {
                    return;
                }
                TouTiaoBanner.this.mTTAd = list.get(0);
                TouTiaoBanner.this.mTTAd.setSlideIntervalTime(0);
                TouTiaoBanner.this.mTTAd.setExpressInteractionListener(TouTiaoBanner.this.mExpressAdInteractionListener);
                Context context = GlobalTradPlus.getInstance().getContext();
                if (context == null) {
                    if (TouTiaoBanner.this.mLoadAdapterListener != null) {
                        TPError tpError = new TPError("Context == null");
                        tpError.setErrorMessage("context == null");
                        TouTiaoBanner.this.mLoadAdapterListener.loadAdapterLoadFailed(tpError);
                    }
                    return;
                }
                Activity activity = GlobalTradPlus.getInstance().getActivity();
                if (activity != null) {
                    TouTiaoBanner.this.bindDislike(activity, TouTiaoBanner.this.mTTAd, false);
                }
                TouTiaoBanner.this.mTTAd.render();
            }
        });
    }

    private void bindDislike(Activity activity, TTNativeExpressAd ad, boolean customStyle) {
        ad.setDislikeCallback(activity, new TTAdDislike.DislikeInteractionCallback(){

            public void onSelected(int i, String s) {
                Log.i((String)TouTiaoBanner.TAG, (String)"onSelected: ");
                if (TouTiaoBanner.this.mTpBannerAd != null) {
                    TouTiaoBanner.this.mTpBannerAd.adClosed();
                }
            }

            public void onCancel() {
                Log.i((String)TouTiaoBanner.TAG, (String)"onCancel: ");
            }

            public void onRefuse() {
            }
        });
    }

    public void clean() {
        if (this.mTTAd != null) {
            this.mTTAd.setExpressInteractionListener(null);
            this.mTTAd.setVideoAdListener(null);
            this.mTTAd.destroy();
            this.mTTAd = null;
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("19");
    }

    public String getNetworkVersion() {
        return TTAdSdk.getAdManager().getSDKVersion();
    }

    public void getBiddingToken(Context context, Map<String, String> tpParams, Map<String, Object> localParams, final TPBaseAdapter.OnS2STokenListener onS2STokenListener) {
        PangleInitManager.getInstance().initSDK(context, localParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                Log.i((String)TouTiaoBanner.TAG, (String)"onSuccess: ");
                PangleInitManager.getInstance().sendInitRequest(true, "2");
                onS2STokenListener.onTokenResult(TTAdSdk.getAdManager().getBiddingToken());
            }

            public void onFailed(String code, String msg) {
                PangleInitManager.getInstance().sendInitRequest(false, "2");
                onS2STokenListener.onTokenResult("");
            }
        });
    }

    static /* synthetic */ int access$500(TouTiaoBanner x0) {
        return x0.mAdWidth;
    }

    static /* synthetic */ int access$800(TouTiaoBanner x0) {
        return x0.mAdHeight;
    }
}

